/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.registry.EntityRegistry;

public class EntityFlyingPig
extends AnimalEntity
implements IFlyingAnimal {
    private static final DataParameter<Byte> FLAGS = EntityDataManager.func_187226_a(EntityFlyingPig.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final int BIT_ROOSTING = 0;
    private static final int BIT_WARTED = 1;
    private Goal preGoal;

    public EntityFlyingPig(EntityType<? extends EntityFlyingPig> type, World world) {
        super(type, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70728_aV = 2;
        this.field_70747_aH = 0.3f;
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new FindFoodGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SittingGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new RoostingGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WanderAroundGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
    }

    public static AttributeModifierMap getAttributeContainer() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233819_b_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233822_e_, 0.3).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 1.0).func_233813_a_();
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator birdnavigator = new FlyingPathNavigator((MobEntity)this, world){

            public boolean func_188555_b(BlockPos pos) {
                return this.field_75513_b.func_175623_d(pos);
            }
        };
        birdnavigator.func_192879_a(false);
        birdnavigator.func_212239_d(true);
        birdnavigator.func_192878_b(true);
        return birdnavigator;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLAGS, (Object)MHelper.setBit((byte)0, 1, this.field_70146_Z.nextInt(4) == 0));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a("byteData", ((Byte)this.field_70180_af.func_187225_a(FLAGS)).byteValue());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("byteData")) {
            this.field_70180_af.func_187227_b(FLAGS, (Object)tag.func_74771_c("byteData"));
        }
    }

    public boolean isRoosting() {
        byte b = (Byte)this.field_70180_af.func_187225_a(FLAGS);
        return MHelper.getBit(b, 0);
    }

    public void setRoosting(boolean roosting) {
        byte b = (Byte)this.field_70180_af.func_187225_a(FLAGS);
        this.field_70180_af.func_187227_b(FLAGS, (Object)MHelper.setBit(b, 0, roosting));
    }

    public boolean isWarted() {
        byte b = (Byte)this.field_70180_af.func_187225_a(FLAGS);
        return MHelper.getBit(b, 1);
    }

    public void setWarted(boolean warted) {
        byte b = (Byte)this.field_70180_af.func_187225_a(FLAGS);
        this.field_70180_af.func_187227_b(FLAGS, (Object)MHelper.setBit(b, 1, warted));
    }

    protected float func_70599_aP() {
        return MHelper.randRange(0.85f, 1.15f, this.field_70146_Z);
    }

    protected float func_70647_i() {
        return MHelper.randRange(0.3f, 0.4f, this.field_70146_Z);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187703_dN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    public SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    protected void func_70609_aI() {
        if (!this.field_70170_p.field_72995_K && this.isWarted() && this.field_70170_p.func_73046_m().func_200252_aR().func_223586_b(GameRules.field_223604_g)) {
            this.func_199701_a_(new ItemStack((IItemProvider)Items.field_151075_bm, MHelper.randRange(1, 3, this.field_70146_Z)));
        }
        super.func_70609_aI();
    }

    public int func_70641_bl() {
        return 5;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        EntityFlyingPig pig = (EntityFlyingPig)EntityRegistry.FLYING_PIG.func_200721_a(this.field_70170_p);
        pig.setWarted(pig.isWarted());
        return pig;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151075_bm;
    }

    class FindFoodGoal
    extends Goal {
        private List<ItemEntity> foods;
        private ItemEntity target;

        FindFoodGoal() {
        }

        public boolean func_75250_a() {
            return this.hasNearFood();
        }

        public void func_75249_e() {
            BlockPos pos = this.getFood();
            Path path = EntityFlyingPig.this.field_70699_by.func_179680_a(pos, 1);
            if (path != null) {
                EntityFlyingPig.this.field_70699_by.func_75484_a(path, (double)EntityFlyingPig.this.field_70747_aH);
                EntityFlyingPig.this.setRoosting(false);
            }
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            return this.target.func_70089_S() && EntityFlyingPig.this.field_70699_by.func_226337_n_();
        }

        public void func_75251_c() {
            if (this.target.func_70089_S() && (double)this.target.func_70032_d((Entity)EntityFlyingPig.this) < 1.3) {
                ItemStack stack = this.target.func_92059_d();
                ItemParticleData effect = new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)stack.func_77973_b()));
                for (ServerPlayerEntity serverPlayerEntity : EntityFlyingPig.this.field_70170_p.func_217369_A()) {
                    if (!(serverPlayerEntity.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_()) < 4096.0)) continue;
                    serverPlayerEntity.field_71135_a.func_147359_a((IPacket)new SSpawnParticlePacket((IParticleData)effect, false, this.target.func_226277_ct_(), this.target.func_226278_cu_() + 0.2, this.target.func_226281_cx_(), 0.2f, 0.2f, 0.2f, 0.0f, 16));
                }
                EntityFlyingPig.this.func_213357_a(EntityFlyingPig.this.field_70170_p, stack);
                this.target.func_174812_G();
                EntityFlyingPig.this.func_70691_i(stack.func_190916_E());
                EntityFlyingPig.this.func_70016_h(0.0, 0.2f, 0.0);
            }
            EntityFlyingPig.this.preGoal = this;
            super.func_75251_c();
        }

        private BlockPos getFood() {
            this.target = this.foods.get(EntityFlyingPig.this.field_70146_Z.nextInt(this.foods.size()));
            return this.target.func_233580_cy_();
        }

        private boolean hasNearFood() {
            AxisAlignedBB AxisAlignedBB2 = new AxisAlignedBB(EntityFlyingPig.this.func_233580_cy_()).func_186662_g(16.0);
            this.foods = EntityFlyingPig.this.field_70170_p.func_175647_a(ItemEntity.class, AxisAlignedBB2, entity -> entity.func_92059_d().func_222117_E());
            return !this.foods.isEmpty();
        }
    }

    class SittingGoal
    extends Goal {
        int timer;
        int ammount;

        SittingGoal() {
        }

        public boolean func_75250_a() {
            return EntityFlyingPig.this.isRoosting();
        }

        public boolean func_75253_b() {
            return this.timer < this.ammount;
        }

        public void func_75249_e() {
            this.timer = 0;
            this.ammount = MHelper.randRange(80, 160, EntityFlyingPig.this.field_70146_Z);
            EntityFlyingPig.this.func_213293_j(0.0, 0.0, 0.0);
            EntityFlyingPig.this.func_181013_g(EntityFlyingPig.this.field_70146_Z.nextFloat() * ((float)Math.PI * 2));
            super.func_75249_e();
        }

        public void func_75251_c() {
            EntityFlyingPig.this.setRoosting(false);
            EntityFlyingPig.this.func_213293_j(0.0, -0.1f, 0.0);
            EntityFlyingPig.this.preGoal = this;
            super.func_75251_c();
        }

        public void func_75246_d() {
            ++this.timer;
            super.func_75246_d();
        }
    }

    class RoostingGoal
    extends Goal {
        BlockPos roosting;

        RoostingGoal() {
        }

        public boolean func_75250_a() {
            return !(EntityFlyingPig.this.preGoal instanceof SittingGoal) && EntityFlyingPig.this.field_70699_by.func_75500_f() && !EntityFlyingPig.this.isRoosting() && EntityFlyingPig.this.field_70146_Z.nextInt(4) == 0;
        }

        public boolean func_75253_b() {
            return EntityFlyingPig.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Path path;
            BlockPos pos = this.getRoostingLocation();
            if (pos != null && (path = EntityFlyingPig.this.field_70699_by.func_179680_a(pos, 1)) != null) {
                EntityFlyingPig.this.field_70699_by.func_75484_a(path, (double)EntityFlyingPig.this.field_70747_aH);
                this.roosting = pos;
            }
            super.func_75249_e();
        }

        public void func_75251_c() {
            if (this.roosting != null) {
                EntityFlyingPig.this.func_70107_b((double)this.roosting.func_177958_n() + 0.5, (double)this.roosting.func_177956_o() - 0.25, (double)this.roosting.func_177952_p() + 0.5);
                EntityFlyingPig.this.setRoosting(true);
                EntityFlyingPig.this.preGoal = this;
            }
            super.func_75251_c();
        }

        private BlockPos getRoostingLocation() {
            BlockPos pos = EntityFlyingPig.this.func_233580_cy_();
            World world = EntityFlyingPig.this.field_70170_p;
            int up = BlocksHelper.upRay((IWorld)world, pos, 16);
            if (world.func_180495_p((pos = pos.func_177967_a(Direction.UP, up)).func_177984_a()).func_177230_c() == Blocks.field_189878_dg) {
                return pos;
            }
            return null;
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityFlyingPig.this.field_70699_by.func_75500_f() && !EntityFlyingPig.this.isRoosting();
        }

        public boolean func_75253_b() {
            return EntityFlyingPig.this.field_70699_by.func_226337_n_() && EntityFlyingPig.this.field_70146_Z.nextInt(32) > 0;
        }

        public void func_75249_e() {
            if (EntityFlyingPig.this.field_70170_p.func_204610_c(EntityFlyingPig.this.func_233580_cy_()).func_206888_e()) {
                BlockPos pos = this.getRandomLocation();
                Path path = EntityFlyingPig.this.field_70699_by.func_179680_a(pos, 1);
                if (path != null) {
                    EntityFlyingPig.this.field_70699_by.func_75484_a(path, (double)EntityFlyingPig.this.field_70747_aH);
                } else {
                    EntityFlyingPig.this.func_213293_j(0.0, -0.2, 0.0);
                }
                EntityFlyingPig.this.setRoosting(false);
            } else {
                EntityFlyingPig.this.func_213293_j(0.0, 1.0, 0.0);
            }
            super.func_75249_e();
        }

        private BlockPos getRandomLocation() {
            BlockPos.Mutable bpos = new BlockPos.Mutable();
            bpos.func_189532_c(EntityFlyingPig.this.func_226277_ct_(), EntityFlyingPig.this.func_226278_cu_(), EntityFlyingPig.this.func_226281_cx_());
            Vector3d angle = EntityFlyingPig.this.func_70676_i(0.0f);
            Vector3d airTarget = RandomPositionGenerator.func_226340_a_((CreatureEntity)EntityFlyingPig.this, (int)8, (int)7, (Vector3d)angle, (float)1.5707964f, (int)2, (int)1);
            if (airTarget == null) {
                airTarget = RandomPositionGenerator.func_226340_a_((CreatureEntity)EntityFlyingPig.this, (int)32, (int)10, (Vector3d)angle, (float)1.5707964f, (int)3, (int)1);
            }
            if (airTarget == null) {
                bpos.func_223471_o(bpos.func_177958_n() + this.randomRange(32));
                bpos.func_223472_q(bpos.func_177952_p() + this.randomRange(32));
                bpos.func_185336_p(bpos.func_177956_o() + this.randomRange(32));
                return bpos;
            }
            bpos.func_189532_c(airTarget.func_82615_a(), airTarget.func_82617_b(), airTarget.func_82616_c());
            BlockPos down = bpos.func_177977_b();
            if (EntityFlyingPig.this.field_70170_p.func_180495_p(down).func_235785_r_((IBlockReader)EntityFlyingPig.this.field_70170_p, down)) {
                bpos.func_189536_c(Direction.UP);
            }
            while (!EntityFlyingPig.this.field_70170_p.func_204610_c((BlockPos)bpos).func_206888_e()) {
                bpos.func_189536_c(Direction.UP);
            }
            return bpos;
        }

        private int randomRange(int side) {
            Random rand = EntityFlyingPig.this.field_70146_Z;
            return rand.nextInt(side + 1) - (side >> 1);
        }

        public void func_75251_c() {
            EntityFlyingPig.this.preGoal = this;
            super.func_75251_c();
        }
    }
}

