/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.registry.SoundsRegistry;

public class EntityHydrogenJellyfish
extends AnimalEntity
implements IFlyingAnimal {
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityHydrogenJellyfish.class, (IDataSerializer)DataSerializers.field_187193_c);
    private Vector3d preVelocity;
    private Vector3d newVelocity = new Vector3d(0.0, 0.0, 0.0);
    private int timer;
    private int timeOut;
    private float prewYaw;
    private float nextYaw;

    public EntityHydrogenJellyfish(EntityType<? extends EntityHydrogenJellyfish> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(0.5f + this.field_70146_Z.nextFloat()));
    }

    public static AttributeModifierMap getAttributeContainer() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 0.5).func_233815_a_(Attributes.field_233822_e_, 0.05).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233823_f_, 20.0).func_233813_a_();
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected void func_180466_bG(ITag<Fluid> fluid) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
    }

    public boolean func_225502_at_() {
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74776_a("Scale", this.getScale());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("Scale")) {
            this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(tag.func_74760_g("Scale")));
        }
        this.func_213323_x_();
    }

    public float getScale() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
    }

    public EntitySize getDimensions(Pose pose) {
        return super.func_213305_a(pose).func_220313_a(this.getScale());
    }

    public void func_70100_b_(PlayerEntity player) {
        player.func_70097_a(DamageSource.field_76377_j, 3.0f);
    }

    public void func_213323_x_() {
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(x, y, z);
    }

    public void func_184206_a(DataParameter<?> data) {
        if (SCALE.equals(data)) {
            this.func_213323_x_();
        }
    }

    protected void func_70619_bc() {
        ++this.timer;
        if (this.timer > this.timeOut) {
            this.prewYaw = this.field_70177_z;
            this.nextYaw = this.field_70146_Z.nextFloat() * 360.0f;
            double rads = Math.toRadians(this.nextYaw + 90.0f);
            double vx = Math.cos(rads) * (double)this.field_70747_aH;
            double vz = Math.sin(rads) * (double)this.field_70747_aH;
            BlockPos bp = this.func_233580_cy_();
            double vy = this.field_70146_Z.nextDouble() * (double)this.field_70747_aH * 0.75;
            if (this.field_70170_p.func_180495_p(bp).func_177230_c().isAir(this.field_70170_p.func_180495_p(bp), (IBlockReader)this.field_70170_p, bp) && this.field_70170_p.func_180495_p(bp.func_177979_c(2)).func_177230_c().isAir(this.field_70170_p.func_180495_p(bp.func_177979_c(2)), (IBlockReader)this.field_70170_p, bp.func_177979_c(2)) && this.field_70170_p.func_180495_p(bp.func_177979_c(3)).func_177230_c().isAir(this.field_70170_p.func_180495_p(bp.func_177979_c(3)), (IBlockReader)this.field_70170_p, bp.func_177979_c(3)) && this.field_70170_p.func_180495_p(bp.func_177979_c(4)).func_177230_c().isAir(this.field_70170_p.func_180495_p(bp.func_177979_c(4)), (IBlockReader)this.field_70170_p, bp.func_177979_c(4))) {
                vy = -vy;
            }
            this.preVelocity = this.newVelocity;
            this.newVelocity = new Vector3d(vx, vy, vz);
            this.timer = 0;
            this.timeOut = this.field_70146_Z.nextInt(300) + 120;
        }
        if (this.timer <= 120) {
            if (this.field_70177_z != this.nextYaw) {
                float delta = (float)this.timer / 120.0f;
                this.field_70177_z = EntityHydrogenJellyfish.lerpAngleDegrees(delta, this.prewYaw, this.nextYaw);
                this.func_213293_j(MathHelper.func_219803_d((double)delta, (double)this.preVelocity.field_72450_a, (double)this.newVelocity.field_72450_a), MathHelper.func_219803_d((double)delta, (double)this.preVelocity.field_72448_b, (double)this.newVelocity.field_72448_b), MathHelper.func_219803_d((double)delta, (double)this.preVelocity.field_72449_c, (double)this.newVelocity.field_72449_c));
            }
        } else {
            this.func_213317_d(this.newVelocity);
        }
    }

    public static float lerpAngleDegrees(float delta, float first, float second) {
        return first + delta * MathHelper.func_76142_g((float)(second - first));
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (this.field_70170_p.field_72995_K) {
            float scale = 3.0f * this.getScale();
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * (double)scale, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * (double)scale, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * (double)scale, 0.0, 0.0, 0.0);
            }
        } else {
            Explosion.Mode destructionType = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 7.0f * this.getScale(), destructionType);
        }
    }

    public SoundEvent func_184639_G() {
        return SoundsRegistry.MOB_JELLYFISH;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_82727_n || source instanceof EntityDamageSource) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public static boolean canSpawn(EntityType<? extends EntityHydrogenJellyfish> type, IWorld world, SpawnReason spawnReason, BlockPos pos, Random rand) {
        AxisAlignedBB box = new AxisAlignedBB(pos).func_72321_a(64.0, 256.0, 64.0);
        List list = world.func_175647_a(EntityHydrogenJellyfish.class, box, entity -> true);
        return list.size() < 4;
    }
}

