/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import someoneelse.betternetherreforged.entity.EntityNaga;

public class ModelNaga
extends AgeableModel<EntityNaga> {
    public ModelRenderer head;
    public ModelRenderer body;
    public ModelRenderer[] tail;
    public ModelRenderer[] spikes;
    private float rotateAngleX;
    private float maxAngle = 0.1f;

    public ModelNaga() {
        this.field_78089_u = 64;
        this.field_78090_t = 64;
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_228300_a_(-5.0f, -10.0f, -7.0f, 10.0f, 10.0f, 10.0f);
        this.head.func_78793_a(0.0f, -9.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 40, 0);
        this.body.func_228300_a_(-2.0f, 0.0f, -1.0f, 4.0f, 20.0f, 2.0f);
        this.body.func_78784_a(0, 20);
        this.body.func_228300_a_(-5.0f, 3.0f, -6.0f, 10.0f, 16.0f, 6.0f);
        this.body.func_78793_a(0.0f, -10.0f, 0.0f);
        this.spikes = new ModelRenderer[8];
        this.spikes[0] = new ModelRenderer((Model)this, 33, 25);
        this.spikes[0].func_228300_a_(0.0f, 0.0f, 0.0f, 10.0f, 18.0f, 0.0f);
        this.spikes[0].func_78793_a(0.0f, 0.0f, 0.0f);
        this.spikes[0].field_78796_g = (float)Math.toRadians(-40.0);
        this.body.func_78792_a(this.spikes[0]);
        this.spikes[1] = new ModelRenderer((Model)this, 33, 25);
        this.spikes[1].func_228300_a_(0.0f, 0.0f, 0.0f, 10.0f, 18.0f, 0.0f);
        this.spikes[1].func_78793_a(0.0f, 0.0f, 0.0f);
        this.spikes[1].field_78796_g = (float)Math.toRadians(-140.0);
        this.body.func_78792_a(this.spikes[1]);
        this.tail = new ModelRenderer[4];
        int last = this.tail.length - 1;
        for (int i = 0; i < this.tail.length; ++i) {
            int width;
            int height = (this.tail.length - i) * 4 / this.tail.length;
            if (height < 2) {
                height = 2;
            }
            if ((width = Math.round((float)height / 2.0f)) < 1) {
                width = 1;
            }
            this.tail[i] = new ModelRenderer((Model)this, 40, 0);
            this.tail[i].func_228300_a_((float)(-height) * 0.5f, 0.0f, (float)(-width) * 0.5f, (float)height, 20.0f, (float)width);
            this.tail[i].func_78793_a(0.0f, 19.0f, 0.0f);
            if (i < last) {
                int px = 32 + (12 - height * 3);
                int index = (i << 1) + 2;
                this.spikes[index] = new ModelRenderer((Model)this, px, 22);
                this.spikes[index].func_228300_a_(0.0f, 0.0f, 0.0f, (float)(height * 3), 20.0f, 0.0f);
                this.spikes[index].func_78793_a(0.0f, 0.0f, 0.0f);
                this.spikes[index].field_78796_g = (float)Math.toRadians(-60.0);
                this.tail[i].func_78792_a(this.spikes[index]);
                this.spikes[++index] = new ModelRenderer((Model)this, px, 22);
                this.spikes[index].func_228300_a_(0.0f, 0.0f, 0.0f, (float)(height * 3), 20.0f, 0.0f);
                this.spikes[index].func_78793_a(0.0f, 0.0f, 0.0f);
                this.spikes[index].field_78796_g = (float)Math.toRadians(-120.0);
                this.tail[i].func_78792_a(this.spikes[index]);
            }
            if (i == 0) {
                this.body.func_78792_a(this.tail[i]);
                continue;
            }
            this.tail[i - 1].func_78792_a(this.tail[i]);
        }
        this.tail[0].field_78795_f = (float)Math.toRadians(45.0);
        this.tail[1].field_78795_f = (float)Math.toRadians(45.0);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body);
    }

    public void setLivingAnimations(EntityNaga livingEntity, float f, float g, float h) {
        this.rotateAngleX = livingEntity.func_205015_b(h);
        super.func_212843_a_((Entity)livingEntity, f, g, h);
    }

    public void setRotationAngles(EntityNaga entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        int i;
        float angle;
        boolean rollTooBig = entity.func_184599_cB() > 4;
        boolean isSwimming = entity.func_213314_bj();
        this.head.field_78796_g = headYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = rollTooBig ? -0.7853982f : (this.rotateAngleX > 0.0f ? (isSwimming ? this.lerpAngle(this.head.field_78795_f, -0.7853982f, this.rotateAngleX) : this.lerpAngle(this.head.field_78795_f, headPitch * ((float)Math.PI / 180), this.rotateAngleX)) : headPitch * ((float)Math.PI / 180));
        double speed = entity.func_233570_aj_() && (entity.func_213322_ci().field_72450_a != 0.0 || entity.func_213322_ci().field_72449_c != 0.0) && !entity.func_184218_aH() ? 6.0 : 0.5;
        this.maxAngle = this.lerpAngle(this.maxAngle, speed > 1.0 ? 0.1f : 0.5f, 0.03f);
        double animation = (double)animationProgress * speed / 20.0;
        float start_angle = angle = (float)Math.sin(animation) * this.maxAngle * 0.3f;
        this.tail[0].field_78796_g = angle;
        for (i = 1; i < this.tail.length; ++i) {
            angle = (float)Math.atan(Math.sin((double)i * 1.7 + animation)) * this.maxAngle;
            this.tail[i].field_78808_h = angle - start_angle;
            start_angle += angle;
        }
        for (i = 0; i < this.spikes.length; ++i) {
            float rotateAngleY;
            this.spikes[i].field_78796_g = rotateAngleY = (i & 1) == 0 ? (float)Math.toRadians(-50.0 + Math.sin(animation * 0.4 + (double)(i / 2)) * 10.0) : (float)Math.toRadians(-110.0 - Math.sin(animation * 0.4 + (double)(i / 2)) * 10.0);
        }
    }

    protected float lerpAngle(float from, float to, float position) {
        float angle = (to - from) % ((float)Math.PI * 2);
        if (angle < (float)(-Math.PI)) {
            angle += (float)Math.PI * 2;
        }
        if (angle >= (float)Math.PI) {
            angle -= (float)Math.PI * 2;
        }
        return from + position * angle;
    }
}

