/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.shapes.FoodShape;
import someoneelse.betternetherreforged.config.Configs;
import someoneelse.betternetherreforged.items.BNArmor;
import someoneelse.betternetherreforged.items.BNItemAxe;
import someoneelse.betternetherreforged.items.BNItemHoe;
import someoneelse.betternetherreforged.items.BNItemPickaxe;
import someoneelse.betternetherreforged.items.BNItemShovel;
import someoneelse.betternetherreforged.items.BNSword;
import someoneelse.betternetherreforged.items.ItemBlackApple;
import someoneelse.betternetherreforged.items.ItemBowlFood;
import someoneelse.betternetherreforged.items.materials.BNItemMaterials;
import someoneelse.betternetherreforged.registry.EntityRegistry;
import someoneelse.betternetherreforged.tab.CreativeTab;

public class ItemsRegistry {
    private static final List<String> ITEMS = new ArrayList<String>();
    private static final List<Pair<String, Item>> MODITEMS = new ArrayList<Pair<String, Item>>();
    public static final ArrayList<Item> MOD_BLOCKS = new ArrayList();
    public static final ArrayList<Item> MOD_ITEMS = new ArrayList();
    private static final int ALPHA = -16777216;
    public static final Item BLACK_APPLE = ItemsRegistry.registerItem("black_apple", new ItemBlackApple());
    public static final Item STALAGNATE_BOWL = ItemsRegistry.registerItem("stalagnate_bowl", new ItemBowlFood(null, FoodShape.NONE));
    public static final Item STALAGNATE_BOWL_WART = ItemsRegistry.registerItem("stalagnate_bowl_wart", new ItemBowlFood(Foods.field_221436_l, FoodShape.WART));
    public static final Item STALAGNATE_BOWL_MUSHROOM = ItemsRegistry.registerItem("stalagnate_bowl_mushroom", new ItemBowlFood(Foods.field_221448_x, FoodShape.MUSHROOM));
    public static final Item STALAGNATE_BOWL_APPLE = ItemsRegistry.registerItem("stalagnate_bowl_apple", new ItemBowlFood(Foods.field_221425_a, FoodShape.APPLE));
    public static final Item HOOK_MUSHROOM = ItemsRegistry.registerFood("hook_mushroom_cooked", 4, 0.4f);
    public static final Item CINCINNASITE = ItemsRegistry.registerItem("cincinnasite", new Item(ItemsRegistry.defaultSettings()));
    public static final Item CINCINNASITE_INGOT = ItemsRegistry.registerItem("cincinnasite_ingot", new Item(ItemsRegistry.defaultSettings()));
    public static final Item CINCINNASITE_PICKAXE = ItemsRegistry.registerItem("cincinnasite_pickaxe", (Item)new BNItemPickaxe(BNItemMaterials.CINCINNASITE_TOOLS, 512, 1.0f));
    public static final Item CINCINNASITE_PICKAXE_DIAMOND = ItemsRegistry.registerItem("cincinnasite_pickaxe_diamond", (Item)new BNItemPickaxe(BNItemMaterials.CINCINNASITE_DIAMOND_TOOLS, 2048, 1.5f));
    public static final Item CINCINNASITE_AXE = ItemsRegistry.registerItem("cincinnasite_axe", (Item)new BNItemAxe(BNItemMaterials.CINCINNASITE_TOOLS, 512, 1.0f));
    public static final Item CINCINNASITE_AXE_DIAMOND = ItemsRegistry.registerItem("cincinnasite_axe_diamond", (Item)new BNItemAxe(BNItemMaterials.CINCINNASITE_DIAMOND_TOOLS, 2048, 1.5f));
    public static final Item CINCINNASITE_SHOVEL = ItemsRegistry.registerItem("cincinnasite_shovel", (Item)new BNItemShovel(BNItemMaterials.CINCINNASITE_TOOLS, 512, 1.0f));
    public static final Item CINCINNASITE_SHOVEL_DIAMOND = ItemsRegistry.registerItem("cincinnasite_shovel_diamond", (Item)new BNItemShovel(BNItemMaterials.CINCINNASITE_DIAMOND_TOOLS, 2048, 1.5f));
    public static final Item CINCINNASITE_HOE = ItemsRegistry.registerItem("cincinnasite_hoe", (Item)new BNItemHoe(BNItemMaterials.CINCINNASITE_TOOLS, 512, 1.0f));
    public static final Item CINCINNASITE_HOE_DIAMOND = ItemsRegistry.registerItem("cincinnasite_hoe_diamond", (Item)new BNItemHoe(BNItemMaterials.CINCINNASITE_DIAMOND_TOOLS, 2048, 1.5f));
    public static final Item CINCINNASITE_SHEARS = ItemsRegistry.registerItem("cincinnasite_shears", (Item)new ShearsItem(ItemsRegistry.defaultSettings().func_200918_c(380)));
    public static final Item CINCINNASITE_HELMET = ItemsRegistry.registerItem("cincinnasite_helmet", (Item)new BNArmor(BNItemMaterials.CINCINNASITE_ARMOR, EquipmentSlotType.HEAD));
    public static final Item CINCINNASITE_CHESTPLATE = ItemsRegistry.registerItem("cincinnasite_chestplate", (Item)new BNArmor(BNItemMaterials.CINCINNASITE_ARMOR, EquipmentSlotType.CHEST));
    public static final Item CINCINNASITE_LEGGINGS = ItemsRegistry.registerItem("cincinnasite_leggings", (Item)new BNArmor(BNItemMaterials.CINCINNASITE_ARMOR, EquipmentSlotType.LEGS));
    public static final Item CINCINNASITE_BOOTS = ItemsRegistry.registerItem("cincinnasite_boots", (Item)new BNArmor(BNItemMaterials.CINCINNASITE_ARMOR, EquipmentSlotType.FEET));
    public static final Item CINCINNASITE_SWORD = ItemsRegistry.registerItem("cincinnasite_sword", (Item)new BNSword(BNItemMaterials.CINCINNASITE_TOOLS, 512, 4, -2.4f));
    public static final Item CINCINNASITE_SWORD_DIAMOND = ItemsRegistry.registerItem("cincinnasite_sword_diamond", (Item)new BNSword(BNItemMaterials.CINCINNASITE_DIAMOND_TOOLS, 2048, 5, -2.4f));
    public static final Item NETHER_RUBY = ItemsRegistry.registerItem("nether_ruby", new Item(ItemsRegistry.defaultSettings()));
    public static final Item NETHER_RUBY_PICKAXE = ItemsRegistry.registerItem("nether_ruby_pickaxe", (Item)new BNItemPickaxe(BNItemMaterials.NETHER_RUBY_TOOLS, 512, 1.0f));
    public static final Item NETHER_RUBY_AXE = ItemsRegistry.registerItem("nether_ruby_axe", (Item)new BNItemAxe(BNItemMaterials.NETHER_RUBY_TOOLS, 512, 1.0f));
    public static final Item NETHER_RUBY_SHOVEL = ItemsRegistry.registerItem("nether_ruby_shovel", (Item)new BNItemShovel(BNItemMaterials.NETHER_RUBY_TOOLS, 512, 1.0f));
    public static final Item NETHER_RUBY_HOE = ItemsRegistry.registerItem("nether_ruby_hoe", (Item)new BNItemHoe(BNItemMaterials.NETHER_RUBY_TOOLS, 512, 1.0f));
    public static final Item NETHER_RUBY_SWORD = ItemsRegistry.registerItem("nether_ruby_sword", (Item)new BNSword(BNItemMaterials.NETHER_RUBY_TOOLS, 512, 4, -2.4f));
    public static final Item NETHER_RUBY_HELMET = ItemsRegistry.registerItem("nether_ruby_helmet", (Item)new BNArmor(BNItemMaterials.NETHER_RUBY_ARMOR, EquipmentSlotType.HEAD));
    public static final Item NETHER_RUBY_CHESTPLATE = ItemsRegistry.registerItem("nether_ruby_chestplate", (Item)new BNArmor(BNItemMaterials.NETHER_RUBY_ARMOR, EquipmentSlotType.CHEST));
    public static final Item NETHER_RUBY_LEGGINGS = ItemsRegistry.registerItem("nether_ruby_leggings", (Item)new BNArmor(BNItemMaterials.NETHER_RUBY_ARMOR, EquipmentSlotType.LEGS));
    public static final Item NETHER_RUBY_BOOTS = ItemsRegistry.registerItem("nether_ruby_boots", (Item)new BNArmor(BNItemMaterials.NETHER_RUBY_ARMOR, EquipmentSlotType.FEET));
    public static final Item SPAWN_EGG_FIREFLY = ItemsRegistry.registerItem("spawn_egg_firefly", ItemsRegistry.makeEgg("firefly", EntityRegistry.FIREFLY, ItemsRegistry.color(255, 223, 168), ItemsRegistry.color(233, 182, 95)));
    public static final Item SPAWN_EGG_JELLYFISH = ItemsRegistry.registerItem("spawn_egg_hydrogen_jellyfish", ItemsRegistry.makeEgg("hydrogen_jellyfish", EntityRegistry.HYDROGEN_JELLYFISH, ItemsRegistry.color(253, 164, 24), ItemsRegistry.color(88, 21, 4)));
    public static final Item SPAWN_NAGA = ItemsRegistry.registerItem("spawn_egg_naga", ItemsRegistry.makeEgg("naga", EntityRegistry.NAGA, MHelper.color(12, 12, 12), MHelper.color(210, 90, 26)));
    public static final Item SPAWN_FLYING_PIG = ItemsRegistry.registerItem("spawn_egg_flying_pig", ItemsRegistry.makeEgg("flying_pig", EntityRegistry.FLYING_PIG, MHelper.color(241, 140, 93), MHelper.color(176, 58, 47)));
    public static final Item SPAWN_JUNGLE_SKELETON = ItemsRegistry.registerItem("spawn_egg_jungle_skeleton", ItemsRegistry.makeEgg("jungle_skeleton", EntityRegistry.JUNGLE_SKELETON, MHelper.color(134, 162, 149), MHelper.color(6, 111, 79)));
    public static final Item SPAWN_SKULL = ItemsRegistry.registerItem("spawn_egg_skull", ItemsRegistry.makeEgg("skull", EntityRegistry.SKULL, MHelper.color(24, 19, 19), MHelper.color(255, 28, 18)));
    public static final Item GLOWSTONE_PILE = ItemsRegistry.registerItem("glowstone_pile", new Item(ItemsRegistry.defaultSettings()));
    public static final Item LAPIS_PILE = ItemsRegistry.registerItem("lapis_pile", new Item(ItemsRegistry.defaultSettings()));
    public static final Item AGAVE_LEAF = ItemsRegistry.registerItem("agave_leaf", new Item(ItemsRegistry.defaultSettings()));
    public static final Item AGAVE_MEDICINE = ItemsRegistry.registerMedicine("agave_medicine", 40, 2, true);
    public static final Item HERBAL_MEDICINE = ItemsRegistry.registerMedicine("herbal_medicine", 10, 5, true);

    public static void registerAll(RegistryEvent.Register<Item> e) {
        IForgeRegistry r = e.getRegistry();
        for (Pair<String, Item> item : MODITEMS) {
            r.register(((Item)item.getRight()).setRegistryName(new ResourceLocation("betternether", (String)item.getLeft())));
        }
    }

    public static Item registerItem(String name, Item item) {
        MODITEMS.add((Pair<String, Item>)Pair.of((Object)name, (Object)item));
        if (item instanceof BlockItem) {
            MOD_BLOCKS.add(item);
        } else {
            MOD_ITEMS.add(item);
        }
        if (!(item instanceof BlockItem)) {
            ITEMS.add(name);
        }
        return item;
    }

    public static Item registerFood(String name, int hunger, float saturationMultiplier) {
        return ItemsRegistry.registerItem(name, new Item(ItemsRegistry.defaultSettings().func_221540_a(new Food.Builder().func_221456_a(hunger).func_221454_a(saturationMultiplier).func_221453_d())));
    }

    public static Item registerMedicine(String name, int ticks, int power, boolean bowl) {
        if (bowl) {
            Item item = new Item(ItemsRegistry.defaultSettings().func_221540_a(new Food.Builder().effect(() -> new EffectInstance(Effects.field_76428_l, ticks, power), 1.0f).func_221453_d())){

                public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity user) {
                    PlayerEntity player;
                    if (stack.func_190916_E() == 1) {
                        super.func_77654_b(stack, world, user);
                        return new ItemStack((IItemProvider)STALAGNATE_BOWL, stack.func_190916_E());
                    }
                    if (user instanceof PlayerEntity && !(player = (PlayerEntity)user).func_184812_l_()) {
                        player.func_191521_c(new ItemStack((IItemProvider)STALAGNATE_BOWL));
                    }
                    return super.func_77654_b(stack, world, user);
                }
            };
            return ItemsRegistry.registerItem(name, item);
        }
        return ItemsRegistry.registerItem(name, new Item(ItemsRegistry.defaultSettings().func_221540_a(new Food.Builder().effect(() -> new EffectInstance(Effects.field_76428_l, ticks, power), 1.0f).func_221453_d())));
    }

    public static Item.Properties defaultSettings() {
        return new Item.Properties().func_200916_a(CreativeTab.BN_TAB);
    }

    private static Item makeEgg(String name, EntityType<?> type, int background, int dots) {
        if (Configs.MOBS.getBoolean("mobs", name, true)) {
            SpawnEggItem item = new SpawnEggItem(type, background, dots, ItemsRegistry.defaultSettings());
            DefaultDispenseItemBehavior behavior = new DefaultDispenseItemBehavior(){

                public ItemStack dispenseSilently(IBlockSource pointer, ItemStack stack) {
                    Direction direction = (Direction)pointer.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                    EntityType entityType = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                    entityType.func_220331_a(pointer.func_197524_h(), stack, (PlayerEntity)null, pointer.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                    stack.func_190918_g(1);
                    return stack;
                }
            };
            DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)behavior);
            return item;
        }
        return Items.field_190931_a;
    }

    private static int color(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static List<String> getPossibleItems() {
        return ITEMS;
    }
}

