/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.registry;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import someoneelse.betternetherreforged.biomes.CrimsonGlowingWoods;
import someoneelse.betternetherreforged.biomes.CrimsonPinewood;
import someoneelse.betternetherreforged.biomes.FloodedDeltas;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.biomes.NetherBiomeWrapper;
import someoneelse.betternetherreforged.biomes.NetherBoneReef;
import someoneelse.betternetherreforged.biomes.NetherGrasslands;
import someoneelse.betternetherreforged.biomes.NetherGravelDesert;
import someoneelse.betternetherreforged.biomes.NetherJungle;
import someoneelse.betternetherreforged.biomes.NetherMagmaLand;
import someoneelse.betternetherreforged.biomes.NetherMushroomForest;
import someoneelse.betternetherreforged.biomes.NetherMushroomForestEdge;
import someoneelse.betternetherreforged.biomes.NetherPoorGrasslands;
import someoneelse.betternetherreforged.biomes.NetherSoulPlain;
import someoneelse.betternetherreforged.biomes.NetherSulfuricBoneReef;
import someoneelse.betternetherreforged.biomes.NetherSwampland;
import someoneelse.betternetherreforged.biomes.NetherSwamplandTerraces;
import someoneelse.betternetherreforged.biomes.NetherWartForest;
import someoneelse.betternetherreforged.biomes.NetherWartForestEdge;
import someoneelse.betternetherreforged.biomes.OldFungiwoods;
import someoneelse.betternetherreforged.biomes.OldSwampland;
import someoneelse.betternetherreforged.biomes.OldWarpedWoods;
import someoneelse.betternetherreforged.biomes.UpsideDownForest;
import someoneelse.betternetherreforged.config.Config;
import someoneelse.betternetherreforged.config.Configs;

public class NetherBiomesRegistry {
    public static IForgeRegistry<NetherBiome> REGISTRY;
    public static final ArrayList<NetherBiome> ALL_BIOMES;
    public static final Map<Biome, NetherBiome> MUTABLE;
    private static final ArrayList<NetherBiome> GENERATOR;
    public static final NetherBiome BIOME_EMPTY_NETHER;
    public static final NetherBiome BIOME_CRIMSON_FOREST;
    public static final NetherBiome BIOME_WARPED_FOREST;
    public static final NetherBiome BIOME_BASALT_DELTAS;
    public static final NetherBiome BIOME_GRAVEL_DESERT;
    public static final NetherBiome BIOME_NETHER_JUNGLE;
    public static final NetherBiome BIOME_WART_FOREST;
    public static final NetherBiome BIOME_GRASSLANDS;
    public static final NetherBiome BIOME_MUSHROOM_FOREST;
    public static final NetherBiome BIOME_MUSHROOM_FOREST_EDGE;
    public static final NetherBiome BIOME_WART_FOREST_EDGE;
    public static final NetherBiome BIOME_BONE_REEF;
    public static final NetherBiome BIOME_SULFURIC_BONE_REEF;
    public static final NetherBiome BIOME_POOR_GRASSLANDS;
    public static final NetherBiome NETHER_SWAMPLAND;
    public static final NetherBiome NETHER_SWAMPLAND_TERRACES;
    public static final NetherBiome MAGMA_LAND;
    public static final NetherBiome SOUL_PLAIN;
    public static final NetherBiome CRIMSON_GLOWING_WOODS;
    public static final NetherBiome OLD_WARPED_WOODS;
    public static final NetherBiome CRIMSON_PINEWOOD;
    public static final NetherBiome OLD_FUNGIWOODS;
    public static final NetherBiome FLOODED_DELTAS;
    public static final NetherBiome UPSIDE_DOWN_FOREST;
    public static final NetherBiome OLD_SWAMPLAND;
    private static int maxDefChance;
    private static int maxChance;

    public static void init() {
        ForgeRegistries.BIOMES.forEach(biome -> {
            if (biome.func_201856_r() == Biome.Category.NETHER) {
                ResourceLocation id = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome);
                Configs.GENERATOR.getFloat("biomes." + id.func_110624_b() + ".main", id.func_110623_a() + "_chance", 1.0f);
            }
        });
        NetherBiomesRegistry.registerNetherBiome(BIOME_GRAVEL_DESERT);
        NetherBiomesRegistry.registerNetherBiome(BIOME_NETHER_JUNGLE);
        NetherBiomesRegistry.registerNetherBiome(BIOME_EMPTY_NETHER);
        NetherBiomesRegistry.registerNetherBiome(BIOME_CRIMSON_FOREST);
        NetherBiomesRegistry.registerNetherBiome(BIOME_WARPED_FOREST);
        NetherBiomesRegistry.registerNetherBiome(BIOME_BASALT_DELTAS);
        NetherBiomesRegistry.registerNetherBiome(BIOME_WART_FOREST);
        NetherBiomesRegistry.registerNetherBiome(BIOME_GRASSLANDS);
        NetherBiomesRegistry.registerNetherBiome(BIOME_MUSHROOM_FOREST);
        NetherBiomesRegistry.registerEdgeBiome(BIOME_MUSHROOM_FOREST_EDGE, BIOME_MUSHROOM_FOREST, 2);
        NetherBiomesRegistry.registerEdgeBiome(BIOME_WART_FOREST_EDGE, BIOME_WART_FOREST, 2);
        NetherBiomesRegistry.registerNetherBiome(BIOME_BONE_REEF);
        NetherBiomesRegistry.registerSubBiome(BIOME_SULFURIC_BONE_REEF, BIOME_BONE_REEF, 0.3f);
        NetherBiomesRegistry.registerSubBiome(BIOME_POOR_GRASSLANDS, BIOME_GRASSLANDS, 0.3f);
        NetherBiomesRegistry.registerNetherBiome(NETHER_SWAMPLAND);
        NetherBiomesRegistry.registerSubBiome(NETHER_SWAMPLAND_TERRACES, NETHER_SWAMPLAND, 1.0f);
        NetherBiomesRegistry.registerNetherBiome(MAGMA_LAND);
        NetherBiomesRegistry.registerSubBiome(SOUL_PLAIN, BIOME_WART_FOREST, 1.0f);
        NetherBiomesRegistry.registerSubBiome(CRIMSON_GLOWING_WOODS, BIOME_CRIMSON_FOREST, 0.3f);
        NetherBiomesRegistry.registerSubBiome(OLD_WARPED_WOODS, BIOME_WARPED_FOREST, 1.0f);
        NetherBiomesRegistry.registerSubBiome(CRIMSON_PINEWOOD, BIOME_CRIMSON_FOREST, 0.3f);
        NetherBiomesRegistry.registerSubBiome(OLD_FUNGIWOODS, BIOME_MUSHROOM_FOREST, 0.3f);
        NetherBiomesRegistry.registerSubBiome(FLOODED_DELTAS, BIOME_BASALT_DELTAS, 1.0f);
        NetherBiomesRegistry.registerNetherBiome(UPSIDE_DOWN_FOREST);
        NetherBiomesRegistry.registerSubBiome(OLD_SWAMPLAND, NETHER_SWAMPLAND, 1.0f);
    }

    public static void registerNetherBiomes(RegistryEvent.Register<NetherBiome> e) {
        IForgeRegistry r = e.getRegistry();
        for (NetherBiome nb : ALL_BIOMES) {
            if (nb.getRegistryName() == null) {
                nb.setRegistryName(nb.getID());
            }
            r.register((IForgeRegistryEntry)nb);
        }
    }

    public static void registerBiomes(RegistryEvent.Register<Biome> e) {
        IForgeRegistry r = e.getRegistry();
        for (NetherBiome nb : ALL_BIOMES) {
            if (ForgeRegistries.BIOMES.containsKey(nb.getID())) continue;
            nb.getBiome().setRegistryName(nb.getID());
            r.register((IForgeRegistryEntry)nb.getBiome());
        }
    }

    public static void createRegistry(RegistryEvent.NewRegistry e) {
        RegistryBuilder r = new RegistryBuilder();
        r.setName(new ResourceLocation("betternether", "nether_biomes"));
        r.setType(NetherBiome.class);
        REGISTRY = r.create();
    }

    public static void mapBiomes(Registry<Biome> biomeRegistry) {
        GENERATOR.clear();
        GENERATOR.addAll(REGISTRY.getValues());
        MUTABLE.clear();
        for (NetherBiome netherBiome : NetherBiomesRegistry.getAllBiomes()) {
            Biome biome = (Biome)biomeRegistry.func_82594_a(netherBiome.getID());
            netherBiome.setActualBiome(biome);
            MUTABLE.put(biome, netherBiome);
        }
        if (maxDefChance == 0) {
            maxDefChance = maxChance;
        }
        maxChance = maxDefChance;
        for (Biome biome : biomeRegistry) {
            if (biome.func_201856_r() != Biome.Category.NETHER || MUTABLE.containsKey(biome)) continue;
            ResourceLocation id = biomeRegistry.func_177774_c((Object)biome);
            NetherBiomeWrapper netherBiome = new NetherBiomeWrapper(biomeRegistry.func_177774_c((Object)biome), biome);
            netherBiome.setActualBiome(biome);
            MUTABLE.put(biome, netherBiome);
            float chance = Configs.GENERATOR.getFloat("biomes." + id.func_110624_b() + ".main", id.func_110623_a() + "_chance", 1.0f);
            if (!(chance > 0.0f)) continue;
            maxChance = (int)((float)maxChance + chance);
            netherBiome.setGenChance(maxChance);
            String path = "generator.biome." + netherBiome.getID().func_110624_b() + "." + netherBiome.getID().func_110623_a();
            netherBiome.setPlantDensity(Configs.BIOMES.getFloat(path, "plants_and_structures_density", 1.0f));
            netherBiome.build();
            GENERATOR.add(netherBiome);
        }
        Config.save();
    }

    private static void register(NetherBiome biome) {
        if (ForgeRegistries.BIOMES.getKeys().contains(biome.getID())) {
            biome.getBiome().setRegistryName(biome.getID());
            ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome.getBiome());
        }
    }

    public static void registerNetherBiome(NetherBiome biome) {
        float chance = Configs.GENERATOR.getFloat("biomes." + biome.getID().func_110624_b() + ".main", biome.getID().func_110623_a() + "_chance", 1.0f);
        if (chance > 0.0f) {
            maxChance = (int)((float)maxChance + chance);
            String path = "generator.biome." + biome.getID().func_110624_b() + "." + biome.getID().func_110623_a();
            biome.setPlantDensity(Configs.BIOMES.getFloat(path, "plants_and_structures_density", 1.0f));
            biome.setGenChance(maxChance);
            biome.build();
            biome.setRegistryName(biome.getID());
            ALL_BIOMES.add(biome);
        }
    }

    public static void registerEdgeBiome(NetherBiome biome, NetherBiome mainBiome, int size) {
        String regName = biome.getRawBiomeRegistryName();
        float sizeConf = Configs.GENERATOR.getFloat("biomes.betternether.edge", regName + "_size", size);
        if (sizeConf > 0.0f) {
            String path = "generator.biome." + biome.getID().func_110624_b() + "." + biome.getID().func_110623_a();
            biome.setPlantDensity(Configs.BIOMES.getFloat(path, "plants_and_structures_density", 1.0f));
            mainBiome.setEdge(biome);
            mainBiome.setEdgeSize(sizeConf);
            biome.build();
            ALL_BIOMES.add(biome);
        }
    }

    public static void registerSubBiome(NetherBiome biome, NetherBiome mainBiome, float chance) {
        String regName = biome.getRawBiomeRegistryName();
        chance = Configs.GENERATOR.getFloat("biomes.betternether.variation", regName + "_chance", chance);
        if (chance > 0.0f) {
            String path = "generator.biome." + biome.getID().func_110624_b() + "." + biome.getID().func_110623_a();
            biome.setPlantDensity(Configs.BIOMES.getFloat(path, "plants_and_structures_density", 1.0f));
            mainBiome.addSubBiome(biome, chance);
            biome.build();
            ALL_BIOMES.add(biome);
        }
    }

    public static NetherBiome getBiome(Random random) {
        float chance = random.nextFloat() * (float)maxChance;
        for (NetherBiome biome : GENERATOR) {
            if (!biome.canGenerate(chance)) continue;
            return biome;
        }
        return BIOME_EMPTY_NETHER;
    }

    public static NetherBiome getFromBiome(Biome biome) {
        return MUTABLE.getOrDefault(biome, BIOME_EMPTY_NETHER);
    }

    public static ArrayList<NetherBiome> getRegisteredBiomes() {
        return new ArrayList<NetherBiome>(REGISTRY.getValues());
    }

    public static ArrayList<NetherBiome> getAllBiomes() {
        return ALL_BIOMES;
    }

    static {
        ALL_BIOMES = new ArrayList();
        MUTABLE = Maps.newHashMap();
        GENERATOR = new ArrayList();
        BIOME_EMPTY_NETHER = new NetherBiomeWrapper(new ResourceLocation("nether_wastes"));
        BIOME_CRIMSON_FOREST = new NetherBiomeWrapper(new ResourceLocation("crimson_forest"));
        BIOME_WARPED_FOREST = new NetherBiomeWrapper(new ResourceLocation("warped_forest"));
        BIOME_BASALT_DELTAS = new NetherBiomeWrapper(new ResourceLocation("basalt_deltas"));
        BIOME_GRAVEL_DESERT = new NetherGravelDesert("Gravel Desert");
        BIOME_NETHER_JUNGLE = new NetherJungle("Nether Jungle");
        BIOME_WART_FOREST = new NetherWartForest("Wart Forest");
        BIOME_GRASSLANDS = new NetherGrasslands("Nether Grasslands");
        BIOME_MUSHROOM_FOREST = new NetherMushroomForest("Nether Mushroom Forest");
        BIOME_MUSHROOM_FOREST_EDGE = new NetherMushroomForestEdge("Nether Mushroom Forest Edge");
        BIOME_WART_FOREST_EDGE = new NetherWartForestEdge("Wart Forest Edge");
        BIOME_BONE_REEF = new NetherBoneReef("Bone Reef");
        BIOME_SULFURIC_BONE_REEF = new NetherSulfuricBoneReef("Sulfuric Bone Reef");
        BIOME_POOR_GRASSLANDS = new NetherPoorGrasslands("Poor Nether Grasslands");
        NETHER_SWAMPLAND = new NetherSwampland("Nether Swampland");
        NETHER_SWAMPLAND_TERRACES = new NetherSwamplandTerraces("Nether Swampland Terraces");
        MAGMA_LAND = new NetherMagmaLand("Magma Land");
        SOUL_PLAIN = new NetherSoulPlain("Soul Plain");
        CRIMSON_GLOWING_WOODS = new CrimsonGlowingWoods("Crimson Glowing Woods");
        OLD_WARPED_WOODS = new OldWarpedWoods("Old Warped Woods");
        CRIMSON_PINEWOOD = new CrimsonPinewood("Crimson Pinewood");
        OLD_FUNGIWOODS = new OldFungiwoods("Old Fungiwoods");
        FLOODED_DELTAS = new FloodedDeltas("Flooded Deltas");
        UPSIDE_DOWN_FOREST = new UpsideDownForest("Upside Down Forest");
        OLD_SWAMPLAND = new OldSwampland("Old Swampland");
        maxDefChance = 0;
        maxChance = 0;
    }
}

