/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.registry;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import someoneelse.betternetherreforged.structures.IStructure;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.decorations.StructureCrystal;
import someoneelse.betternetherreforged.structures.decorations.StructureGeyser;
import someoneelse.betternetherreforged.structures.plants.StructureAgave;
import someoneelse.betternetherreforged.structures.plants.StructureBarrelCactus;
import someoneelse.betternetherreforged.structures.plants.StructureBigWarpedTree;
import someoneelse.betternetherreforged.structures.plants.StructureBlackApple;
import someoneelse.betternetherreforged.structures.plants.StructureBlackBush;
import someoneelse.betternetherreforged.structures.plants.StructureBlackVine;
import someoneelse.betternetherreforged.structures.plants.StructureBloomingVine;
import someoneelse.betternetherreforged.structures.plants.StructureBoneReef;
import someoneelse.betternetherreforged.structures.plants.StructureCrimsonFungus;
import someoneelse.betternetherreforged.structures.plants.StructureCrimsonGlowingTree;
import someoneelse.betternetherreforged.structures.plants.StructureCrimsonPinewood;
import someoneelse.betternetherreforged.structures.plants.StructureCrimsonRoots;
import someoneelse.betternetherreforged.structures.plants.StructureEggPlant;
import someoneelse.betternetherreforged.structures.plants.StructureEye;
import someoneelse.betternetherreforged.structures.plants.StructureGiantMold;
import someoneelse.betternetherreforged.structures.plants.StructureGoldenVine;
import someoneelse.betternetherreforged.structures.plants.StructureGrayMold;
import someoneelse.betternetherreforged.structures.plants.StructureInkBush;
import someoneelse.betternetherreforged.structures.plants.StructureJunglePlant;
import someoneelse.betternetherreforged.structures.plants.StructureLucis;
import someoneelse.betternetherreforged.structures.plants.StructureMagmaFlower;
import someoneelse.betternetherreforged.structures.plants.StructureMedBrownMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureMedRedMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureMushroomFir;
import someoneelse.betternetherreforged.structures.plants.StructureNetherCactus;
import someoneelse.betternetherreforged.structures.plants.StructureNetherGrass;
import someoneelse.betternetherreforged.structures.plants.StructureNetherWart;
import someoneelse.betternetherreforged.structures.plants.StructureOldBrownMushrooms;
import someoneelse.betternetherreforged.structures.plants.StructureOldRedMushrooms;
import someoneelse.betternetherreforged.structures.plants.StructureOrangeMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureRedMold;
import someoneelse.betternetherreforged.structures.plants.StructureReeds;
import someoneelse.betternetherreforged.structures.plants.StructureRubeus;
import someoneelse.betternetherreforged.structures.plants.StructureRubeusBush;
import someoneelse.betternetherreforged.structures.plants.StructureSmoker;
import someoneelse.betternetherreforged.structures.plants.StructureSoulGrass;
import someoneelse.betternetherreforged.structures.plants.StructureSoulLily;
import someoneelse.betternetherreforged.structures.plants.StructureSoulVein;
import someoneelse.betternetherreforged.structures.plants.StructureStalagnate;
import someoneelse.betternetherreforged.structures.plants.StructureSwampGrass;
import someoneelse.betternetherreforged.structures.plants.StructureTwistedVines;
import someoneelse.betternetherreforged.structures.plants.StructureVanillaMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWallBrownMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWallMoss;
import someoneelse.betternetherreforged.structures.plants.StructureWallRedMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWarpedFungus;
import someoneelse.betternetherreforged.structures.plants.StructureWarpedRoots;
import someoneelse.betternetherreforged.structures.plants.StructureWartBush;
import someoneelse.betternetherreforged.structures.plants.StructureWartDeadwood;
import someoneelse.betternetherreforged.structures.plants.StructureWartSeed;
import someoneelse.betternetherreforged.structures.plants.StructureWartTree;
import someoneelse.betternetherreforged.structures.plants.StructureWillow;

@Mod.EventBusSubscriber(modid="betternether", bus=Mod.EventBusSubscriber.Bus.MOD)
public class StructureRegistry {
    private static final Map<StructureType, Map<String, IStructure>> REGISTRY;
    public static final DeferredRegister<Feature<?>> FEATURES;
    public static final DeferredRegister<Structure<?>> STRUCTURES;

    public static void registerFeature(String name, IStructure structure, StructureType type) {
        REGISTRY.get((Object)type).put(name, structure);
    }

    static {
        FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"betternether");
        STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"betternether");
        REGISTRY = Maps.newHashMap();
        for (StructureType type : StructureType.values()) {
            HashMap list = Maps.newHashMap();
            REGISTRY.put(type, list);
        }
        StructureRegistry.registerFeature("agave", new StructureAgave(), StructureType.FLOOR);
        StructureRegistry.registerFeature("barrel_cactus", new StructureBarrelCactus(), StructureType.FLOOR);
        StructureRegistry.registerFeature("big_warped_tree", new StructureBigWarpedTree(), StructureType.FLOOR);
        StructureRegistry.registerFeature("black_apple", new StructureBlackApple(), StructureType.FLOOR);
        StructureRegistry.registerFeature("black_bush", new StructureBlackBush(), StructureType.FLOOR);
        StructureRegistry.registerFeature("bone_reef", new StructureBoneReef(), StructureType.FLOOR);
        StructureRegistry.registerFeature("bush_rubeus", new StructureRubeusBush(), StructureType.FLOOR);
        StructureRegistry.registerFeature("crimson_fungus", new StructureCrimsonFungus(), StructureType.FLOOR);
        StructureRegistry.registerFeature("crimson_glowing_tree", new StructureCrimsonGlowingTree(), StructureType.FLOOR);
        StructureRegistry.registerFeature("crimson_pinewood", new StructureCrimsonPinewood(), StructureType.FLOOR);
        StructureRegistry.registerFeature("crimson_roots", new StructureCrimsonRoots(), StructureType.FLOOR);
        StructureRegistry.registerFeature("egg_plant", new StructureEggPlant(), StructureType.FLOOR);
        StructureRegistry.registerFeature("geyser", new StructureGeyser(), StructureType.FLOOR);
        StructureRegistry.registerFeature("giant_mold", new StructureGiantMold(), StructureType.FLOOR);
        StructureRegistry.registerFeature("gray_mold", new StructureGrayMold(), StructureType.FLOOR);
        StructureRegistry.registerFeature("ink_bush", new StructureInkBush(), StructureType.FLOOR);
        StructureRegistry.registerFeature("jungle_plant", new StructureJunglePlant(), StructureType.FLOOR);
        StructureRegistry.registerFeature("large_brown_mushroom", new StructureMedBrownMushroom(), StructureType.FLOOR);
        StructureRegistry.registerFeature("large_red_mushroom", new StructureMedRedMushroom(), StructureType.FLOOR);
        StructureRegistry.registerFeature("magma_flower", new StructureMagmaFlower(), StructureType.FLOOR);
        StructureRegistry.registerFeature("mushroom_fir", new StructureMushroomFir(), StructureType.FLOOR);
        StructureRegistry.registerFeature("nether_cactus", new StructureNetherCactus(), StructureType.FLOOR);
        StructureRegistry.registerFeature("nether_grass", new StructureNetherGrass(), StructureType.FLOOR);
        StructureRegistry.registerFeature("swamp_grass", new StructureSwampGrass(), StructureType.FLOOR);
        StructureRegistry.registerFeature("nether_reed", new StructureReeds(), StructureType.FLOOR);
        StructureRegistry.registerFeature("nether_wart", new StructureNetherWart(), StructureType.FLOOR);
        StructureRegistry.registerFeature("obsidian_crystals", new StructureCrystal(), StructureType.FLOOR);
        StructureRegistry.registerFeature("old_brown_mushrooms", new StructureOldBrownMushrooms(), StructureType.FLOOR);
        StructureRegistry.registerFeature("old_red_mushrooms", new StructureOldRedMushrooms(), StructureType.FLOOR);
        StructureRegistry.registerFeature("orange_mushroom", new StructureOrangeMushroom(), StructureType.FLOOR);
        StructureRegistry.registerFeature("red_mold", new StructureRedMold(), StructureType.FLOOR);
        StructureRegistry.registerFeature("rubeus_tree", new StructureRubeus(), StructureType.FLOOR);
        StructureRegistry.registerFeature("smoker", new StructureSmoker(), StructureType.FLOOR);
        StructureRegistry.registerFeature("soul_grass", new StructureSoulGrass(), StructureType.FLOOR);
        StructureRegistry.registerFeature("soul_lily", new StructureSoulLily(), StructureType.FLOOR);
        StructureRegistry.registerFeature("soul_vein", new StructureSoulVein(), StructureType.FLOOR);
        StructureRegistry.registerFeature("stalagnate", new StructureStalagnate(), StructureType.FLOOR);
        StructureRegistry.registerFeature("twisted_vine", new StructureTwistedVines(), StructureType.FLOOR);
        StructureRegistry.registerFeature("vanilla_mushrooms", new StructureVanillaMushroom(), StructureType.FLOOR);
        StructureRegistry.registerFeature("warped_fungus", new StructureWarpedFungus(), StructureType.FLOOR);
        StructureRegistry.registerFeature("warped_roots", new StructureWarpedRoots(), StructureType.FLOOR);
        StructureRegistry.registerFeature("wart_bush", new StructureWartBush(), StructureType.FLOOR);
        StructureRegistry.registerFeature("wart_deadwood", new StructureWartDeadwood(), StructureType.FLOOR);
        StructureRegistry.registerFeature("wart_seed", new StructureWartSeed(), StructureType.FLOOR);
        StructureRegistry.registerFeature("wart_tree", new StructureWartTree(), StructureType.FLOOR);
        StructureRegistry.registerFeature("willow", new StructureWillow(), StructureType.FLOOR);
        StructureRegistry.registerFeature("black_vine", new StructureBlackVine(), StructureType.CEIL);
        StructureRegistry.registerFeature("eye", new StructureEye(), StructureType.CEIL);
        StructureRegistry.registerFeature("flowered_vine", new StructureBloomingVine(), StructureType.CEIL);
        StructureRegistry.registerFeature("golden_vine", new StructureGoldenVine(), StructureType.CEIL);
        StructureRegistry.registerFeature("lucis", new StructureLucis(), StructureType.WALL);
        StructureRegistry.registerFeature("wall_brown_mushroom", new StructureWallBrownMushroom(), StructureType.WALL);
        StructureRegistry.registerFeature("wall_moss", new StructureWallMoss(), StructureType.WALL);
        StructureRegistry.registerFeature("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL);
    }
}

