/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.structures.IStructure;
import someoneelse.betternetherreforged.structures.StructureWorld;

public abstract class StructureObjScatter
implements IStructure {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    final StructureWorld[] structures;
    final int distance;
    final int manDist;

    public StructureObjScatter(int distance, StructureWorld[] structures) {
        this.distance = distance;
        this.manDist = (int)Math.ceil((double)distance * 1.5);
        this.structures = structures;
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (this.isGround(world.func_180495_p(pos.func_177977_b())) && this.isGround(world.func_180495_p(pos.func_177979_c(2))) && this.noObjNear((IWorld)world, pos)) {
            StructureWorld tree = this.structures[random.nextInt(this.structures.length)];
            tree.generate(world, pos, random);
        }
    }

    protected abstract boolean isStructure(BlockState var1);

    protected abstract boolean isGround(BlockState var1);

    private boolean noObjNear(IWorld world, BlockPos pos) {
        int x1 = pos.func_177958_n() - this.distance;
        int z1 = pos.func_177952_p() - this.distance;
        int x2 = pos.func_177958_n() + this.distance;
        int z2 = pos.func_177952_p() + this.distance;
        POS.func_185336_p(pos.func_177956_o());
        for (int x = x1; x <= x2; ++x) {
            POS.func_223471_o(x);
            for (int z = z1; z <= z2; ++z) {
                POS.func_223472_q(z);
                if (!this.isInside(x - pos.func_177958_n(), z - pos.func_177952_p()) || !this.isStructure(world.func_180495_p((BlockPos)POS))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isInside(int x, int z) {
        return Math.abs(x) + Math.abs(z) <= this.manDist;
    }
}

