/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BlockAnchorTreeVine;
import someoneelse.betternetherreforged.blocks.BlockPlantWall;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;
import someoneelse.betternetherreforged.structures.plants.StructureAnchorTree;
import someoneelse.betternetherreforged.structures.plants.StructureLucis;

public class StructureAnchorTreeRoot
implements IStructure {
    private static final Set<BlockPos> BLOCKS = new HashSet<BlockPos>(2048);
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private Block[] wallPlants;
    private static final StructureLucis LUCIS = new StructureLucis();

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (pos.func_177956_o() < 96) {
            return;
        }
        double angle = random.nextDouble() * Math.PI * 2.0;
        double dx = Math.sin(angle);
        double dz = Math.cos(angle);
        double size = (double)MHelper.randRange(10, 25, random) * 0.5;
        int count = MHelper.floor(size * 2.0);
        if (count < 3) {
            count = 3;
        }
        if ((count & 1) == 0) {
            ++count;
        }
        POS.func_189532_c((double)pos.func_177958_n() - dx * size, (double)(pos.func_177956_o() + 10), (double)pos.func_177952_p() - dz * size);
        BlockPos start = POS.func_177981_b(BlocksHelper.upRay((IWorld)world, (BlockPos)POS, 64));
        if (start.func_177956_o() < pos.func_177956_o()) {
            start = POS.func_189533_g((Vector3i)start).func_177982_a(0, 10, 0).func_185334_h();
        }
        POS.func_189532_c((double)pos.func_177958_n() + dx * size, (double)(pos.func_177956_o() + 10), (double)pos.func_177952_p() + dz * size);
        BlockPos end = POS.func_177981_b(BlocksHelper.upRay((IWorld)world, (BlockPos)POS, 64));
        if (end.func_177956_o() < pos.func_177956_o()) {
            end = POS.func_189533_g((Vector3i)end).func_177982_a(0, 10, 0).func_185334_h();
        }
        List<BlockPos> blocks = this.lineParable(start, end, count, random, 0.2);
        BLOCKS.clear();
        this.buildLine(blocks, 1.3 + random.nextDouble());
        if (this.wallPlants == null) {
            this.wallPlants = new Block[]{BlocksRegistry.JUNGLE_MOSS, BlocksRegistry.JUNGLE_MOSS, BlocksRegistry.WALL_MUSHROOM_BROWN, BlocksRegistry.WALL_MUSHROOM_RED};
        }
        BlockState vine = BlocksRegistry.ANCHOR_TREE_VINE.func_176223_P();
        for (BlockPos bpos : BLOCKS) {
            int length;
            BlockState state;
            if (bpos.func_177956_o() < 1 || bpos.func_177956_o() > 126 || !BlocksHelper.isNetherGround(state = world.func_180495_p(bpos)) && !this.canReplace(state)) continue;
            boolean blockUp = true;
            boolean blockDown = true;
            blockUp = BLOCKS.contains(bpos.func_177984_a());
            if (blockUp && (blockDown = BLOCKS.contains(bpos.func_177977_b()))) {
                BlocksHelper.setWithoutUpdate((IWorld)world, bpos, BlocksRegistry.ANCHOR_TREE.log.func_176223_P());
            } else {
                BlocksHelper.setWithoutUpdate((IWorld)world, bpos, BlocksRegistry.ANCHOR_TREE.bark.func_176223_P());
            }
            if (!blockUp && world.func_180495_p(bpos.func_177984_a()).func_185904_a().func_76222_j()) {
                BlocksHelper.setWithoutUpdate((IWorld)world, bpos.func_177984_a(), BlocksRegistry.MOSS_COVER.func_176223_P());
            }
            if ((bpos.func_177956_o() & 3) == 0 && StructureAnchorTree.NOISE.eval((double)bpos.func_177958_n() * 0.1, (double)bpos.func_177956_o() * 0.1, (double)bpos.func_177952_p() * 0.1) > 0.0) {
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.func_177978_c())) {
                    if (random.nextBoolean()) {
                        StructureAnchorTree.makeMushroom(world, bpos.func_177978_c(), random.nextDouble() + 1.5);
                    } else {
                        LUCIS.generate(world, bpos, random);
                    }
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.func_177968_d())) {
                    if (random.nextBoolean()) {
                        StructureAnchorTree.makeMushroom(world, bpos.func_177968_d(), random.nextDouble() + 1.5);
                    } else {
                        LUCIS.generate(world, bpos, random);
                    }
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.func_177974_f())) {
                    if (random.nextBoolean()) {
                        StructureAnchorTree.makeMushroom(world, bpos.func_177974_f(), random.nextDouble() + 1.5);
                    } else {
                        LUCIS.generate(world, bpos, random);
                    }
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.func_177976_e())) {
                    if (random.nextBoolean()) {
                        StructureAnchorTree.makeMushroom(world, bpos.func_177976_e(), random.nextDouble() + 1.5);
                    } else {
                        LUCIS.generate(world, bpos, random);
                    }
                }
            }
            state = this.wallPlants[random.nextInt(this.wallPlants.length)].func_176223_P();
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177978_c()) && world.func_175623_d(bpos.func_177978_c())) {
                BlocksHelper.setWithoutUpdate((IWorld)world, bpos.func_177978_c(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177968_d()) && world.func_175623_d(bpos.func_177968_d())) {
                BlocksHelper.setWithoutUpdate((IWorld)world, bpos.func_177968_d(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177974_f()) && world.func_175623_d(bpos.func_177974_f())) {
                BlocksHelper.setWithoutUpdate((IWorld)world, bpos.func_177974_f(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177976_e()) && world.func_175623_d(bpos.func_177976_e())) {
                BlocksHelper.setWithoutUpdate((IWorld)world, bpos.func_177976_e(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
            }
            if (!blockUp || blockDown || random.nextInt(16) != 0 || (length = BlocksHelper.downRay((IWorld)world, bpos = bpos.func_177977_b(), 17)) <= 4) continue;
            length = MHelper.randRange(3, length, random);
            for (int i = 0; i < length - 2; ++i) {
                BlocksHelper.setWithoutUpdate((IWorld)world, bpos.func_177979_c(i), vine);
            }
            BlocksHelper.setWithoutUpdate((IWorld)world, bpos.func_177979_c(length - 2), (BlockState)vine.func_206870_a(BlockAnchorTreeVine.SHAPE, (Comparable)((Object)TripleShape.MIDDLE)));
            BlocksHelper.setWithoutUpdate((IWorld)world, bpos.func_177979_c(length - 1), (BlockState)vine.func_206870_a(BlockAnchorTreeVine.SHAPE, (Comparable)((Object)TripleShape.BOTTOM)));
        }
    }

    private boolean canReplace(BlockState state) {
        return state.func_185904_a().func_76222_j() || state.func_177230_c() == BlocksRegistry.GIANT_LUCIS || state.func_177230_c() == BlocksRegistry.LUCIS_MUSHROOM || state.func_177230_c() instanceof BlockPlantWall;
    }

    private void buildLine(List<BlockPos> blocks, double radius) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            BlockPos a = blocks.get(i);
            BlockPos b = blocks.get(i + 1);
            if (b.func_177956_o() < a.func_177956_o()) {
                BlockPos c = b;
                b = a;
                a = c;
            }
            int count = (int)Math.ceil(Math.sqrt(b.func_177951_i((Vector3i)a)));
            for (int j = 0; j < count; ++j) {
                this.sphere(this.lerpCos(a, b, (double)j / (double)count), radius);
            }
        }
    }

    private BlockPos lerpCos(BlockPos start, BlockPos end, double mix) {
        double v = this.lcos(mix);
        double x = MathHelper.func_219803_d((double)v, (double)start.func_177958_n(), (double)end.func_177958_n());
        double y = MathHelper.func_219803_d((double)v, (double)start.func_177956_o(), (double)end.func_177956_o());
        double z = MathHelper.func_219803_d((double)v, (double)start.func_177952_p(), (double)end.func_177952_p());
        return new BlockPos(x, y, z);
    }

    private double lcos(double mix) {
        return MathHelper.func_151237_a((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<BlockPos> lineParable(BlockPos start, BlockPos end, int count, Random random, double range) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(count);
        int max = count - 1;
        int middle = count / 2;
        result.add(start);
        double size = Math.sqrt(start.func_177951_i((Vector3i)end)) * 0.8;
        for (int i = 1; i < max; ++i) {
            double offset = (double)(i - middle) / (double)middle;
            offset = 1.0 - offset * offset;
            double delta = (double)i / (double)max;
            double x = MathHelper.func_219803_d((double)delta, (double)start.func_177958_n(), (double)end.func_177958_n()) + random.nextGaussian() * range;
            double y = MathHelper.func_219803_d((double)delta, (double)start.func_177956_o(), (double)end.func_177956_o()) - offset * size;
            double z = MathHelper.func_219803_d((double)delta, (double)start.func_177952_p(), (double)end.func_177952_p()) + random.nextGaussian() * range;
            result.add(new BlockPos(x, y, z));
        }
        result.add(end);
        return result;
    }

    private void sphere(BlockPos pos, double radius) {
        int x1 = MHelper.floor((double)pos.func_177958_n() - radius);
        int y1 = MHelper.floor((double)pos.func_177956_o() - radius);
        int z1 = MHelper.floor((double)pos.func_177952_p() - radius);
        int x2 = MHelper.floor((double)pos.func_177958_n() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.func_177956_o() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.func_177952_p() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.func_177958_n();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.func_177952_p();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.func_177956_o();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    BLOCKS.add(new BlockPos(x, y, z));
                }
            }
        }
    }
}

