/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockRedLargeMushroom;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureGiantMold
implements IStructure {
    BlockPos.Mutable npos = new BlockPos.Mutable();

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == BlocksRegistry.NETHER_MYCELIUM) {
            for (int i = 0; i < 10; ++i) {
                int x = pos.func_177958_n() + (int)(random.nextGaussian() * 2.0);
                int z = pos.func_177952_p() + (int)(random.nextGaussian() * 2.0);
                int y = pos.func_177956_o() + random.nextInt(6);
                for (int j = 0; j < 16; ++j) {
                    this.npos.func_181079_c(x, y - j, z);
                    Block under = world.func_180495_p(this.npos.func_177977_b()).func_177230_c();
                    if (under != BlocksRegistry.NETHER_MYCELIUM) continue;
                    this.grow(world, (BlockPos)this.npos, random);
                }
            }
        }
    }

    public void grow(IServerWorld world, BlockPos pos, Random random) {
        int size = 2 + random.nextInt(6);
        for (int y = 1; y <= size; ++y) {
            if (world.func_175623_d(pos.func_177981_b(y))) continue;
            if (y == 1) {
                return;
            }
            size = y - 1;
            break;
        }
        BlockState middle = (BlockState)BlocksRegistry.GIANT_MOLD.func_176223_P().func_206870_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)TripleShape.MIDDLE));
        for (int y = 1; y < size; ++y) {
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(y), middle);
        }
        BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(size), (BlockState)BlocksRegistry.GIANT_MOLD.func_176223_P().func_206870_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)TripleShape.TOP)));
        BlocksHelper.setWithUpdate((IWorld)world, pos, (BlockState)BlocksRegistry.GIANT_MOLD.func_176223_P().func_206870_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)TripleShape.BOTTOM)));
    }
}

