/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BlockPlantWall;
import someoneelse.betternetherreforged.blocks.RubeusLog;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.StructureFuncScatter;

public class StructureRubeus
extends StructureFuncScatter {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final int MIDDLE_Y = 10;
    private static final Set<BlockPos> POINTS = new HashSet<BlockPos>();
    private static final Set<BlockPos> MIDDLE = new HashSet<BlockPos>();
    private static final Set<BlockPos> TOP = new HashSet<BlockPos>();

    public StructureRubeus() {
        super(7);
    }

    @Override
    public void grow(IServerWorld world, BlockPos pos, Random random) {
        this.grow(world, pos, random, true);
    }

    public void grow(IServerWorld world, BlockPos pos, Random random, boolean natural) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.func_177958_n() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.func_177956_o() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.func_177952_p() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 5.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((IWorld)world, x1, y1 + 1, z1, crownR, random);
            int middle = Math.round((float)pos.func_177956_o() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.func_177958_n() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.func_177956_o() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.func_177952_p() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.func_180495_p((BlockPos)POS.func_181079_c(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.func_180495_p((BlockPos)POS.func_181079_c(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.func_177958_n();
                        y2 = pos.func_177956_o();
                        generate = false;
                    }
                }
                this.line((IWorld)world, x1, y1, z1, x2, y2, z2, middle);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<BlockPos> iterator = TOP.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos == null || !POINTS.contains(bpos.func_177984_a()) || TOP.contains(bpos.func_177984_a())) continue;
            iterator.remove();
        }
        iterator = MIDDLE.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos != null) {
                BlockPos up = bpos.func_177984_a();
                if (!MIDDLE.contains(up) && (TOP.contains(up) || !POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (BlockPos bpos : POINTS) {
            BlockState state;
            if (POINTS.contains(bpos.func_177984_a()) && POINTS.contains(bpos.func_177977_b())) {
                state = BlocksRegistry.RUBEUS_LOG.func_176223_P();
                if (MIDDLE.contains(bpos)) {
                    this.setCondition((IWorld)world, bpos, pos.func_177956_o(), (BlockState)state.func_206870_a(RubeusLog.SHAPE, (Comparable)((Object)TripleShape.MIDDLE)), false, random);
                    continue;
                }
                if (TOP.contains(bpos)) {
                    this.setCondition((IWorld)world, bpos, pos.func_177956_o(), (BlockState)state.func_206870_a(RubeusLog.SHAPE, (Comparable)((Object)TripleShape.TOP)), false, random);
                    continue;
                }
                this.setCondition((IWorld)world, bpos, pos.func_177956_o(), (BlockState)state.func_206870_a(RubeusLog.SHAPE, (Comparable)((Object)TripleShape.BOTTOM)), natural, random);
                continue;
            }
            state = BlocksRegistry.RUBEUS_BARK.func_176223_P();
            if (MIDDLE.contains(bpos)) {
                this.setCondition((IWorld)world, bpos, pos.func_177956_o(), (BlockState)state.func_206870_a(RubeusLog.SHAPE, (Comparable)((Object)TripleShape.MIDDLE)), false, random);
                continue;
            }
            if (TOP.contains(bpos)) {
                this.setCondition((IWorld)world, bpos, pos.func_177956_o(), (BlockState)state.func_206870_a(RubeusLog.SHAPE, (Comparable)((Object)TripleShape.TOP)), false, random);
                continue;
            }
            this.setCondition((IWorld)world, bpos, pos.func_177956_o(), (BlockState)state.func_206870_a(RubeusLog.SHAPE, (Comparable)((Object)TripleShape.BOTTOM)), natural, random);
        }
        POINTS.clear();
        MIDDLE.clear();
        TOP.clear();
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        int length = BlocksHelper.upRay((IWorld)world, pos, 27);
        if (length >= 25) {
            super.generate(world, pos, random);
        }
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return state.func_177230_c() == BlocksRegistry.RUBEUS_LOG;
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isNetherGround(state);
    }

    private void line(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, int middleY) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = POS.func_181079_c(x1, y1, z1).func_185334_h();
        POINTS.add(pos);
        if (pos.func_177956_o() == middleY) {
            MIDDLE.add(pos);
        } else if (pos.func_177956_o() > middleY) {
            TOP.add(pos);
        }
        pos = POS.func_181079_c(x2, y2, z2).func_185334_h();
        POINTS.add(pos);
        if (pos.func_177956_o() == middleY) {
            MIDDLE.add(pos);
        } else if (pos.func_177956_o() > middleY) {
            TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            POS.func_181079_c(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = POS.func_185334_h();
            POINTS.add(pos);
            if (POS.func_177956_o() == middleY) {
                MIDDLE.add(pos);
                continue;
            }
            if (POS.func_177956_o() <= middleY) continue;
            TOP.add(pos);
        }
    }

    private void crown(IWorld world, int x, int y, int z, float radius, Random random) {
        int start;
        BlockState leaves = BlocksRegistry.RUBEUS_LEAVES.func_176223_P();
        BlockState cone = BlocksRegistry.RUBEUS_CONE.func_176223_P();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.func_185336_p((int)((float)(y + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                POS.func_223471_o(x + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        POS.func_223472_q(z + cz);
                        this.setIfAirLeaves(world, (BlockPos)POS, leaves);
                        if ((POS.func_177958_n() + POS.func_177952_p() & 1) == 0 && random.nextInt(6) == 0) {
                            this.setIfAir(world, POS.func_177977_b(), cone);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    private void setCondition(IWorld world, BlockPos pos, int y, BlockState state, boolean moss, Random random) {
        if (pos.func_177956_o() > y) {
            this.setIfAir(world, pos, state);
        } else {
            this.setIfGroundOrAir(world, pos, state);
        }
        if (moss && Math.abs(pos.func_177956_o() - y) < 4) {
            for (Direction dir : BlocksHelper.HORIZONTAL) {
                if (random.nextInt(3) <= 0) continue;
                this.setIfAir(world, pos.func_177972_a(dir), (BlockState)BlocksRegistry.JUNGLE_MOSS.func_176223_P().func_206870_a((Property)BlockPlantWall.FACING, (Comparable)dir));
            }
        }
    }

    private void setIfAir(IWorld world, BlockPos pos, BlockState state) {
        BlockState bState = world.func_180495_p(pos);
        if (world.func_175623_d(pos) || bState.func_185904_a().func_76222_j() || bState.func_177230_c() == BlocksRegistry.RUBEUS_LEAVES || bState.func_177230_c() == BlocksRegistry.RUBEUS_CONE) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfGroundOrAir(IWorld world, BlockPos pos, BlockState state) {
        BlockState bState = world.func_180495_p(pos);
        if (bState.func_196958_f() || bState.func_177230_c() == BlocksRegistry.RUBEUS_LEAVES || bState.func_185904_a().func_76222_j() || BlocksHelper.isNetherGround(bState)) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfAirLeaves(IWorld world, BlockPos pos, BlockState state) {
        BlockState bState = world.func_180495_p(pos);
        if (world.func_175623_d(pos) || bState.func_185904_a().func_76222_j()) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }
}

