/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureScatter
implements IStructure {
    private BlockPos.Mutable npos = new BlockPos.Mutable();
    private final Block plantBlock;
    private final Property<Integer> ageProp;
    private final int maxAge;

    public StructureScatter(Block plantBlock, Property<Integer> ageProperty, int maxAge) {
        this.plantBlock = plantBlock;
        this.ageProp = ageProperty;
        this.maxAge = maxAge;
    }

    public StructureScatter(Block plantBlock) {
        this.plantBlock = plantBlock;
        this.ageProp = null;
        this.maxAge = 0;
    }

    private boolean canPlaceAt(IServerWorld world, BlockPos pos) {
        return this.plantBlock.func_196260_a(this.plantBlock.func_176223_P(), (IWorldReader)world, pos);
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (world.func_175623_d(pos) && this.canPlaceAt(world, pos)) {
            BlockState state = this.plantBlock.func_176223_P();
            int rndState = random.nextInt(2);
            block0: for (int i = 0; i < 20; ++i) {
                int z;
                int x = pos.func_177958_n() + (int)(random.nextGaussian() * 4.0);
                if ((x + (z = pos.func_177952_p() + (int)(random.nextGaussian() * 4.0)) + rndState & 1) == 0) {
                    if (random.nextBoolean()) {
                        x += random.nextBoolean() ? 1 : -1;
                    } else {
                        z += random.nextBoolean() ? 1 : -1;
                    }
                }
                int y = pos.func_177956_o() + random.nextInt(8);
                for (int j = 0; j < 8; ++j) {
                    this.npos.func_181079_c(x, y - j, z);
                    if (!world.func_175623_d((BlockPos)this.npos) || !this.canPlaceAt(world, (BlockPos)this.npos)) continue;
                    if (this.ageProp != null) {
                        BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)this.npos, (BlockState)state.func_206870_a(this.ageProp, (Comparable)Integer.valueOf(random.nextInt(this.maxAge))));
                        continue block0;
                    }
                    BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)this.npos, state);
                    continue block0;
                }
            }
        }
    }
}

