/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockStalagnate;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureStalagnate
implements IStructure {
    public static final int MAX_LENGTH = 25;
    public static final int MIN_LENGTH = 3;

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        int length = BlocksHelper.upRay((IWorld)world, pos, 25);
        if (length > 3 && BlocksHelper.isNetherrack(world.func_180495_p(pos.func_177981_b(length + 1)))) {
            BlockState bottom = (BlockState)BlocksRegistry.STALAGNATE.func_176223_P().func_206870_a(BlockStalagnate.SHAPE, (Comparable)((Object)TripleShape.BOTTOM));
            BlockState middle = BlocksRegistry.STALAGNATE.func_176223_P();
            BlockState top = (BlockState)BlocksRegistry.STALAGNATE.func_176223_P().func_206870_a(BlockStalagnate.SHAPE, (Comparable)((Object)TripleShape.TOP));
            BlocksHelper.setWithUpdate((IWorld)world, pos, bottom);
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(length), top);
            for (int y = 1; y < length; ++y) {
                BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(y), middle);
            }
        }
    }

    public void generateDown(IServerWorld world, BlockPos pos, Random random) {
        int length = BlocksHelper.downRay((IWorld)world, pos, 25);
        if (length > 3 && BlocksHelper.isNetherrack(world.func_180495_p(pos.func_177979_c(length + 1)))) {
            BlockState bottom = (BlockState)BlocksRegistry.STALAGNATE.func_176223_P().func_206870_a(BlockStalagnate.SHAPE, (Comparable)((Object)TripleShape.BOTTOM));
            BlockState middle = BlocksRegistry.STALAGNATE.func_176223_P();
            BlockState top = (BlockState)BlocksRegistry.STALAGNATE.func_176223_P().func_206870_a(BlockStalagnate.SHAPE, (Comparable)((Object)TripleShape.TOP));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177979_c(length), bottom);
            BlocksHelper.setWithUpdate((IWorld)world, pos, top);
            for (int y = 1; y < length; ++y) {
                BlocksHelper.setWithUpdate((IWorld)world, pos.func_177979_c(y), middle);
            }
        }
    }
}

