/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.tileentities;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.registry.TileEntitiesRegistry;

public class BNSignTileEntity
extends TileEntity {
    private final ITextComponent[] text = new ITextComponent[]{StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_};
    private boolean editable = true;
    private PlayerEntity editor;
    private final IReorderingProcessor[] textBeingEdited = new IReorderingProcessor[4];
    private DyeColor textColor = DyeColor.BLACK;

    public BNSignTileEntity() {
        super(TileEntitiesRegistry.SIGN);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < 4; ++i) {
            String string = ITextComponent.Serializer.func_150696_a((ITextComponent)this.text[i]);
            tag.func_74778_a("ITextComponent" + (i + 1), string);
        }
        tag.func_74778_a("Color", this.textColor.name());
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.editable = false;
        super.func_230337_a_(state, tag);
        this.textColor = DyeColor.func_204271_a((String)tag.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
        for (int i = 0; i < 4; ++i) {
            String string = tag.func_74779_i("ITextComponent" + (i + 1));
            IFormattableTextComponent text = ITextComponent.Serializer.func_240643_a_((String)(string.isEmpty() ? "\"\"" : string));
            if (this.field_145850_b instanceof ServerWorld) {
                try {
                    this.text[i] = TextComponentUtils.func_240645_a_((CommandSource)this.getCommandSource(null), (ITextComponent)text, (Entity)null, (int)0);
                }
                catch (CommandSyntaxException var7) {
                    this.text[i] = text;
                }
            } else {
                this.text[i] = text;
            }
            this.textBeingEdited[i] = null;
        }
    }

    public void setTextOnRow(int row, ITextComponent text) {
        this.text[row] = text;
        this.textBeingEdited[row] = null;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IReorderingProcessor getTextBeingEditedOnRow(int row, Function<ITextComponent, IReorderingProcessor> function) {
        if (this.textBeingEdited[row] == null && this.text[row] != null) {
            this.textBeingEdited[row] = function.apply(this.text[row]);
        }
        return this.textBeingEdited[row];
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_183000_F() {
        return true;
    }

    public boolean isEditable() {
        return this.editable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEditable(boolean bl) {
        this.editable = bl;
        if (!bl) {
            this.editor = null;
        }
    }

    public void setEditor(PlayerEntity player) {
        this.editor = player;
    }

    public PlayerEntity getEditor() {
        return this.editor;
    }

    public boolean onActivate(PlayerEntity playerIn) {
        for (ITextComponent text : this.text) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = text == null ? null : text.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            playerIn.func_184102_h().func_195571_aL().func_197059_a(this.getCommandSource((ServerPlayerEntity)playerIn), clickevent.func_150668_b());
        }
        return true;
    }

    public CommandSource getCommandSource(@Nullable ServerPlayerEntity playerIn) {
        String s = playerIn == null ? "Sign" : playerIn.func_200200_C_().getString();
        StringTextComponent itextcomponent = playerIn == null ? new StringTextComponent("Sign") : playerIn.func_145748_c_();
        return new CommandSource(ICommandSource.field_213139_a_, Vector3d.func_237489_a_((Vector3i)this.field_174879_c), Vector2f.field_189974_a, (ServerWorld)this.field_145850_b, 2, s, (ITextComponent)itextcomponent, this.field_145850_b.func_73046_m(), (Entity)playerIn);
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public boolean setTextColor(DyeColor value) {
        if (value != this.getTextColor()) {
            this.textColor = value;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        return false;
    }
}

