/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.tileentities;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockChestOfDrawers;
import someoneelse.betternetherreforged.registry.TileEntitiesRegistry;

public class TileEntityChestOfDrawers
extends LockableLootTileEntity {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int watchers = 0;

    public TileEntityChestOfDrawers() {
        super(TileEntitiesRegistry.CHEST_OF_DRAWERS);
    }

    public int func_70302_i_() {
        return 27;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    protected void func_199721_a(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.chest_of_drawers", new Object[0]);
    }

    protected Container func_213906_a(int syncId, PlayerInventory playerInventory) {
        return ChestContainer.func_216992_a((int)syncId, (PlayerInventory)playerInventory, (IInventory)this);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tag) {
        super.func_230337_a_(blockState, tag);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(tag)) {
            ItemStackHelper.func_191283_b((CompoundNBT)tag, this.inventory);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!this.func_184282_c(tag)) {
            ItemStackHelper.func_191282_a((CompoundNBT)tag, this.inventory);
        }
        return tag;
    }

    public void onInvOpen(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.watchers < 0) {
                this.watchers = 0;
            }
            if (this.watchers == 0) {
                this.playSound(this.func_195044_w(), SoundEvents.field_219602_O);
            }
            ++this.watchers;
            this.onInvOpenOrClose();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.watchers;
            this.onInvOpenOrClose();
        }
    }

    protected void onInvOpenOrClose() {
        BlockState state = this.func_195044_w();
        Block block = state.func_177230_c();
        if (block instanceof BlockChestOfDrawers && !this.field_145850_b.field_72995_K) {
            if (this.watchers > 0 && !((Boolean)state.func_177229_b((Property)BlockChestOfDrawers.OPEN)).booleanValue()) {
                BlocksHelper.setWithoutUpdate((IWorld)((ServerWorld)this.field_145850_b), this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockChestOfDrawers.OPEN, (Comparable)Boolean.valueOf(true)));
            } else if (this.watchers == 0 && ((Boolean)state.func_177229_b((Property)BlockChestOfDrawers.OPEN)).booleanValue()) {
                BlocksHelper.setWithoutUpdate((IWorld)((ServerWorld)this.field_145850_b), this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockChestOfDrawers.OPEN, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private void playSound(BlockState blockState, SoundEvent soundEvent) {
        Vector3i vec3i = ((Direction)blockState.func_177229_b((Property)BlockChestOfDrawers.FACING)).func_176730_m();
        double d = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)vec3i.func_177958_n() / 2.0;
        double e = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)vec3i.func_177956_o() / 2.0;
        double f = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)vec3i.func_177952_p() / 2.0;
        this.field_145850_b.func_184148_a((PlayerEntity)null, d, e, f, soundEvent, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void addItemsToList(List<ItemStack> items) {
        for (ItemStack item : this.inventory) {
            if (item == null) continue;
            items.add(item);
        }
    }
}

