/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world.structures;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import someoneelse.betternetherreforged.world.structures.city.CityGenerator;
import someoneelse.betternetherreforged.world.structures.city.palette.Palettes;
import someoneelse.betternetherreforged.world.structures.piece.CavePiece;
import someoneelse.betternetherreforged.world.structures.piece.CityPiece;

public class CityFeature
extends Structure<NoFeatureConfig> {
    private static CityGenerator generator;
    public static final int RADIUS = 64;

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.STRONGHOLDS;
    }

    public CityFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public static void initGenerator() {
        generator = new CityGenerator();
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkx, int chunkz, MutableBoundingBox bounds, int reference, long seed) {
            super(structure, chunkx, chunkz, bounds, reference, seed);
        }

        public void func_230364_a_(DynamicRegistries p_230364_1_, ChunkGenerator chunkGenerator, TemplateManager structureManager, int x, int z, Biome biome, NoFeatureConfig featureConfig) {
            int d2;
            int px = x << 4 | 8;
            int pz = z << 4 | 8;
            int y = 40;
            if (chunkGenerator instanceof FlatChunkGenerator) {
                y = chunkGenerator.func_222529_a(px, pz, Heightmap.Type.WORLD_SURFACE);
            }
            BlockPos center = new BlockPos(px, y, pz);
            ArrayList<CityPiece> buildings = generator.generate(center, (Random)this.field_214631_d, Palettes.EMPTY);
            MutableBoundingBox cityBox = MutableBoundingBox.func_78887_a();
            for (CityPiece p : buildings) {
                cityBox.func_78888_b(p.func_74874_b());
            }
            int d1 = Math.max(center.func_177958_n() - cityBox.field_78897_a, cityBox.field_78893_d - center.func_177958_n());
            int radius = Math.max(d1, d2 = Math.max(center.func_177952_p() - cityBox.field_78896_c, cityBox.field_78892_f - center.func_177952_p()));
            if (radius / 2 + center.func_177956_o() < cityBox.field_78894_e) {
                radius = (cityBox.field_78894_e - center.func_177956_o()) / 2;
            }
            if (!(chunkGenerator instanceof FlatChunkGenerator)) {
                CavePiece cave = new CavePiece(center, radius, (Random)this.field_214631_d);
                this.field_75075_a.add(cave);
                this.field_75075_a.addAll(buildings);
                this.field_75074_b = cave.func_74874_b();
            } else {
                this.field_75075_a.addAll(buildings);
                this.func_202500_a();
            }
            this.field_75074_b.field_78897_a -= 12;
            this.field_75074_b.field_78893_d += 12;
            this.field_75074_b.field_78896_c -= 12;
            this.field_75074_b.field_78892_f += 12;
        }
    }
}

