/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world.structures.piece;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.world.BNWorldGenerator;

public class CityHelper {
    private static final Set<ChunkPos> POSITIONS = new HashSet<ChunkPos>(64);
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    public static boolean stopStructGen(int chunkX, int chunkZ, ChunkGenerator chunkGenerator, long worldSeed, SharedSeedRandom chunkRandom) {
        StructureSeparationSettings config = chunkGenerator.func_235957_b_().func_236197_a_((Structure)BNWorldGenerator.CITY);
        if (config != null && config.func_236668_a_() > 0) {
            CityHelper.collectNearby(chunkX, chunkZ, config, worldSeed, chunkRandom);
        }
        return CityHelper.stopGeneration(chunkX, chunkZ);
    }

    private static void collectNearby(int chunkX, int chunkZ, StructureSeparationSettings config, long worldSeed, SharedSeedRandom chunkRandom) {
        int x1 = chunkX - 16;
        int x2 = chunkX + 16;
        int z1 = chunkZ - 16;
        int z2 = chunkZ + 16;
        POSITIONS.clear();
        for (int x = x1; x <= x2; x += 8) {
            for (int z = z1; z <= z2; z += 8) {
                ChunkPos chunk = BNWorldGenerator.CITY.func_236392_a_(config, worldSeed, chunkRandom, x, z);
                POSITIONS.add(chunk);
            }
        }
    }

    private static void collectNearby(ServerWorld world, int chunkX, int chunkZ, StructureSeparationSettings config, long worldSeed, SharedSeedRandom chunkRandom) {
        int x1 = chunkX - 64;
        int x2 = chunkX + 64;
        int z1 = chunkZ - 64;
        int z2 = chunkZ + 64;
        POSITIONS.clear();
        POS.func_185336_p(64);
        for (int x = x1; x <= x2; x += 8) {
            POS.func_223471_o(x << 4);
            for (int z = z1; z <= z2; z += 8) {
                POS.func_223472_q(z << 4);
                if (!world.func_226691_t_((BlockPos)POS).func_242440_e().func_242493_a((Structure)BNWorldGenerator.CITY)) continue;
                ChunkPos chunk = BNWorldGenerator.CITY.func_236392_a_(config, worldSeed, chunkRandom, x, z);
                POSITIONS.add(chunk);
            }
        }
    }

    private static boolean stopGeneration(int chunkX, int chunkZ) {
        for (ChunkPos p : POSITIONS) {
            int dx = p.field_77276_a - chunkX;
            int dz = p.field_77275_b - chunkZ;
            if (dx * dx + dz * dz >= 64) continue;
            return true;
        }
        return false;
    }

    private static long sqr(int x) {
        return (long)x * (long)x;
    }

    public static BlockPos getNearestCity(BlockPos pos, ServerWorld world) {
        int cx = pos.func_177958_n() >> 4;
        int cz = pos.func_177952_p() >> 4;
        StructureSeparationSettings config = world.func_72863_F().func_201711_g().func_235957_b_().func_236197_a_((Structure)BNWorldGenerator.CITY);
        if (config == null || config.func_236668_a_() < 1) {
            return null;
        }
        CityHelper.collectNearby(world, cx, cz, config, world.func_72905_C(), new SharedSeedRandom());
        Iterator<ChunkPos> iterator = POSITIONS.iterator();
        if (iterator.hasNext()) {
            ChunkPos nearest = POSITIONS.iterator().next();
            long d = CityHelper.sqr(nearest.field_77276_a - cx) + CityHelper.sqr(nearest.field_77275_b - cz);
            while (iterator.hasNext()) {
                ChunkPos n = iterator.next();
                long d2 = CityHelper.sqr(n.field_77276_a - cx) + CityHelper.sqr(n.field_77275_b - cz);
                if (d2 >= d) continue;
                d = d2;
                nearest = n;
            }
            return nearest.func_206849_h();
        }
        return null;
    }
}

