/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world.structures.piece;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.world.structures.city.BuildingStructureProcessor;
import someoneelse.betternetherreforged.world.structures.city.StructureCityBuilding;
import someoneelse.betternetherreforged.world.structures.city.palette.CityPalette;
import someoneelse.betternetherreforged.world.structures.city.palette.Palettes;
import someoneelse.betternetherreforged.world.structures.piece.CustomPiece;
import someoneelse.betternetherreforged.world.structures.piece.StructureTypes;

public class CityPiece
extends CustomPiece {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private StructureProcessor paletteProcessor;
    private StructureCityBuilding building;
    private CityPalette palette;
    private BlockPos pos;

    public CityPiece(StructureCityBuilding building, BlockPos pos, int id, CityPalette palette) {
        super(StructureTypes.NETHER_CITY, id);
        this.building = building;
        this.pos = pos.func_185334_h();
        this.field_74887_e = building.getBoundingBox(pos);
        this.palette = palette;
        this.paletteProcessor = new BuildingStructureProcessor(palette);
    }

    protected CityPiece(TemplateManager manager, CompoundNBT tag) {
        super(StructureTypes.NETHER_CITY, tag);
        this.building = new StructureCityBuilding(tag.func_74779_i("building"), tag.func_74762_e("offset"));
        this.building = this.building.getRotated(Rotation.values()[tag.func_74762_e("rotation")]);
        this.building.setMirror(Mirror.values()[tag.func_74762_e("mirror")]);
        this.pos = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("pos"));
        this.field_74887_e = this.building.getBoundingBox(this.pos);
        this.palette = Palettes.getPalette(tag.func_74779_i("palette"));
        this.paletteProcessor = new BuildingStructureProcessor(this.palette);
    }

    protected void func_143011_b(CompoundNBT tag) {
        tag.func_74778_a("building", this.building.getName());
        tag.func_74768_a("rotation", this.building.getRotation().ordinal());
        tag.func_74768_a("mirror", this.building.getMirror().ordinal());
        tag.func_74768_a("offset", this.building.getYOffset());
        tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        tag.func_74778_a("palette", this.palette.getName());
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager arg, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (!this.field_74887_e.func_78884_a(blockBox)) {
            return true;
        }
        MutableBoundingBox clamped = new MutableBoundingBox(this.field_74887_e);
        clamped.field_78897_a = Math.max(clamped.field_78897_a, blockBox.field_78897_a);
        clamped.field_78893_d = Math.min(clamped.field_78893_d, blockBox.field_78893_d);
        clamped.field_78895_b = Math.max(clamped.field_78895_b, blockBox.field_78895_b);
        clamped.field_78894_e = Math.min(clamped.field_78894_e, blockBox.field_78894_e);
        clamped.field_78896_c = Math.max(clamped.field_78896_c, blockBox.field_78896_c);
        clamped.field_78892_f = Math.min(clamped.field_78892_f, blockBox.field_78892_f);
        this.building.placeInChunk((IServerWorld)world, this.pos, clamped, this.paletteProcessor);
        IChunk chunk = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
        for (int x = clamped.field_78897_a; x <= clamped.field_78893_d; ++x) {
            for (int z = clamped.field_78896_c; z <= clamped.field_78892_f; ++z) {
                int y;
                POS.func_181079_c(x, clamped.field_78895_b, z);
                BlockState state = world.func_180495_p((BlockPos)POS);
                if (!state.func_196958_f() && state.func_235785_r_((IBlockReader)world, (BlockPos)POS)) {
                    for (y = clamped.field_78895_b - 1; y > 4; --y) {
                        POS.func_185336_p(y);
                        BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, state);
                        if (BlocksHelper.isNetherGroundMagma(world.func_180495_p(POS.func_177977_b()))) break;
                    }
                }
                for (y = clamped.field_78895_b; y <= clamped.field_78894_e; ++y) {
                    POS.func_185336_p(y);
                    chunk.func_201594_d((BlockPos)POS);
                }
            }
        }
        return true;
    }
}

