/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="bigbrain")
public class BigBrainClientEvents {
    public static final Method preRenderCallback = ObfuscationReflectionHelper.findMethod(LivingEntityRenderer.class, (String)"m_7546_", (Class[])new Class[]{LivingEntity.class, PoseStack.class, Float.TYPE});

    @SubscribeEvent
    public static void onMovementKeyPressed(MovementInputUpdateEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((IBucklerUser)player).isBucklerDashing()) {
            event.getInput().f_108572_ = false;
            event.getInput().f_108566_ = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        PoseStack mStack = event.getPoseStack();
        ItemStack stack = event.getItemStack();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float partialTicks = event.getPartialTicks();
        if (stack.m_41720_() instanceof BucklerItem && (player.m_6117_() && player.m_21211_() == stack || ((IBucklerUser)player).isBucklerDashing() && BucklerItem.isReady(stack))) {
            boolean mainHand = event.getHand() == InteractionHand.MAIN_HAND;
            HumanoidArm handside = mainHand ? player.m_5737_() : player.m_5737_().m_20828_();
            boolean rightHanded = handside == HumanoidArm.RIGHT;
            float f7 = (float)stack.m_41779_() - ((float)player.m_21212_() - partialTicks + 1.0f);
            float f11 = f7 / 10.0f;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            mStack.m_85836_();
            int i = rightHanded ? 1 : -1;
            mStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + event.getEquipProgress() * -0.6f), (double)-0.72f);
            mStack.m_85837_((double)f11 * 0.2, 0.0, (double)f11 * 0.2);
            ItemTransforms.TransformType transform = !rightHanded ? ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND : ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            Minecraft.m_91087_().m_91292_().m_109322_((LivingEntity)player, stack, transform, !rightHanded, mStack, event.getMultiBufferSource(), event.getPackedLight());
            mStack.m_85849_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityRenderPre(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entityIn = event.getEntity();
        LivingEntityRenderer renderer = event.getRenderer();
        EntityModel model = renderer.m_7200_();
        PoseStack stack = event.getPoseStack();
        if (!BigBrainConfig.RenderAfterImage.booleanValue()) {
            return;
        }
        if (((IBucklerUser)entityIn).isBucklerDashing()) {
            for (int i = 0; i < 5; ++i) {
                Direction direction;
                boolean shouldSit;
                if (i == 0) continue;
                stack.m_85836_();
                model.f_102608_ = entityIn.m_21324_(event.getPartialTick());
                model.f_102609_ = shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
                model.f_102610_ = entityIn.m_6162_();
                float f = Mth.m_14189_((float)event.getPartialTick(), (float)entityIn.f_20884_, (float)entityIn.f_20883_);
                float f1 = Mth.m_14189_((float)event.getPartialTick(), (float)entityIn.f_20886_, (float)entityIn.f_20885_);
                float f2 = f1 - f;
                if (shouldSit && entityIn.m_20202_() instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entityIn.m_20202_();
                    f = Mth.m_14189_((float)event.getPartialTick(), (float)livingentity.f_20884_, (float)livingentity.f_20883_);
                    f2 = f1 - f;
                    float f3 = Mth.m_14177_((float)f2);
                    if (f3 < -85.0f) {
                        f3 = -85.0f;
                    }
                    if (f3 >= 85.0f) {
                        f3 = 85.0f;
                    }
                    f = f1 - f3;
                    if (f3 * f3 > 2500.0f) {
                        f += f3 * 0.2f;
                    }
                    f2 = f1 - f;
                }
                float f6 = Mth.m_14179_((float)event.getPartialTick(), (float)entityIn.f_19860_, (float)entityIn.m_146909_());
                if (entityIn.m_20089_() == Pose.SLEEPING && (direction = entityIn.m_21259_()) != null) {
                    float f4 = entityIn.m_20236_(Pose.STANDING) - 0.1f;
                    stack.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
                }
                float f7 = (float)entityIn.f_19797_ + event.getPartialTick();
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - f));
                try {
                    preRenderCallback.invoke((Object)renderer, entityIn, stack, Float.valueOf(event.getPartialTick()));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    new RuntimeException("Big Brain has failed to invoke preRenderCallback via reflection.");
                }
                stack.m_85841_(-1.0f, -1.0f, 1.0f);
                double motionZ = Math.abs(entityIn.m_20184_().m_7094_());
                stack.m_85837_(0.0, (double)-1.501f, (double)i * motionZ * 4.0 / (double)((IBucklerUser)entityIn).getBucklerUseTimer());
                float f8 = 0.0f;
                float f5 = 0.0f;
                if (!shouldSit && entityIn.m_6084_()) {
                    f8 = Mth.m_14179_((float)event.getPartialTick(), (float)entityIn.f_20923_, (float)entityIn.f_20924_);
                    f5 = entityIn.f_20925_ - entityIn.f_20924_ * (1.0f - event.getPartialTick());
                    if (entityIn.m_6162_()) {
                        f5 *= 3.0f;
                    }
                    if (f8 > 1.0f) {
                        f8 = 1.0f;
                    }
                }
                model.m_6839_((Entity)entityIn, f5, f8, event.getPartialTick());
                model.m_6973_((Entity)entityIn, f5, f8, f7, f2, f6);
                Minecraft minecraft = Minecraft.m_91087_();
                boolean flag = !entityIn.m_20145_();
                boolean flag1 = !flag && !entityIn.m_20177_((Player)minecraft.f_91074_);
                boolean flag2 = minecraft.m_91314_((Entity)entityIn);
                RenderType rendertype = BigBrainClientEvents.getRenderType(entityIn, renderer, model, flag, flag1, flag2);
                if (rendertype != null) {
                    VertexConsumer ivertexbuilder = event.getMultiBufferSource().m_6299_(rendertype);
                    int overlay = LivingEntityRenderer.m_115338_((LivingEntity)entityIn, (float)0.0f);
                    model.m_7695_(stack, ivertexbuilder, event.getPackedLight(), overlay, 1.0f, 1.0f, 1.0f, 0.3f / (float)i + 1.0f);
                }
                if (!entityIn.m_5833_() && BigBrainConfig.RenderEntityLayersDuringAfterImage.booleanValue()) {
                    for (RenderLayer layerrenderer : renderer.f_115291_) {
                        layerrenderer.m_6494_(stack, event.getMultiBufferSource(), event.getPackedLight(), (Entity)entityIn, f5, f8, event.getPartialTick(), f7, f2, f6);
                    }
                }
                stack.m_85849_();
            }
        }
    }

    public static RenderType getRenderType(LivingEntity p_230496_1_, LivingEntityRenderer<LivingEntity, ?> renderer, EntityModel<?> model, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = renderer.m_5478_((Entity)p_230496_1_);
        if (p_230496_3_) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (p_230496_2_) {
            return RenderType.m_110473_((ResourceLocation)resourcelocation);
        }
        return p_230496_4_ ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }
}

