/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.mixins;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.BigBrainEnchantments;
import tallestegg.bigbrain.BigBrainItems;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

@Mixin(value={PiglinBrute.class})
public abstract class PiglinBruteMixin
extends AbstractPiglin
implements IBucklerUser {
    protected PiglinBruteMixin(EntityType<? extends AbstractPiglin> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(at={@At(value="TAIL")}, method={"finalizeSpawn(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/entity/SpawnGroupData;"})
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_35058_, DifficultyInstance p_35059_, MobSpawnType p_35060_, @Nullable SpawnGroupData p_35061_, @Nullable CompoundTag p_35062_, CallbackInfoReturnable<SpawnGroupData> info) {
        this.m_6850_(p_35059_);
        return super.m_6518_(p_35058_, p_35059_, p_35060_, p_35061_, p_35062_);
    }

    @Inject(at={@At(value="TAIL")}, method={"populateDefaultEquipmentSlots"})
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance difficulty, CallbackInfo info) {
        if (!BigBrainConfig.BruteSpawningWithBuckler.booleanValue()) {
            return;
        }
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)BigBrainItems.BUCKLER.get()));
        this.setCooldown(240);
    }

    protected void m_7908_(float p_241844_1_) {
        Map map;
        ItemStack itemstack;
        if (this.f_19796_.nextInt(300) == 0 && (itemstack = this.m_21206_()).m_41720_() instanceof BucklerItem) {
            map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            map.putIfAbsent((Enchantment)BigBrainEnchantments.TURNING.get(), 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.OFFHAND, itemstack);
        }
        if (this.f_19796_.nextInt(500) == 0 && (itemstack = this.m_21206_()).m_41720_() instanceof BucklerItem) {
            map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            map.putIfAbsent((Enchantment)BigBrainEnchantments.BANG.get(), 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.OFFHAND, itemstack);
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        ItemStack itemstack = this.m_21206_();
        if (itemstack.m_41720_() instanceof BucklerItem) {
            boolean flag;
            float f = 0.1f;
            boolean bl = flag = f > 1.0f;
            if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack) && (recentlyHitIn || flag) && Math.max(this.f_19796_.nextFloat() - (float)looting * 0.01f, 0.0f) < f) {
                if (!flag && itemstack.m_41763_()) {
                    itemstack.m_41721_(this.f_19796_.nextInt(this.f_19796_.nextInt(itemstack.m_41776_() / 2)));
                }
                this.m_19983_(itemstack);
                this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
        }
    }
}

