/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="bigbrain", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BigBrainConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    public static Boolean PillagerCover;
    public static Boolean PillagerMultishot;
    public static Boolean MobsAttackAllVillagers;
    public static Boolean BruteSpawningWithBuckler;
    public static Boolean BangBlockDestruction;
    public static Boolean PolarBearFish;
    public static Boolean RenderAfterImage;
    public static Boolean RenderEntityLayersDuringAfterImage;
    public static Boolean snowGolemSlow;
    public static Boolean animalShelter;
    public static Boolean meleeFix;
    public static Boolean ocelotParrot;
    public static Boolean ocelotPhantom;
    public static Boolean ocelotCreeper;
    public static Boolean sheepRunAway;
    public static Boolean openFenceGate;
    public static float spyGlassPillagerChance;
    public static Integer BucklerCooldown;
    public static Integer BucklerTurningRunTime;
    public static Integer BucklerRunTime;
    public static Integer minPigBabiesBred;
    public static Integer maxPigBabiesBred;
    public static Double mobBlindnessVision;
    public static List<String> MobBlackList;
    public static List<String> AnimalBlackList;
    public static List<String> NightAnimalBlackList;
    public static List<String> RainAnimalBlackList;
    public static List<String> EntitiesThatCanAlsoUseTheBuckler;
    public static List<String> cantOpenFenceGates;

    public static void bakeCommonConfig() {
        PillagerCover = (Boolean)BigBrainConfig.COMMON.PillagerCover.get();
        PillagerMultishot = (Boolean)BigBrainConfig.COMMON.PillagerMultishot.get();
        MobsAttackAllVillagers = (Boolean)BigBrainConfig.COMMON.MobsAttackAllVillagers.get();
        MobBlackList = (List)BigBrainConfig.COMMON.MobBlackList.get();
        BruteSpawningWithBuckler = (Boolean)BigBrainConfig.COMMON.BruteBuckler.get();
        BucklerCooldown = (Integer)BigBrainConfig.COMMON.BucklerCooldown.get();
        BucklerRunTime = (Integer)BigBrainConfig.COMMON.BucklerRunTime.get();
        BangBlockDestruction = (Boolean)BigBrainConfig.COMMON.BangBlockDestruction.get();
        PolarBearFish = (Boolean)BigBrainConfig.COMMON.PolarBearFish.get();
        BucklerTurningRunTime = (Integer)BigBrainConfig.COMMON.BucklerTurningRunTime.get();
        minPigBabiesBred = (Integer)BigBrainConfig.COMMON.minPigBabiesBred.get();
        maxPigBabiesBred = (Integer)BigBrainConfig.COMMON.maxPigBabiesBred.get();
        snowGolemSlow = (Boolean)BigBrainConfig.COMMON.snowGolemSlow.get();
        AnimalBlackList = (List)BigBrainConfig.COMMON.AnimalCoverBlackList.get();
        NightAnimalBlackList = (List)BigBrainConfig.COMMON.NightCoverBlackList.get();
        RainAnimalBlackList = (List)BigBrainConfig.COMMON.RainAnimalBlackList.get();
        animalShelter = (Boolean)BigBrainConfig.COMMON.animalShelter.get();
        mobBlindnessVision = (Double)BigBrainConfig.COMMON.mobBlindnessVision.get();
        meleeFix = (Boolean)BigBrainConfig.COMMON.meleeFix.get();
        EntitiesThatCanAlsoUseTheBuckler = (List)BigBrainConfig.COMMON.EntitiesThatCanAlsoUseTheBuckler.get();
        ocelotCreeper = (Boolean)BigBrainConfig.COMMON.ocelotCreeper.get();
        ocelotParrot = (Boolean)BigBrainConfig.COMMON.ocelotParrot.get();
        ocelotPhantom = (Boolean)BigBrainConfig.COMMON.ocelotPhantom.get();
        sheepRunAway = (Boolean)BigBrainConfig.COMMON.sheepRunAway.get();
        spyGlassPillagerChance = ((Double)BigBrainConfig.COMMON.pillagerSpyGlass.get()).floatValue();
        openFenceGate = (Boolean)BigBrainConfig.COMMON.openFenceGates.get();
        cantOpenFenceGates = (List)BigBrainConfig.COMMON.fenceGateBlacklist.get();
    }

    public static void bakeClientConfig() {
        RenderAfterImage = (Boolean)BigBrainConfig.CLIENT.RenderAfterImage.get();
        RenderEntityLayersDuringAfterImage = (Boolean)BigBrainConfig.CLIENT.RenderEntityLayersDuringAfterImage.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            BigBrainConfig.bakeCommonConfig();
        }
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            BigBrainConfig.bakeClientConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        Pair specPair1 = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)specPair1.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair1.getRight();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue PillagerCover;
        public final ForgeConfigSpec.BooleanValue PillagerMultishot;
        public final ForgeConfigSpec.BooleanValue MobsAttackAllVillagers;
        public final ForgeConfigSpec.BooleanValue BruteBuckler;
        public final ForgeConfigSpec.BooleanValue BangBlockDestruction;
        public final ForgeConfigSpec.BooleanValue PolarBearFish;
        public final ForgeConfigSpec.BooleanValue snowGolemSlow;
        public final ForgeConfigSpec.BooleanValue animalShelter;
        public final ForgeConfigSpec.BooleanValue animalPanic;
        public final ForgeConfigSpec.BooleanValue meleeFix;
        public final ForgeConfigSpec.BooleanValue ocelotParrot;
        public final ForgeConfigSpec.BooleanValue ocelotPhantom;
        public final ForgeConfigSpec.BooleanValue ocelotCreeper;
        public final ForgeConfigSpec.BooleanValue sheepRunAway;
        public final ForgeConfigSpec.BooleanValue openFenceGates;
        public final ForgeConfigSpec.BooleanValue bowAiNew;
        public final ForgeConfigSpec.BooleanValue huskBurrowing;
        public final ForgeConfigSpec.BooleanValue jumpAi;
        public final ForgeConfigSpec.DoubleValue pillagerSpyGlass;
        public final ForgeConfigSpec.IntValue BucklerCooldown;
        public final ForgeConfigSpec.IntValue BucklerRunTime;
        public final ForgeConfigSpec.IntValue BucklerTurningRunTime;
        public final ForgeConfigSpec.IntValue minPigBabiesBred;
        public final ForgeConfigSpec.IntValue maxPigBabiesBred;
        public final ForgeConfigSpec.DoubleValue mobBlindnessVision;
        public final ForgeConfigSpec.ConfigValue<List<String>> MobBlackList;
        public final ForgeConfigSpec.ConfigValue<List<String>> AnimalCoverBlackList;
        public final ForgeConfigSpec.ConfigValue<List<String>> NightCoverBlackList;
        public final ForgeConfigSpec.ConfigValue<List<String>> RainAnimalBlackList;
        public final ForgeConfigSpec.ConfigValue<List<String>> EntitiesThatCanAlsoUseTheBuckler;
        public final ForgeConfigSpec.ConfigValue<List<String>> fenceGateBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> bowAiBlackList;
        public final ForgeConfigSpec.ConfigValue<List<String>> jumpWhiteList;
        public final ForgeConfigSpec.ConfigValue<List<String>> jumpBlackList;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("all mobs");
            this.meleeFix = builder.translation("bigbrain.config.meleeFix").define("Enable the fix for melee cooldowns for mobs?", true);
            this.mobBlindnessVision = builder.translation("bigbrain.config.blindness").comment("This determines the range a mob will detect other entities if they have the blindness potion, by default entities will only detect targets in a 10 block radius if they are blinded.").defineInRange("Blindness range", 0.1, -500.0, 10000.0);
            this.MobsAttackAllVillagers = builder.translation("bigbrain.config.attackvillagers").define("Have all mobs attack villagers?", false);
            this.MobBlackList = builder.translation("bigbrain.config.blacklist").comment("Any mob id in this list will not attack villagers if the config option for that is on.").define("Mob BlackList", new ArrayList());
            this.EntitiesThatCanAlsoUseTheBuckler = builder.translation("bigbrain.config.mobBucklerWhiteList").comment("Any mob id input in this list will be able to use the buckler").define("Mobs that can also use the buckler", (Object)Lists.newArrayList((Object[])new String[]{"guardvillagers:guard"}));
            this.openFenceGates = builder.define("Allow mobs to open fence gates if they are already able to open doors", true);
            this.fenceGateBlacklist = builder.comment("Any mob id input in this list will not open fence gates if they're already able to open doors").define("Fence Gate Opening Blacklist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:husk", "minecraft:zombie", "minecraft:vindicator", "minecraft:drowned"}));
            this.bowAiNew = builder.define("Enable new bow ai?", true);
            this.bowAiBlackList = builder.define("Mobs that don't have the new bow ai", (Object)Lists.newArrayList());
            this.jumpAi = builder.define("Enable jumping ai", true);
            this.jumpWhiteList = builder.define("List additional mobs that can also utilize jumping", (Object)Lists.newArrayList((Object[])new String[]{"guardvillagers:guard"}));
            this.jumpBlackList = builder.define("Mobs that don't have the jumping ai", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:villager"}));
            builder.pop();
            builder.push("buckler");
            this.BangBlockDestruction = builder.translation("bigbrain.config.blockBoom").define("Have the explosion spawned while using the Bang! enchant destroy blocks?", false);
            this.BruteBuckler = builder.translation("bigbrain.config.bruteBuckler").define("Have brutes spawn with bucklers?", true);
            this.BucklerCooldown = builder.translation("bigbrain.config.bucklerCoolDown").defineInRange("How long should the buckler's cooldown be in ticks?", 240, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.BucklerRunTime = builder.translation("bigbrain.config.bucklerRunTime").defineInRange("How long should the buckler's charge move be in ticks?", 15, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.BucklerTurningRunTime = builder.translation("bigbrain.config.bucklerRunTime").defineInRange("How long should the buckler's charge move if you have the turning enchant be in ticks?", 30, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
            builder.push("husk");
            this.huskBurrowing = builder.define("Enable burrowing attack for husk?", true);
            builder.pop();
            builder.push("pillager");
            this.PillagerCover = builder.translation("bigbrain.config.pillagerCover").define("Have pillagers run while reloading?", true);
            this.PillagerMultishot = builder.translation("bigbrain.config.pillagerMultishot").define("Have pillagers go closer to you if they have a multishot crossbow?", true);
            this.pillagerSpyGlass = builder.defineInRange("Chance of a pillager patrol leader getting a spyglass", 0.5, 0.0, 900.0);
            builder.pop();
            builder.push("animals");
            this.animalPanic = builder.define("Have animals alert their kin to panic if hurt?", true);
            this.AnimalCoverBlackList = builder.translation("bigbrain.config.animalBlacklist").comment("Any mob id in this list will not attempt to find an area to stay in while it's raining or at night.").define("Animal BlackList", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:fox", "minecraft:wolf", "minecraft:turtle", "minecraft:polar_bear", "minecraft:axolotl"}));
            this.NightCoverBlackList = builder.translation("bigbrain.config.animalNightBlacklist").comment("Any mob id in this list will not attempt to find an area to stay in while it's night.").define("Animal Night BlackList", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:cat"}));
            this.RainAnimalBlackList = builder.translation("bigbrain.config.animalRainBlacklist").comment("Any mob id in this list will not attempt to find an area to stay in while it's raining.").define("Animal Raining BlackList", (Object)Lists.newArrayList());
            this.animalShelter = builder.translation("bigbrain.config.animalShelter").define("Animals seek shelter?", true);
            builder.push("pigs");
            this.minPigBabiesBred = builder.translation("bigbrain.config.minPigs").defineInRange("What is the minimium amount of extra piglets that could be bred?", 1, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.maxPigBabiesBred = builder.translation("bigbrain.config.maxPigs").defineInRange("What is the maxmium amount of extra piglets that could be bred?", 4, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.push("polar bears");
            this.PolarBearFish = builder.translation("bigbrain.config.polarBearFish").define("Have polar bears attack fish?", true);
            builder.pop();
            builder.push("ocelots");
            this.ocelotCreeper = builder.define("Have ocelots attack creepers? (Creepers won't attack back)", true);
            this.ocelotParrot = builder.define("Have ocelots attack parrots?", true);
            this.ocelotPhantom = builder.define("Have ocelots attack phantoms?", true);
            builder.pop();
            builder.push("sheep");
            this.sheepRunAway = builder.define("Have sheep run away from wolves?", true);
            builder.pop();
            builder.push("snow golems");
            this.snowGolemSlow = builder.translation("bigbrain.config.snowGolemSlow").comment("Freezing time can be added up by successive shots.").define("Allow snow balls to apply 5 seconds of freezing when they hit an entity?", true);
            builder.pop();
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue RenderAfterImage;
        public final ForgeConfigSpec.BooleanValue RenderEntityLayersDuringAfterImage;
        public final ForgeConfigSpec.BooleanValue bedrockBeeAnim;
        public final ForgeConfigSpec.BooleanValue drownedGlow;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("after image");
            this.RenderAfterImage = builder.translation("bigbrain.config.afterImage").define("Render an after image while an entity is charging with a buckler?", true);
            this.RenderEntityLayersDuringAfterImage = builder.translation("bigbrain.config.entityLayers").comment("Keep in mind this won't affect their opacity due to technical reasons.").define("Render entity layers while rendering the after image?", false);
            builder.pop();
            builder.push("bedrock animations");
            this.bedrockBeeAnim = builder.define("Allow bees to have a idle animation akin to bedrock", true);
            this.drownedGlow = builder.define("Allow drowned to render glowing spots, like in bedrock", true);
            builder.pop();
        }
    }
}

