/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.client.BigBrainSounds;
import tallestegg.bigbrain.common.capabilities.BigBrainCapabilities;
import tallestegg.bigbrain.common.capabilities.implementations.BurrowCapability;
import tallestegg.bigbrain.common.capabilities.providers.BurrowingProvider;
import tallestegg.bigbrain.common.enchantments.BigBrainEnchantments;
import tallestegg.bigbrain.common.entity.IBucklerUser;
import tallestegg.bigbrain.common.entity.IOneCriticalAfterCharge;
import tallestegg.bigbrain.common.entity.ai.goals.FindShelterGoal;
import tallestegg.bigbrain.common.entity.ai.goals.HuskBurrowGoal;
import tallestegg.bigbrain.common.entity.ai.goals.NewBowAttackGoal;
import tallestegg.bigbrain.common.entity.ai.goals.OpenFenceGateGoal;
import tallestegg.bigbrain.common.entity.ai.goals.ParkourGoal;
import tallestegg.bigbrain.common.entity.ai.goals.PressureEntityWithMultishotCrossbowGoal;
import tallestegg.bigbrain.common.entity.ai.goals.RestrictSunAnimalGoal;
import tallestegg.bigbrain.common.entity.ai.goals.RunWhileChargingGoal;
import tallestegg.bigbrain.common.entity.ai.goals.UseBucklerGoal;
import tallestegg.bigbrain.common.entity.ai.goals.ZoomInAtRandomGoal;
import tallestegg.bigbrain.common.items.BucklerItem;
import tallestegg.bigbrain.networking.BigBrainNetworking;
import tallestegg.bigbrain.networking.BurrowingCapabilityPacket;

@Mod.EventBusSubscriber(modid="bigbrain")
public class BigBrainEvents {
    private static final Method setTargetPiglin = ObfuscationReflectionHelper.findMethod(PiglinAi.class, (String)"m_34826_", (Class[])new Class[]{AbstractPiglin.class, LivingEntity.class});

    @SubscribeEvent
    public static void onBreed(BabyEntitySpawnEvent event) {
        if (event.getParentA().m_6095_() == EntityType.f_20510_ && event.getParentB().m_6095_() == EntityType.f_20510_) {
            Pig pig = (Pig)event.getParentA();
            Level level = pig.m_9236_();
            RandomSource randomSource = level.m_213780_();
            for (int i = 0; i < BigBrainConfig.minPigBabiesBred + randomSource.m_188503_(BigBrainConfig.maxPigBabiesBred + 1); ++i) {
                Pig baby = (Pig)EntityType.f_20510_.m_20615_(event.getChild().f_19853_);
                baby.m_20359_((Entity)pig);
                baby.m_21530_();
                if (level.m_46469_().m_46207_(GameRules.f_46135_)) {
                    level.m_7967_((Entity)new ExperienceOrb(level, pig.m_20185_(), pig.m_20186_(), pig.m_20189_(), pig.m_217043_().m_188503_(7) + 1));
                }
                baby.m_6863_(true);
                baby.m_21530_();
                pig.m_20193_().m_7967_((Entity)baby);
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof IBucklerUser && ((IBucklerUser)event.getEntity()).isBucklerDashing()) {
            event.getEntity().m_20334_(event.getEntity().m_20184_().m_7096_(), 0.0, event.getEntity().m_20184_().m_7094_());
        }
    }

    @SubscribeEvent
    public static void modifiyVisibility(LivingEvent.LivingVisibilityEvent event) {
        Entity entity = event.getLookingEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21023_(MobEffects.f_19610_)) {
                event.modifyVisibility(BigBrainConfig.mobBlindnessVision.doubleValue());
            }
            if (living.m_21211_().m_41720_() instanceof SpyglassItem && living.m_21051_(Attributes.f_22277_) != null) {
                event.modifyVisibility(living.m_21133_(Attributes.f_22277_) * 2.0);
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        LivingEntity living;
        Entity entity;
        if (event.getProjectile() instanceof Snowball && BigBrainConfig.snowGolemSlow.booleanValue() && event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_142079_()) {
            living.m_146917_(living.m_146888_() + 100);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        Player player = event.getEntity();
        if (BigBrainConfig.snowGolemSlow.booleanValue() && item == Items.f_42452_) {
            player.m_21011_(event.getHand(), true);
            player.m_36335_().m_41524_(item, 4);
        }
    }

    @SubscribeEvent
    public static void entityHitbox(EntityEvent.Size event) {
        Husk husk;
        Entity entity = event.getEntity();
        if (entity instanceof Husk && (husk = (Husk)entity).m_217003_(Pose.SWIMMING)) {
            event.setNewSize(EntityDimensions.m_20395_((float)1.0f, (float)1.5f), true);
            event.setNewEyeHeight(0.5f);
        }
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Husk husk;
            Player player = (Player)entity;
            Entity entity2 = event.getEntityBeingMounted();
            if (entity2 instanceof Husk && (husk = (Husk)entity2).m_6084_() && BigBrainCapabilities.getBurrowing((LivingEntity)husk).isCarrying() && (!player.m_5833_() || !player.m_7500_()) && player.m_6084_() && event.isDismounting()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        Dolphin dolphin;
        Husk husk;
        BurrowCapability burrow;
        LivingEntity entity = event.getEntity();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Husk && (burrow = BigBrainCapabilities.getBurrowing((LivingEntity)(husk = (Husk)livingEntity))) != null) {
            if (!husk.f_19853_.f_46443_) {
                BigBrainNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> husk), (Object)new BurrowingCapabilityPacket(husk.m_19879_(), burrow.isBurrowing()));
            }
            if (burrow.isBurrowing()) {
                BigBrainEvents.spawnRunningEffectsWhileCharging(entity);
                if (entity.m_217043_().m_188503_(10) == 0) {
                    BlockState onState = husk.m_20075_();
                    husk.m_216990_(onState.getSoundType((LevelReader)husk.f_19853_, husk.m_20183_(), (Entity)husk).m_56775_());
                }
            }
        }
        if (entity instanceof Dolphin && (dolphin = (Dolphin)entity).m_146899_()) {
            dolphin.m_20301_(300);
        }
        if (entity instanceof IBucklerUser) {
            int turningLevel = BigBrainEnchantments.getBucklerEnchantsOnHands((Enchantment)BigBrainEnchantments.TURNING.get(), entity);
            if (!((IBucklerUser)entity).isBucklerDashing()) {
                ((IBucklerUser)entity).setBucklerUseTimer(((IBucklerUser)entity).getBucklerUseTimer() + 1);
                int configValue = turningLevel == 0 ? BigBrainConfig.BucklerRunTime : BigBrainConfig.BucklerTurningRunTime;
                if (((IBucklerUser)entity).getBucklerUseTimer() > configValue) {
                    ((IBucklerUser)entity).setBucklerUseTimer(configValue);
                }
                ((IBucklerUser)entity).setCooldown(((IBucklerUser)entity).getCooldown() + 1);
                if (((IBucklerUser)entity).getCooldown() > BigBrainConfig.BucklerCooldown) {
                    ((IBucklerUser)entity).setCooldown(BigBrainConfig.BucklerCooldown);
                }
            }
            if (((IBucklerUser)entity).isBucklerDashing()) {
                BucklerItem.moveFowards(entity);
                ((IBucklerUser)entity).setBucklerUseTimer(((IBucklerUser)entity).getBucklerUseTimer() - 1);
                ((IBucklerUser)entity).setCooldown(((IBucklerUser)entity).getCooldown() - 1);
                BigBrainEvents.spawnRunningEffectsWhileCharging(entity);
                if (turningLevel == 0 && !entity.f_19853_.m_5776_()) {
                    BigBrainEvents.bucklerBash(entity);
                }
                if (((IBucklerUser)entity).getBucklerUseTimer() <= 0) {
                    InteractionHand hand = entity.m_21205_().m_41720_() instanceof BucklerItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    ItemStack stack = entity.m_21120_(hand);
                    ((IBucklerUser)entity).setBucklerDashing(false);
                    ((IBucklerUser)entity).setBucklerUseTimer(0);
                    ((IBucklerUser)entity).setCooldown(0);
                    BucklerItem.setReady(stack, false);
                    entity.m_5810_();
                }
                if (((IBucklerUser)entity).getCooldown() <= 0) {
                    ((IBucklerUser)entity).setCooldown(0);
                }
            }
        }
        if (entity instanceof IOneCriticalAfterCharge && ((IOneCriticalAfterCharge)entity).isCritical()) {
            for (int i = 0; i < 2; ++i) {
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().toString().contains("minecraft:chests/bastion")) {
            ResourceLocation bucklerBastionLoot = new ResourceLocation("bigbrain", "chests/buckler_loot_table");
            event.getTable().addPool(LootPool.m_79043_().name("buckler_bastion_chests").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)bucklerBastionLoot)).m_79082_());
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(CriticalHitEvent event) {
        if (((IOneCriticalAfterCharge)event.getEntity()).isCritical()) {
            event.setResult(Event.Result.ALLOW);
            event.setDamageModifier(1.5f);
            event.getEntity().f_19853_.m_6263_((Player)null, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), SoundEvents.f_12313_, event.getEntity().m_5720_(), 1.0f, 1.0f);
            ((IOneCriticalAfterCharge)event.getEntity()).setCritical(false);
        }
    }

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        BurrowingProvider burrowingProvider = new BurrowingProvider();
        if (event.getObject() instanceof Husk) {
            event.addCapability(BurrowingProvider.IDENTIFIER, (ICapabilityProvider)burrowingProvider);
            event.addListener(burrowingProvider::invalidate);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (event.getEntity() instanceof Husk && DamageSource.f_19310_.equals(event.getSource()) && BigBrainCapabilities.getBurrowing(event.getEntity()).isCarrying()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Husk) {
            Husk husk = (Husk)entity;
            if (((Boolean)BigBrainConfig.COMMON.huskBurrowing.get()).booleanValue()) {
                husk.f_21345_.m_25352_(1, (Goal)new HuskBurrowGoal(husk));
            }
        }
        if (entity instanceof Pillager) {
            Pillager pillager = (Pillager)entity;
            if (BigBrainConfig.PillagerMultishot.booleanValue()) {
                pillager.f_21345_.m_25352_(2, new PressureEntityWithMultishotCrossbowGoal<Pillager>(pillager, 1.0, 3.0f));
            }
            if (BigBrainConfig.PillagerCover.booleanValue()) {
                pillager.f_21345_.m_25352_(1, (Goal)new RunWhileChargingGoal((PathfinderMob)pillager, 0.9));
            }
            pillager.f_21345_.m_25352_(3, (Goal)new ZoomInAtRandomGoal(pillager));
        }
        if (entity instanceof Enemy && BigBrainConfig.MobsAttackAllVillagers.booleanValue() && !BigBrainConfig.MobBlackList.contains(entity.m_20078_())) {
            Mob mob = (Mob)entity;
            mob.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(mob, AbstractVillager.class, true));
        }
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            if (BigBrainConfig.MobsAttackAllVillagers.booleanValue()) {
                villager.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)villager, Mob.class, 8.0f, 1.0, 0.5, avoidTarget -> !BigBrainConfig.MobBlackList.contains(avoidTarget.m_20078_()) && avoidTarget instanceof Enemy));
            }
        }
        if (entity instanceof PathfinderMob) {
            final PathfinderMob creature = (PathfinderMob)entity;
            if (((Boolean)BigBrainConfig.COMMON.jumpAi.get()).booleanValue() && !((List)BigBrainConfig.COMMON.jumpBlackList.get()).contains(creature.m_20078_()) && (creature instanceof Zombie || creature instanceof AbstractIllager || creature instanceof AbstractPiglin || creature instanceof AbstractSkeleton || creature instanceof Creeper || creature instanceof AbstractVillager || ((List)BigBrainConfig.COMMON.jumpWhiteList.get()).contains(creature.m_20078_()))) {
                creature.f_21345_.m_25352_(1, (Goal)new ParkourGoal((Mob)creature));
            }
            if (GoalUtils.m_26894_((Mob)creature) && creature.m_21573_().m_26575_().m_77360_() && BigBrainConfig.openFenceGate.booleanValue() && !BigBrainConfig.cantOpenFenceGates.contains(creature.m_20078_())) {
                if (creature instanceof Raider) {
                    creature.f_21345_.m_25352_(2, (Goal)new OpenFenceGateGoal((Mob)creature, false){

                        @Override
                        public boolean m_8036_() {
                            return ((Raider)creature).m_37886_() && super.m_8036_();
                        }
                    });
                } else {
                    creature.f_21345_.m_25352_(2, (Goal)new OpenFenceGateGoal((Mob)creature, true));
                }
            }
            if (BigBrainConfig.EntitiesThatCanAlsoUseTheBuckler.contains(entity.m_20078_())) {
                creature.f_21345_.m_25352_(0, new UseBucklerGoal<PathfinderMob>(creature));
            }
            if (((Boolean)BigBrainConfig.COMMON.bowAiNew.get()).booleanValue() && ((List)BigBrainConfig.COMMON.bowAiBlackList.get()).contains(entity.m_20078_()) && creature.f_21345_.f_25345_.stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof RangedBowAttackGoal)) {
                creature.f_21345_.f_25345_.removeIf(p_25367_ -> p_25367_.m_26015_() instanceof RangedBowAttackGoal);
                creature.f_21345_.m_25352_(3, new NewBowAttackGoal<PathfinderMob>(creature, 1.55, 20, 15.0f));
            }
        }
        if (entity instanceof PolarBear) {
            PolarBear polar = (PolarBear)entity;
            if (BigBrainConfig.PolarBearFish.booleanValue()) {
                polar.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)polar, AbstractFish.class, 10, true, true, null));
            }
        }
        if (BigBrainConfig.animalShelter.booleanValue() && entity instanceof Animal) {
            Animal animal = (Animal)entity;
            if (!BigBrainConfig.AnimalBlackList.contains(entity.m_20078_()) && !(entity instanceof FlyingAnimal)) {
                animal.f_21345_.m_25352_(7, (Goal)new RestrictSunAnimalGoal((PathfinderMob)animal));
                animal.f_21345_.m_25352_(8, (Goal)new FindShelterGoal((PathfinderMob)animal));
            }
        }
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            if (BigBrainConfig.sheepRunAway.booleanValue()) {
                sheep.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)sheep, Wolf.class, 8.0f, 1.0, 1.6));
            }
        }
        if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            if (BigBrainConfig.ocelotPhantom.booleanValue()) {
                ocelot.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Phantom.class, 10, true, true, (Predicate)null));
            }
            if (BigBrainConfig.ocelotCreeper.booleanValue()) {
                ocelot.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Creeper.class, 10, true, true, (Predicate)null));
            }
            if (BigBrainConfig.ocelotParrot.booleanValue()) {
                ocelot.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Parrot.class, 10, true, true, (Predicate)null));
            }
        }
        if (entity instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            if (BigBrainConfig.ocelotParrot.booleanValue()) {
                parrot.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)parrot, Ocelot.class, 8.0f, 1.0, 5.0));
            }
        }
    }

    @SubscribeEvent
    public static void onHit(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Animal) {
            Animal animal = (Animal)livingEntity;
            if (((Boolean)BigBrainConfig.COMMON.animalPanic.get()).booleanValue()) {
                for (Animal nearbyEntities : animal.m_9236_().m_45976_(animal.getClass(), animal.m_20191_().m_82400_(5.0))) {
                    if (!(event.getSource().m_7639_() instanceof LivingEntity) || event.getSource().m_181121_()) continue;
                    nearbyEntities.m_6703_((LivingEntity)event.getSource().m_7639_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        if (event.getEntity().m_21211_().m_41720_() instanceof BucklerItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Husk) {
            BurrowCapability burrow;
            Husk husk = (Husk)entity;
            if (!event.getTarget().f_19853_.f_46443_ && (burrow = BigBrainCapabilities.getBurrowing((LivingEntity)husk)) != null) {
                BigBrainNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> husk), (Object)new BurrowingCapabilityPacket(husk.m_19879_(), burrow.isBurrowing()));
            }
        }
    }

    @SubscribeEvent
    public static void onTargetSet(LivingChangeTargetEvent event) {
        Pillager pillager;
        Object object;
        LivingEntity livingEntity;
        if (event.getEntity() instanceof AbstractPiglin) {
            try {
                setTargetPiglin.invoke(PiglinAi.class, event.getEntity(), event.getOriginalTarget());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                new RuntimeException("Big Brain has failed to invoke maybeRetaliate");
            }
        }
        if ((livingEntity = event.getEntity()) instanceof Creeper) {
            Creeper creeper = (Creeper)livingEntity;
            livingEntity = event.getOriginalTarget();
            if (livingEntity instanceof Ocelot) {
                Ocelot ocelot = (Ocelot)livingEntity;
                if (event.getOriginalTarget() != null) {
                    creeper.m_6710_(null);
                }
            }
        }
        if ((object = event.getEntity()) instanceof Pillager && (pillager = (Pillager)object).m_21211_().m_41720_() instanceof SpyglassItem && pillager.m_33069_()) {
            pillager.m_21561_(true);
            if (pillager.m_21573_().m_26571_()) {
                pillager.m_21573_().m_5624_((Entity)event.getOriginalTarget(), 1.0);
            }
            for (Raider raider : pillager.f_19853_.m_45971_(Raider.class, TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_(), (LivingEntity)pillager, pillager.m_20191_().m_82377_(8.0, 8.0, 8.0))) {
                raider.m_21561_(true);
                if (raider.m_21211_().m_41720_() instanceof SpyglassItem || raider.m_33069_()) continue;
                raider.m_6710_(event.getOriginalTarget());
            }
        }
    }

    @SubscribeEvent
    public static void onToolTipLoad(ItemTooltipEvent event) {
        if (event.getItemStack().m_41720_() == Items.f_42452_) {
            event.getToolTip().add(Component.m_237115_((String)"item.bigbrain.snowball.desc.hit").m_130940_(ChatFormatting.GRAY));
            event.getToolTip().add(Component.m_237115_((String)"item.bigbrain.snowball.desc.freeze").m_130940_(ChatFormatting.BLUE));
        }
    }

    public static void bucklerBash(LivingEntity entity) {
        List list = entity.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), entity, entity.m_20191_().m_82400_(1.5));
        if (!list.isEmpty()) {
            LivingEntity entityHit = (LivingEntity)list.get(0);
            entityHit.m_7334_((Entity)entity);
            int bangLevel = BigBrainEnchantments.getBucklerEnchantsOnHands((Enchantment)BigBrainEnchantments.BANG.get(), entity);
            float damage = 6.0f + (float)entity.m_217043_().m_188503_(3);
            float knockbackStrength = 3.0f;
            for (int duration = 0; duration < 10; ++duration) {
                double d0 = entity.m_217043_().m_188583_() * 0.02;
                double d1 = entity.m_217043_().m_188583_() * 0.02;
                double d2 = entity.m_217043_().m_188583_() * 0.02;
                SimpleParticleType type = entityHit instanceof WitherBoss || entityHit instanceof WitherSkeleton ? ParticleTypes.f_123762_ : ParticleTypes.f_123796_;
                ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)type, entity.m_20208_(1.0), entity.m_20187_() + 1.0, entity.m_20262_(1.0), 1, d0, d1, d2, 1.0);
            }
            if (bangLevel == 0) {
                if (entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)entity), damage)) {
                    entityHit.m_147240_((double)knockbackStrength, (double)Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180)))));
                    entity.m_20256_(entity.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (!entity.m_20067_()) {
                    ((ServerLevel)entity.f_19853_).m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)BigBrainSounds.SHIELD_BASH.get(), entity.m_5720_(), 0.5f, 0.8f + entity.m_217043_().m_188501_() * 0.4f);
                }
                if (entityHit instanceof Player && ((Player)entityHit).m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
                    ((Player)entityHit).m_36384_(true);
                }
            } else {
                InteractionHand hand = entity.m_21205_().m_41720_() instanceof BucklerItem ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                ItemStack stack = entity.m_21120_(hand);
                stack.m_41622_(5 * bangLevel, entity, player1 -> {
                    player1.m_21190_(hand);
                    if (entity instanceof Player) {
                        ForgeEventFactory.onPlayerDestroyItem((Player)((Player)entity), (ItemStack)entity.m_21211_(), (InteractionHand)hand);
                    }
                });
                Explosion.BlockInteraction mode = BigBrainConfig.BangBlockDestruction != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
                entity.f_19853_.m_46511_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (float)bangLevel * 1.0f, mode);
                ((IBucklerUser)entity).setBucklerDashing(false);
            }
            entity.m_21335_((Entity)entityHit);
            if (entity instanceof IOneCriticalAfterCharge) {
                ((IOneCriticalAfterCharge)entity).setCritical(BigBrainEnchantments.getBucklerEnchantsOnHands((Enchantment)BigBrainEnchantments.BANG.get(), entity) == 0);
            }
        }
    }

    public static void spawnRunningEffectsWhileCharging(LivingEntity entity) {
        int k;
        int j;
        int i = Mth.m_14107_((double)entity.m_20185_());
        BlockPos blockpos = new BlockPos(i, j = Mth.m_14107_((double)(entity.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)entity.m_20189_()));
        BlockState blockstate = entity.f_19853_.m_8055_(blockpos);
        if (!blockstate.addRunningEffects(entity.f_19853_, blockpos, (Entity)entity) && blockstate.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 vec3 = entity.m_20184_();
            entity.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_6972_((Pose)entity.m_20089_()).f_20378_, entity.m_20186_() + 0.1, entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_6972_((Pose)entity.m_20089_()).f_20377_, vec3.f_82479_ * -4.0, 1.5, vec3.f_82481_ * -4.0);
        }
    }
}

