/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.common.entity.ai.goals;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class NewBowAttackGoal<T extends PathfinderMob>
extends Goal {
    private final double speedModifier;
    private final float attackRadiusSqr;
    private final T mob;
    private int attackIntervalMin;
    private Path path;
    private int attackTime = -1;
    private int seeTime;
    private int avoidTime;
    private int arrowsShot = 0;

    public NewBowAttackGoal(T pMob, double pSpeedModifier, int pAttackIntervalMin, float pAttackRadius) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.attackIntervalMin = pAttackIntervalMin;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        return target != null && this.mob.m_21093_(is -> is.m_41720_() instanceof BowItem) && this.mob.m_142582_((Entity)target);
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        super.m_8037_();
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            double distanceSquared = this.mob.m_20280_((Entity)target);
            boolean canSee = this.mob.m_21574_().m_148306_((Entity)target);
            boolean seeTimeGreaterThanZero = this.seeTime > 0;
            this.mob.m_21563_().m_148051_((Entity)target);
            this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
            if (this.mob.m_6117_()) {
                if (!canSee && this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (canSee) {
                    int timeToShoot;
                    int i = this.mob.m_21252_();
                    int n = timeToShoot = distanceSquared <= 40.0 && ((PathfinderMob)this.mob).f_19853_.m_46791_() == Difficulty.HARD ? Mth.m_14107_((double)Mth.m_14139_((double)(distanceSquared / (double)this.attackRadiusSqr), (double)5.0, (double)20.0)) : 20;
                    if (i >= timeToShoot) {
                        this.mob.m_5810_();
                        ((RangedAttackMob)this.mob).m_6504_(target, BowItem.m_40661_((int)i));
                        ++this.arrowsShot;
                        this.attackTime = this.attackIntervalMin;
                    }
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem));
            }
            if (distanceSquared > (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.path = this.mob.m_21573_().m_6570_((Entity)target, 0);
                this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            } else if (distanceSquared < (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
            }
            if (canSee != seeTimeGreaterThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (distanceSquared <= 6.0 || this.arrowsShot >= 3) {
                this.avoidTime = this.avoidTime <= 0 ? 60 : (this.avoidTime -= 10);
                this.arrowsShot = 0;
            }
            if (this.avoidTime <= 0) {
                this.mob.m_21573_().m_26573_();
            }
            if (this.avoidTime > 60) {
                this.avoidTime = 60;
            }
            if (--this.avoidTime > 0) {
                Vec3 vec3 = this.getPosition(this.mob);
                if (distanceSquared <= (double)this.attackRadiusSqr && vec3 != null && this.mob.m_21573_().m_26571_()) {
                    this.path = this.mob.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                    this.mob.m_21563_().m_24946_(vec3.f_82479_, this.mob.m_20188_(), vec3.f_82481_);
                    if (this.path != null && this.path.m_77403_()) {
                        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
                        this.attackTime = -1;
                        this.mob.m_5810_();
                    }
                }
            }
        }
    }

    public void m_8041_() {
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    @Nullable
    protected Vec3 getPosition(T mob) {
        if (mob.m_5448_() != null) {
            return LandRandomPos.m_148521_(mob, (int)5, (int)7, (Vec3)mob.m_5448_().m_20182_());
        }
        return LandRandomPos.m_148488_(mob, (int)5, (int)7);
    }
}

