/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.client.BigBrainSounds;
import tallestegg.bigbrain.common.capabilities.BigBrainCapabilities;
import tallestegg.bigbrain.common.capabilities.implementations.BurrowCapability;
import tallestegg.bigbrain.common.capabilities.implementations.IOneCriticalAfterCharge;
import tallestegg.bigbrain.common.capabilities.providers.BurrowingProvider;
import tallestegg.bigbrain.common.capabilities.providers.GuranteedCritProvider;
import tallestegg.bigbrain.common.enchantments.BigBrainEnchantments;
import tallestegg.bigbrain.common.entity.ai.goals.FindShelterGoal;
import tallestegg.bigbrain.common.entity.ai.goals.HuskBurrowGoal;
import tallestegg.bigbrain.common.entity.ai.goals.NewBowAttackGoal;
import tallestegg.bigbrain.common.entity.ai.goals.OpenFenceGateGoal;
import tallestegg.bigbrain.common.entity.ai.goals.ParkourGoal;
import tallestegg.bigbrain.common.entity.ai.goals.PressureEntityWithMultishotCrossbowGoal;
import tallestegg.bigbrain.common.entity.ai.goals.RestrictSunAnimalGoal;
import tallestegg.bigbrain.common.entity.ai.goals.RunWhileChargingGoal;
import tallestegg.bigbrain.common.entity.ai.goals.UseBucklerGoal;
import tallestegg.bigbrain.common.entity.ai.goals.ZoomInAtRandomGoal;
import tallestegg.bigbrain.common.items.BigBrainItems;
import tallestegg.bigbrain.common.items.BucklerItem;
import tallestegg.bigbrain.networking.BigBrainNetworking;
import tallestegg.bigbrain.networking.BurrowingCapabilityPacket;
import tallestegg.bigbrain.networking.CriticalCapabilityPacket;

@Mod.EventBusSubscriber(modid="bigbrain")
public class BigBrainEvents {
    private static final Method setTargetPiglin = ObfuscationReflectionHelper.findMethod(PiglinAi.class, (String)"m_34826_", (Class[])new Class[]{AbstractPiglin.class, LivingEntity.class});
    private static final UUID CHARGE_SPEED_UUID = UUID.fromString("A2F995E8-B25A-4883-B9D0-93A676DC4045");
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("93E74BB2-05A5-4AC0-8DF5-A55768208A95");
    private static final AttributeModifier CHARGE_SPEED_BOOST = new AttributeModifier(CHARGE_SPEED_UUID, "Charge speed boost", 9.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier KNOCKBACK_RESISTANCE = new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback reduction", 1.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public static void onBreed(BabyEntitySpawnEvent event) {
        if (event.getParentA().m_6095_() == EntityType.f_20510_ && event.getParentB().m_6095_() == EntityType.f_20510_) {
            Pig pig = (Pig)event.getParentA();
            Level level = pig.m_9236_();
            RandomSource randomSource = level.m_213780_();
            for (int i = 0; i < BigBrainConfig.minPigBabiesBred + randomSource.m_188503_(BigBrainConfig.maxPigBabiesBred + 1); ++i) {
                Pig baby = (Pig)EntityType.f_20510_.m_20615_(event.getChild().f_19853_);
                baby.m_20359_((Entity)pig);
                baby.m_21530_();
                if (level.m_46469_().m_46207_(GameRules.f_46135_)) {
                    level.m_7967_((Entity)new ExperienceOrb(level, pig.m_20185_(), pig.m_20186_(), pig.m_20189_(), pig.m_217043_().m_188503_(7) + 1));
                }
                baby.m_6863_(true);
                baby.m_21530_();
                pig.m_20193_().m_7967_((Entity)baby);
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (BucklerItem.getChargeTicks(BigBrainItems.checkEachHandForBuckler(event.getEntity())) > 0) {
            event.getEntity().m_20334_(event.getEntity().m_20184_().m_7096_(), 0.0, event.getEntity().m_20184_().m_7094_());
        }
    }

    @SubscribeEvent
    public static void modifiyVisibility(LivingEvent.LivingVisibilityEvent event) {
        Entity entity = event.getLookingEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21023_(MobEffects.f_19610_)) {
                event.modifyVisibility(BigBrainConfig.mobBlindnessVision.doubleValue());
            }
            if (living.m_21211_().m_41720_() instanceof SpyglassItem && living.m_21051_(Attributes.f_22277_) != null) {
                event.modifyVisibility(living.m_21133_(Attributes.f_22277_) * 2.0);
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        LivingEntity living;
        Entity entity;
        if (event.getProjectile() instanceof Snowball && BigBrainConfig.snowGolemSlow.booleanValue() && event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_142079_()) {
            living.m_146917_(living.m_146888_() + 100);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        Player player = event.getEntity();
        if (BigBrainConfig.snowGolemSlow.booleanValue() && item == Items.f_42452_) {
            player.m_21011_(event.getHand(), true);
            player.m_36335_().m_41524_(item, 4);
        }
    }

    @SubscribeEvent
    public static void entityHitbox(EntityEvent.Size event) {
        Husk husk;
        Entity entity = event.getEntity();
        if (entity instanceof Husk && (husk = (Husk)entity).m_217003_(Pose.SWIMMING)) {
            event.setNewSize(EntityDimensions.m_20395_((float)1.0f, (float)1.5f), true);
            event.setNewEyeHeight(0.5f);
        }
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Husk husk;
            Player player = (Player)entity;
            Entity entity2 = event.getEntityBeingMounted();
            if (entity2 instanceof Husk && (husk = (Husk)entity2).m_6084_() && BigBrainCapabilities.getBurrowing((LivingEntity)husk).isCarrying() && (!player.m_5833_() || !player.m_7500_()) && player.m_6084_() && event.isDismounting()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        IOneCriticalAfterCharge criticalAfterCharge;
        Dolphin dolphin;
        Husk husk;
        BurrowCapability burrow;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Husk && (burrow = BigBrainCapabilities.getBurrowing((LivingEntity)(husk = (Husk)entity))) != null) {
            if (!husk.f_19853_.f_46443_) {
                BigBrainNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> husk), (Object)new BurrowingCapabilityPacket(husk.m_19879_(), burrow.isBurrowing()));
            }
            if (burrow.isBurrowing()) {
                BucklerItem.spawnRunningEffectsWhileCharging(entity);
                if (entity.m_217043_().m_188503_(10) == 0) {
                    BlockState onState = husk.m_20075_();
                    husk.m_216990_(onState.getSoundType((LevelReader)husk.f_19853_, husk.m_20183_(), (Entity)husk).m_56775_());
                }
            }
        }
        if (entity instanceof Dolphin && (dolphin = (Dolphin)entity).m_146899_()) {
            dolphin.m_20301_(300);
        }
        int turningLevel = BigBrainEnchantments.getBucklerEnchantsOnHands((Enchantment)BigBrainEnchantments.TURNING.get(), entity);
        ItemStack bucklerItemStack = BigBrainItems.checkEachHandForBuckler(entity);
        boolean bucklerReadyToCharge = BucklerItem.isReady(bucklerItemStack);
        int bucklerChargeTicks = BucklerItem.getChargeTicks(bucklerItemStack);
        if (bucklerReadyToCharge) {
            BucklerItem.setChargeTicks(bucklerItemStack, bucklerChargeTicks - 1);
            if (bucklerChargeTicks > 0) {
                BucklerItem.moveFowards(entity);
                BucklerItem.spawnRunningEffectsWhileCharging(entity);
                if (turningLevel == 0 && !entity.f_19853_.m_5776_()) {
                    BucklerItem.bucklerBash(entity);
                }
            }
            if (bucklerChargeTicks <= 0) {
                AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
                AttributeInstance knockback = entity.m_21051_(Attributes.f_22278_);
                if (speed == null || knockback == null) {
                    return;
                }
                knockback.m_22130_(KNOCKBACK_RESISTANCE);
                speed.m_22130_(CHARGE_SPEED_BOOST);
                entity.m_5810_();
                BucklerItem.setChargeTicks(bucklerItemStack, 0);
                BucklerItem.setReady(bucklerItemStack, false);
            }
        }
        if ((criticalAfterCharge = BigBrainCapabilities.getGuaranteedCritical(entity)) != null) {
            LivingEntity livingEntity;
            if (criticalAfterCharge.isCritical()) {
                if (entity.f_20913_ > 0) {
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)BigBrainSounds.CRITICAL_DEACTIVATE.get(), entity.m_5720_(), 1.0f, 0.8f + entity.m_217043_().m_188501_() * 0.4f);
                    criticalAfterCharge.setCritical(false);
                }
                for (int i = 0; i < 2; ++i) {
                    entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
            }
            if ((livingEntity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                BigBrainNetworking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CriticalCapabilityPacket(player.m_19879_(), criticalAfterCharge.isCritical()));
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().toString().contains("minecraft:chests/bastion")) {
            ResourceLocation bucklerBastionLoot = new ResourceLocation("bigbrain", "chests/buckler_loot_table");
            event.getTable().addPool(LootPool.m_79043_().name("buckler_bastion_chests").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)bucklerBastionLoot)).m_79082_());
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        IOneCriticalAfterCharge criticalAfterCharge = BigBrainCapabilities.getGuaranteedCritical((LivingEntity)player);
        if (criticalAfterCharge.isCritical()) {
            event.setResult(Event.Result.ALLOW);
            event.setDamageModifier(1.5f);
            event.getEntity().f_19853_.m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), SoundEvents.f_12313_, event.getEntity().m_5720_(), 1.0f, 1.0f);
            criticalAfterCharge.setCritical(false);
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Husk) {
            BurrowCapability burrow;
            Husk husk = (Husk)entity;
            if (!event.getTarget().f_19853_.f_46443_ && (burrow = BigBrainCapabilities.getBurrowing((LivingEntity)husk)) != null) {
                BigBrainNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> husk), (Object)new BurrowingCapabilityPacket(husk.m_19879_(), burrow.isBurrowing()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Husk) {
            Husk husk = (Husk)entity;
            if (((Boolean)BigBrainConfig.COMMON.huskBurrowing.get()).booleanValue()) {
                husk.f_21345_.m_25352_(1, (Goal)new HuskBurrowGoal(husk));
            }
        }
        if (entity instanceof Pillager) {
            Pillager pillager = (Pillager)entity;
            if (BigBrainConfig.PillagerMultishot.booleanValue()) {
                pillager.f_21345_.m_25352_(2, new PressureEntityWithMultishotCrossbowGoal<Pillager>(pillager, 1.0, 3.0f));
            }
            if (BigBrainConfig.PillagerCover.booleanValue()) {
                pillager.f_21345_.m_25352_(1, (Goal)new RunWhileChargingGoal((PathfinderMob)pillager, 0.9));
            }
            pillager.f_21345_.m_25352_(3, (Goal)new ZoomInAtRandomGoal(pillager));
        }
        if (entity instanceof Enemy && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (BigBrainConfig.MobsAttackAllVillagers.booleanValue() && !BigBrainConfig.MobBlackList.contains(entity.m_20078_())) {
                mob.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(mob, AbstractVillager.class, true));
            }
        }
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            if (BigBrainConfig.MobsAttackAllVillagers.booleanValue()) {
                villager.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)villager, Mob.class, 8.0f, 1.0, 0.5, avoidTarget -> !BigBrainConfig.MobBlackList.contains(avoidTarget.m_20078_()) && avoidTarget instanceof Enemy));
            }
        }
        if (entity instanceof PathfinderMob) {
            final PathfinderMob creature = (PathfinderMob)entity;
            if (((Boolean)BigBrainConfig.COMMON.jumpAi.get()).booleanValue() && !((List)BigBrainConfig.COMMON.jumpBlackList.get()).contains(creature.m_20078_()) && (creature instanceof Zombie || creature instanceof AbstractIllager || creature instanceof AbstractPiglin || creature instanceof AbstractSkeleton || creature instanceof Creeper || creature instanceof AbstractVillager || ((List)BigBrainConfig.COMMON.jumpWhiteList.get()).contains(creature.m_20078_()))) {
                creature.f_21345_.m_25352_(1, (Goal)new ParkourGoal((Mob)creature));
            }
            if (GoalUtils.m_26894_((Mob)creature) && creature.m_21573_().m_26575_().m_77360_() && BigBrainConfig.openFenceGate.booleanValue() && !BigBrainConfig.cantOpenFenceGates.contains(creature.m_20078_())) {
                if (creature instanceof Raider) {
                    creature.f_21345_.m_25352_(2, (Goal)new OpenFenceGateGoal((Mob)creature, false){

                        @Override
                        public boolean m_8036_() {
                            return ((Raider)creature).m_37886_() && super.m_8036_();
                        }
                    });
                } else {
                    creature.f_21345_.m_25352_(2, (Goal)new OpenFenceGateGoal((Mob)creature, true));
                }
            }
            if (BigBrainConfig.EntitiesThatCanAlsoUseTheBuckler.contains(entity.m_20078_())) {
                creature.f_21345_.m_25352_(0, new UseBucklerGoal<PathfinderMob>(creature));
            }
            if (((Boolean)BigBrainConfig.COMMON.bowAiNew.get()).booleanValue() && !((List)BigBrainConfig.COMMON.bowAiBlackList.get()).contains(entity.m_20078_()) && creature.f_21345_.f_25345_.stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof RangedBowAttackGoal)) {
                creature.f_21345_.f_25345_.removeIf(p_25367_ -> p_25367_.m_26015_() instanceof RangedBowAttackGoal);
                creature.f_21345_.m_25352_(3, new NewBowAttackGoal<PathfinderMob>(creature, 1.55, 20, 15.0f));
            }
            if (entity instanceof PolarBear) {
                PolarBear polar = (PolarBear)entity;
                if (BigBrainConfig.PolarBearFish.booleanValue()) {
                    polar.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)polar, AbstractFish.class, 10, true, true, (Predicate)null));
                }
            }
            if (BigBrainConfig.animalShelter.booleanValue() && entity instanceof Animal) {
                Animal animal = (Animal)entity;
                if (!BigBrainConfig.AnimalBlackList.contains(entity.m_20078_()) && !(entity instanceof FlyingAnimal)) {
                    animal.f_21345_.m_25352_(7, (Goal)new RestrictSunAnimalGoal((PathfinderMob)animal));
                    animal.f_21345_.m_25352_(8, (Goal)new FindShelterGoal((PathfinderMob)animal));
                }
            }
            if (entity instanceof Sheep) {
                Sheep sheep = (Sheep)entity;
                if (BigBrainConfig.sheepRunAway.booleanValue()) {
                    sheep.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)sheep, Wolf.class, 8.0f, 1.0, 1.6));
                }
            }
            if (entity instanceof Ocelot) {
                Ocelot ocelot = (Ocelot)entity;
                if (BigBrainConfig.ocelotPhantom.booleanValue()) {
                    ocelot.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Phantom.class, 10, true, true, (Predicate)null));
                }
                if (BigBrainConfig.ocelotCreeper.booleanValue()) {
                    ocelot.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Creeper.class, 10, true, true, (Predicate)null));
                }
                if (BigBrainConfig.ocelotParrot.booleanValue()) {
                    ocelot.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Parrot.class, 10, true, true, (Predicate)null));
                }
            }
            if (entity instanceof Parrot) {
                Parrot parrot = (Parrot)entity;
                if (BigBrainConfig.ocelotParrot.booleanValue()) {
                    parrot.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)parrot, Ocelot.class, 8.0f, 1.0, 5.0));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHit(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Animal) {
            Animal animal = (Animal)livingEntity;
            if (((Boolean)BigBrainConfig.COMMON.animalPanic.get()).booleanValue()) {
                for (Animal nearbyEntities : animal.m_9236_().m_45976_(animal.getClass(), animal.m_20191_().m_82400_(5.0))) {
                    if (!(event.getSource().m_7639_() instanceof LivingEntity) || event.getSource().m_276093_(DamageTypes.f_268511_)) continue;
                    nearbyEntities.m_6703_((LivingEntity)event.getSource().m_7639_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (event.getEntity() instanceof Husk && event.getSource().m_276093_(DamageTypes.f_268612_) && BigBrainCapabilities.getBurrowing(event.getEntity()).isCarrying()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        GuranteedCritProvider critProvider = new GuranteedCritProvider();
        BurrowingProvider burrowingProvider = new BurrowingProvider();
        if (event.getObject() instanceof Player) {
            event.addCapability(GuranteedCritProvider.IDENTIFIER, (ICapabilityProvider)critProvider);
        }
        if (event.getObject() instanceof Husk) {
            event.addCapability(BurrowingProvider.IDENTIFIER, (ICapabilityProvider)burrowingProvider);
            event.addListener(burrowingProvider::invalidate);
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        if (event.getEntity().m_21211_().m_41720_() instanceof BucklerItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTargetSet(LivingChangeTargetEvent event) {
        Pillager pillager;
        Object object;
        if (event.getEntity() instanceof AbstractPiglin) {
            try {
                setTargetPiglin.invoke(PiglinAi.class, event.getEntity(), event.getOriginalTarget());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                new RuntimeException("Big Brain has failed to invoke maybeRetaliate");
            }
        }
        if ((object = event.getEntity()) instanceof Creeper) {
            Creeper creeper = (Creeper)object;
            if (event.getOriginalTarget() instanceof Ocelot && event.getOriginalTarget() != null) {
                creeper.m_6710_(null);
            }
        }
        if ((object = event.getEntity()) instanceof Pillager && (pillager = (Pillager)object).m_21211_().m_41720_() instanceof SpyglassItem && pillager.m_33069_()) {
            pillager.m_21561_(true);
            if (pillager.m_21573_().m_26571_()) {
                pillager.m_21573_().m_5624_((Entity)event.getOriginalTarget(), 1.0);
            }
            for (Raider raider : pillager.f_19853_.m_45971_(Raider.class, TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_(), (LivingEntity)pillager, pillager.m_20191_().m_82377_(8.0, 8.0, 8.0))) {
                raider.m_21561_(true);
                if (raider.m_21211_().m_41720_() instanceof SpyglassItem || raider.m_33069_()) continue;
                raider.m_6710_(event.getOriginalTarget());
            }
        }
    }

    @SubscribeEvent
    public static void onToolTipLoad(ItemTooltipEvent event) {
        if (event.getItemStack().m_41720_() == Items.f_42452_) {
            event.getToolTip().add(Component.m_237115_((String)"item.bigbrain.snowball.desc.hit").m_130940_(ChatFormatting.GRAY));
            event.getToolTip().add(Component.m_237115_((String)"item.bigbrain.snowball.desc.freeze").m_130940_(ChatFormatting.BLUE));
        }
    }

    @SubscribeEvent
    public static void finalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob chance2;
        MobSpawnType spawnType = event.getSpawnType();
        RandomSource rSource = event.getLevel().m_213780_();
        Mob mob = event.getEntity();
        if (mob instanceof Pillager) {
            Pillager pillager = (Pillager)mob;
            if (spawnType == MobSpawnType.PATROL) {
                float chance2 = BigBrainConfig.spyGlassPillagerChance;
                if (pillager.m_33067_() && rSource.m_188501_() < chance2) {
                    pillager.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_151059_));
                }
            }
        }
        if ((chance2 = event.getEntity()) instanceof PiglinBrute) {
            PiglinBrute piglinBrute = (PiglinBrute)chance2;
            if (!BigBrainConfig.BruteSpawningWithBuckler.booleanValue()) {
                return;
            }
            piglinBrute.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)BigBrainItems.BUCKLER.get()));
            ItemStack itemstack = piglinBrute.m_21206_();
            if (itemstack.m_41720_() instanceof BucklerItem) {
                Map map;
                if (rSource.m_188503_(300) == 0) {
                    map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
                    map.putIfAbsent((Enchantment)BigBrainEnchantments.TURNING.get(), 1);
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
                    piglinBrute.m_8061_(EquipmentSlot.OFFHAND, itemstack);
                }
                if (rSource.m_188503_(500) == 0) {
                    map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
                    map.putIfAbsent((Enchantment)BigBrainEnchantments.BANG.get(), 1);
                    EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
                    piglinBrute.m_8061_(EquipmentSlot.OFFHAND, itemstack);
                }
            }
        }
    }

    @SubscribeEvent
    public static void dropLoot(LivingDropsEvent event) {
        PiglinBrute brute;
        ItemStack itemstack;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof PiglinBrute && (itemstack = (brute = (PiglinBrute)livingEntity).m_21206_()).m_41720_() instanceof BucklerItem) {
            boolean flag;
            float f = 0.1f;
            boolean bl = flag = f > 1.0f;
            if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack) && (event.isRecentlyHit() || flag) && Math.max(brute.m_217043_().m_188501_() - (float)event.getLootingLevel() * 0.01f, 0.0f) < f) {
                if (itemstack.m_41763_()) {
                    itemstack.m_41721_(brute.m_217043_().m_188503_(brute.m_217043_().m_188503_(itemstack.m_41776_() / 2)));
                }
                brute.m_19983_(itemstack);
                brute.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
        }
    }
}

