/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.common.capabilities.BigBrainCapabilities;
import tallestegg.bigbrain.common.items.BigBrainItems;
import tallestegg.bigbrain.common.items.BucklerItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="bigbrain")
public class BigBrainClientEvents {
    public static final Method preRenderCallback = ObfuscationReflectionHelper.findMethod(LivingEntityRenderer.class, (String)"m_7546_", (Class[])new Class[]{LivingEntity.class, PoseStack.class, Float.TYPE});

    @SubscribeEvent
    public static void onMovementKeyPressed(MovementInputUpdateEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (BucklerItem.getChargeTicks(BigBrainItems.checkEachHandForBuckler((LivingEntity)player)) > 0) {
            event.getInput().f_108572_ = false;
            event.getInput().f_108566_ = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        PoseStack mStack = event.getPoseStack();
        ItemStack stack = event.getItemStack();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        float partialTicks = event.getPartialTick();
        if (stack.m_41720_() instanceof BucklerItem && (player.m_6117_() && player.m_21211_() == stack || BucklerItem.getChargeTicks(stack) > 0 && BucklerItem.isReady(stack))) {
            boolean mainHand = event.getHand() == InteractionHand.MAIN_HAND;
            HumanoidArm handside = mainHand ? player.m_5737_() : player.m_5737_().m_20828_();
            boolean rightHanded = handside == HumanoidArm.RIGHT;
            float f7 = (float)stack.m_41779_() - ((float)player.m_21212_() - partialTicks + 1.0f);
            float f11 = f7 / 10.0f;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            mStack.m_85836_();
            int i = rightHanded ? 1 : -1;
            mStack.m_252880_((float)i * 0.56f, -0.52f + event.getEquipProgress() * -0.6f, -0.72f);
            mStack.m_85837_((double)f11 * (!rightHanded ? 0.2 : -0.2), 0.0, (double)f11 * (!rightHanded ? 0.2 : -0.2));
            ItemDisplayContext transform = rightHanded ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            Minecraft.m_91087_().f_91063_.f_109055_.m_269530_((LivingEntity)player, stack, transform, !rightHanded, mStack, event.getMultiBufferSource(), event.getPackedLight());
            mStack.m_85849_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityRenderPost(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        Husk husk;
        LivingEntity livingEntity;
        LivingEntity entityIn = event.getEntity();
        LivingEntityRenderer renderer = event.getRenderer();
        EntityModel model = renderer.m_7200_();
        PoseStack stack = event.getPoseStack();
        if (BucklerItem.getChargeTicks(BigBrainItems.checkEachHandForBuckler(entityIn)) > 0) {
            if (!BigBrainConfig.RenderAfterImage.booleanValue()) {
                return;
            }
            for (int i = 0; i < 5; ++i) {
                Direction direction;
                Entity entity;
                boolean shouldSit;
                if (i == 0) continue;
                stack.m_85836_();
                model.f_102608_ = entityIn.m_21324_(event.getPartialTick());
                model.f_102609_ = shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
                model.f_102610_ = entityIn.m_6162_();
                float f = Mth.m_14189_((float)event.getPartialTick(), (float)entityIn.f_20884_, (float)entityIn.f_20883_);
                float f1 = Mth.m_14189_((float)event.getPartialTick(), (float)entityIn.f_20886_, (float)entityIn.f_20885_);
                float f2 = f1 - f;
                if (shouldSit && (entity = entityIn.m_20202_()) instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    f = Mth.m_14189_((float)event.getPartialTick(), (float)livingentity.f_20884_, (float)livingentity.f_20883_);
                    f2 = f1 - f;
                    float f3 = Mth.m_14177_((float)f2);
                    if (f3 < -85.0f) {
                        f3 = -85.0f;
                    }
                    if (f3 >= 85.0f) {
                        f3 = 85.0f;
                        f = f1 - f3;
                    } else {
                        f = f1 - f3;
                    }
                    if (f3 * f3 > 2500.0f) {
                        f += f3 * 0.2f;
                    }
                    f2 = f1 - f;
                }
                float f6 = Mth.m_14179_((float)event.getPartialTick(), (float)entityIn.f_19860_, (float)entityIn.m_146909_());
                if (entityIn.m_20089_() == Pose.SLEEPING && (direction = entityIn.m_21259_()) != null) {
                    float f4 = entityIn.m_20236_(Pose.STANDING) - 0.1f;
                    stack.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
                }
                float f7 = (float)entityIn.f_19797_ + event.getPartialTick();
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
                try {
                    preRenderCallback.invoke((Object)renderer, entityIn, stack, Float.valueOf(event.getPartialTick()));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    new RuntimeException("Big Brain has failed to invoke preRenderCallback via reflection.");
                }
                stack.m_85841_(-1.0f, -1.0f, 1.0f);
                double motionZ = Math.abs(entityIn.m_20184_().m_7094_());
                stack.m_85837_(0.0, (double)-1.501f, (double)i * motionZ * 4.0 / (double)BucklerItem.getChargeTicks(BigBrainItems.checkEachHandForBuckler(entityIn)));
                float f8 = 0.0f;
                float f5 = 0.0f;
                if (!shouldSit && entityIn.m_6084_()) {
                    f8 = entityIn.f_267362_.m_267711_(event.getPartialTick());
                    f5 = entityIn.f_267362_.m_267590_(event.getPartialTick());
                    if (entityIn.m_6162_()) {
                        f5 *= 3.0f;
                    }
                    if (f8 > 1.0f) {
                        f8 = 1.0f;
                    }
                }
                model.m_6839_((Entity)entityIn, f5, f8, event.getPartialTick());
                model.m_6973_((Entity)entityIn, f5, f8, f7, f2, f6);
                Minecraft minecraft = Minecraft.m_91087_();
                boolean flag = !entityIn.m_20145_();
                boolean flag1 = !flag && !entityIn.m_20177_((Player)minecraft.f_91074_);
                boolean flag2 = minecraft.m_91314_((Entity)entityIn);
                RenderType rendertype = BigBrainClientEvents.getRenderType(entityIn, renderer, model, flag, flag1, flag2);
                if (rendertype != null) {
                    VertexConsumer ivertexbuilder = event.getMultiBufferSource().m_6299_(rendertype);
                    int overlay = LivingEntityRenderer.m_115338_((LivingEntity)entityIn, (float)0.0f);
                    model.m_7695_(stack, ivertexbuilder, event.getPackedLight(), overlay, 1.0f, 1.0f, 1.0f, 0.3f / (float)i + 1.0f);
                }
                if (!entityIn.m_5833_() && BigBrainConfig.RenderEntityLayersDuringAfterImage.booleanValue()) {
                    for (RenderLayer layerrenderer : renderer.f_115291_) {
                        layerrenderer.m_6494_(stack, event.getMultiBufferSource(), event.getPackedLight(), (Entity)entityIn, f5, f8, event.getPartialTick(), f7, f2, f6);
                    }
                }
                stack.m_85849_();
            }
        }
        if ((livingEntity = event.getEntity()) instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)livingEntity;
            livingEntity = event.getRenderer().m_7200_();
            if (livingEntity instanceof SkeletonModel) {
                SkeletonModel skeleModel = (SkeletonModel)livingEntity;
                if ((skeleModel.f_102816_ == HumanoidModel.ArmPose.BOW_AND_ARROW || skeleModel.f_102815_ == HumanoidModel.ArmPose.BOW_AND_ARROW) && skeleton.m_20184_().m_7098_() > 0.0 && skeleton.m_20184_().m_7096_() > 0.0 && skeleton.m_20184_().m_7094_() > 0.0) {
                    skeleModel.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                    skeleModel.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                }
            }
        }
        if (entityIn instanceof Husk && (husk = (Husk)entityIn).m_20998_(event.getPartialTick()) > 0.0f && !event.isCanceled()) {
            event.getPoseStack().m_85849_();
        }
    }

    @SubscribeEvent
    public static void onEntityRenderPre(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entityIn = event.getEntity();
        if (entityIn instanceof Husk) {
            Husk husk = (Husk)entityIn;
            if (BigBrainCapabilities.getBurrowing(entityIn) != null && BigBrainCapabilities.getBurrowing(entityIn).isBurrowing()) {
                event.setCanceled(false);
            }
            if (husk.m_20998_(event.getPartialTick()) > 0.0f) {
                event.getPoseStack().m_85836_();
                float f = Mth.m_14189_((float)event.getPartialTick(), (float)husk.f_20884_, (float)husk.f_20883_);
                float f3 = -90.0f - husk.m_146909_();
                float f4 = Mth.m_14179_((float)husk.m_20998_(event.getPartialTick()), (float)0.0f, (float)f3);
                event.getPoseStack().m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
                event.getPoseStack().m_252781_(Axis.f_252403_.m_252977_(180.0f - f));
                event.getPoseStack().m_252781_(Axis.f_252529_.m_252977_(f4));
                if (husk.m_6067_()) {
                    event.getPoseStack().m_252880_(0.0f, -1.0f, 0.3f);
                }
            }
        }
    }

    public static RenderType getRenderType(LivingEntity p_230496_1_, LivingEntityRenderer<LivingEntity, ?> renderer, EntityModel<?> model, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = renderer.m_5478_((Entity)p_230496_1_);
        if (p_230496_3_) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (p_230496_2_) {
            return RenderType.m_110473_((ResourceLocation)resourcelocation);
        }
        return p_230496_4_ ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }
}

