/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.common.entity.ai.goals;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class ParkourGoal
extends Goal {
    private static final List<Integer> ALLOWED_ANGLES = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});
    protected final float maxJumpVelocity;
    private final Mob mob;
    private final BiPredicate<Mob, BlockPos> acceptableLandingSpot = ParkourGoal::defaultAcceptableLandingSpot;
    public JumpPhases phase;
    protected Optional<Vec3> initialPosition = Optional.empty();
    @Nullable
    protected Vec3 chosenJump;
    protected BlockPos posToJump;
    protected int findJumpTries;
    protected int failedToFindJumpCounter;
    protected long tryAgainTime;
    private int lookTime;

    public ParkourGoal(Mob mob) {
        this.mob = mob;
        this.maxJumpVelocity = 1.5f;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public static <E extends Mob> boolean defaultAcceptableLandingSpot(E mob, BlockPos pos) {
        Level level = mob.f_19853_;
        BlockPos blockpos = pos.m_7495_();
        return level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos);
    }

    public boolean m_8036_() {
        if (this.mob.m_21573_() != null && this.mob.m_20096_()) {
            Path path = this.mob.m_21573_().m_26570_();
            return this.mob.m_21573_().m_26572_() && path != null && !path.m_77403_() && this.mob.f_19853_.m_46467_() - this.tryAgainTime > 100L;
        }
        return false;
    }

    public boolean m_8045_() {
        boolean flag = this.initialPosition.isPresent() && this.initialPosition.get().equals((Object)this.mob.m_20182_()) && this.findJumpTries > 0 && !this.mob.m_20072_() && this.chosenJump != null && this.failedToFindJumpCounter >= 2 || this.phase != JumpPhases.END;
        return flag;
    }

    public void m_8056_() {
        this.chosenJump = null;
        this.findJumpTries = 20;
        this.initialPosition = Optional.of(this.mob.m_20182_());
        if (this.mob.m_21573_() == null) {
            return;
        }
        Vec3 pos = Vec3.m_82512_((Vec3i)this.mob.m_21573_().m_26567_());
        this.mob.m_21563_().m_24950_(pos.f_82479_, this.mob.m_20188_(), pos.f_82481_, 90.0f, 90.0f);
        this.mob.m_146922_(this.mob.m_6080_());
        this.pickCandidate(this.mob, this.mob.m_21573_().m_26567_());
        this.phase = JumpPhases.LOOK_AT_BLOCK;
        if (this.lookTime == 0) {
            this.lookTime = 5;
        }
    }

    public void m_8037_() {
        if (this.phase == JumpPhases.LOOK_AT_BLOCK && this.lookTime > 0) {
            --this.lookTime;
            if (this.posToJump != null) {
                Vec3 pos = Vec3.m_82512_((Vec3i)this.posToJump);
                this.lookAt(pos, 30.0f, 30.0f);
                this.mob.m_5618_(this.mob.f_20885_);
            }
            if (this.lookTime <= 0) {
                this.phase = JumpPhases.JUMP;
            }
        } else if (this.chosenJump != null && this.phase == JumpPhases.JUMP) {
            this.leapTowards((LivingEntity)this.mob, this.mob.m_20182_().m_82549_(this.chosenJump), this.chosenJump.m_82553_(), 0.0);
            this.mob.m_21569_().m_24901_();
            this.phase = JumpPhases.END;
        } else {
            --this.findJumpTries;
        }
    }

    public void lookAt(Vec3 vec3, float pMaxYRotIncrease, float pMaxXRotIncrease) {
        double d0 = vec3.m_7096_() - this.mob.m_20185_();
        double d2 = vec3.m_7094_() - this.mob.m_20189_();
        double d1 = vec3.m_7098_() - this.mob.m_20188_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        this.mob.m_146926_(this.rotlerp(this.mob.m_146909_(), f1, pMaxXRotIncrease));
        this.mob.m_146922_(this.rotlerp(this.mob.m_146908_(), f, pMaxYRotIncrease));
    }

    private float rotlerp(float pAngle, float pTargetAngle, float pMaxIncrease) {
        float f = Mth.m_14177_((float)(pTargetAngle - pAngle));
        if (f > pMaxIncrease) {
            f = pMaxIncrease;
        }
        if (f < -pMaxIncrease) {
            f = -pMaxIncrease;
        }
        return pAngle + f;
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        if (this.failedToFindJumpCounter >= 2) {
            this.tryAgainTime = this.mob.f_19853_.m_46467_();
            this.failedToFindJumpCounter = 0;
        }
    }

    protected void pickCandidate(Mob pEntity, BlockPos block) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pEntity.m_20183_(), (BlockPos)block)) {
            BlockPos jumpPos = pEntity.m_20183_().m_123314_((Vec3i)pos, 3.0) ? pos : block;
            if (!this.isAcceptableLandingPosition(pEntity, jumpPos)) continue;
            Vec3 vec3 = Vec3.m_82512_((Vec3i)jumpPos);
            Vec3 vec31 = this.calculateOptimalJumpVector(pEntity, vec3);
            PathNavigation pathnavigation = pEntity.m_21573_();
            Path path = pathnavigation.m_148218_(jumpPos, 0, 8);
            if (path != null && !path.m_77403_()) {
                if (vec31 == null) continue;
                this.lookAt(vec3, 30.0f, 30.0f);
                this.mob.m_5618_(this.mob.f_20885_);
                this.posToJump = jumpPos;
                this.chosenJump = vec31;
                continue;
            }
            ++this.failedToFindJumpCounter;
        }
    }

    private boolean isAcceptableLandingPosition(Mob pEntity, BlockPos pPos) {
        BlockPos blockpos = pEntity.m_20183_();
        int i = blockpos.m_123341_();
        int j = blockpos.m_123343_();
        return i == pPos.m_123341_() && j == pPos.m_123343_() ? false : this.acceptableLandingSpot.test(pEntity, pPos);
    }

    @Nullable
    protected Vec3 calculateOptimalJumpVector(Mob pMob, Vec3 pTarget) {
        ArrayList list = Lists.newArrayList(ALLOWED_ANGLES);
        Collections.shuffle(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Vec3 vec3 = this.calculateJumpVectorForAngle(pMob, pTarget, i);
            if (vec3 == null) continue;
            return vec3;
        }
        return null;
    }

    @Nullable
    private Vec3 calculateJumpVectorForAngle(Mob pMob, Vec3 pTarget, int pAngle) {
        Vec3 vec3 = pMob.m_20182_();
        Vec3 vec31 = new Vec3(pTarget.f_82479_ - vec3.f_82479_, 0.0, pTarget.f_82481_ - vec3.f_82481_).m_82541_().m_82490_(0.5);
        pTarget = pTarget.m_82546_(vec31);
        Vec3 vec32 = pTarget.m_82546_(vec3);
        float f = (float)pAngle * (float)Math.PI / 180.0f;
        double d0 = Math.atan2(vec32.f_82481_, vec32.f_82479_);
        double d1 = vec32.m_82492_(0.0, vec32.f_82480_, 0.0).m_82556_();
        double d2 = Math.sqrt(d1);
        double d3 = vec32.f_82480_;
        double d4 = Math.sin(2.0f * f);
        double d5 = 0.08;
        double d6 = Math.pow(Math.cos(f), 2.0);
        double d7 = Math.sin(f);
        double d8 = Math.cos(f);
        double d9 = Math.sin(d0);
        double d10 = Math.cos(d0);
        double d11 = d1 * 0.08 / (d2 * d4 - 2.0 * d3 * d6);
        if (d11 < 0.0) {
            return null;
        }
        double d12 = Math.sqrt(d11);
        if (d12 > (double)this.maxJumpVelocity) {
            return null;
        }
        double d13 = d12 * d8;
        double d14 = d12 * d7;
        return new Vec3(d13 * d10, d14, d13 * d9).m_82490_((double)0.95f);
    }

    private void leapTowards(LivingEntity entity, Vec3 target, double horzVel, double yVel) {
        Vec3 dir = target.m_82546_(entity.m_20182_()).m_82541_();
        Vec3 leap = new Vec3(dir.f_82479_, 0.0, dir.f_82481_).m_82541_().m_82490_(horzVel).m_82524_((float)yVel);
        float clampedYVelocity = (float)(entity.m_20184_().m_7098_() < 0.1 ? leap.f_82480_ : 0.0);
        Vec3 horzVelocity = entity.m_20184_().m_82520_(leap.f_82479_, 0.0, leap.f_82481_);
        double scale = horzVel / horzVelocity.m_82553_();
        if (scale < 1.0) {
            horzVelocity = horzVelocity.m_82490_(scale);
        }
        ((Mob)entity).m_21563_().m_24964_(target);
        entity.m_20256_(horzVelocity.m_82524_(clampedYVelocity));
    }

    public static enum JumpPhases {
        LOOK_AT_BLOCK,
        JUMP,
        END;

    }
}

