/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.networking;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import tallestegg.bigbrain.common.capabilities.BigBrainCapabilities;
import tallestegg.bigbrain.common.capabilities.implementations.BurrowCapability;
import tallestegg.bigbrain.common.capabilities.implementations.IOneCriticalAfterCharge;
import tallestegg.bigbrain.networking.BurrowingCapabilityPacket;
import tallestegg.bigbrain.networking.CriticalCapabilityPacket;

public class BigBrainNetworking {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("bigbrain", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void syncCritical(CriticalCapabilityPacket msg) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(msg.getEntityId());
        if (entity != null && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            IOneCriticalAfterCharge criticalAfterCharge = BigBrainCapabilities.getGuaranteedCritical(living);
            criticalAfterCharge.setCritical(msg.getCrit());
        }
    }

    public static void syncBurrow(BurrowingCapabilityPacket msg) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(msg.getEntityId());
        if (entity != null && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            BurrowCapability burrow = BigBrainCapabilities.getBurrowing(living);
            burrow.setBurrowing(msg.getBurrow());
        }
    }

    public static void registerPackets() {
        int id = 0;
        INSTANCE.registerMessage(id++, CriticalCapabilityPacket.class, CriticalCapabilityPacket::encode, CriticalCapabilityPacket::decode, CriticalCapabilityPacket::handle);
        INSTANCE.registerMessage(id++, BurrowingCapabilityPacket.class, BurrowingCapabilityPacket::encode, BurrowingCapabilityPacket::decode, BurrowingCapabilityPacket::handle);
    }
}

