/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="bigbrain")
public class BigBrainClientEvents {
    public static final Method preRenderCallback = ObfuscationReflectionHelper.findMethod(LivingRenderer.class, (String)"func_225620_a_", (Class[])new Class[]{LivingEntity.class, MatrixStack.class, Float.TYPE});

    @SubscribeEvent
    public static void onMovementKeyPressed(InputUpdateEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (((IBucklerUser)player).isBucklerDashing()) {
            event.getMovementInput().field_78901_c = false;
            event.getMovementInput().field_78902_a = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        MatrixStack mStack = event.getMatrixStack();
        ItemStack stack = event.getItemStack();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = event.getPartialTicks();
        if (stack.func_77973_b() instanceof BucklerItem && (player.func_184587_cr() && player.func_184607_cu() == stack || ((IBucklerUser)player).isBucklerDashing())) {
            boolean mainHand = event.getHand() == Hand.MAIN_HAND;
            HandSide handside = mainHand ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
            boolean rightHanded = handside == HandSide.RIGHT;
            float f7 = (float)stack.func_77988_m() - ((float)player.func_184605_cv() - partialTicks + 1.0f);
            float f11 = f7 / 10.0f;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            mStack.func_227860_a_();
            int i = rightHanded ? 1 : -1;
            mStack.func_227861_a_((double)((float)i * 0.56f), (double)(-0.52f + event.getEquipProgress() * -0.6f), (double)-0.72f);
            mStack.func_227861_a_((double)f11 * 0.2, 0.0, (double)f11 * 0.2);
            ItemCameraTransforms.TransformType transform = !rightHanded ? ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)player, stack, transform, !rightHanded, mStack, event.getBuffers(), event.getLight());
            mStack.func_227865_b_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityRenderPre(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entityIn = event.getEntity();
        LivingRenderer renderer = event.getRenderer();
        EntityModel model = renderer.func_217764_d();
        MatrixStack stack = event.getMatrixStack();
        if (!BigBrainConfig.RenderAfterImage.booleanValue()) {
            return;
        }
        if (((IBucklerUser)entityIn).isBucklerDashing()) {
            for (int i = 0; i < 5; ++i) {
                Direction direction;
                boolean shouldSit;
                if (i == 0) continue;
                stack.func_227860_a_();
                model.field_217112_c = entityIn.func_70678_g(event.getPartialRenderTick());
                model.field_217113_d = shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
                model.field_217114_e = entityIn.func_70631_g_();
                float f = MathHelper.func_219805_h((float)event.getPartialRenderTick(), (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
                float f1 = MathHelper.func_219805_h((float)event.getPartialRenderTick(), (float)entityIn.field_70758_at, (float)entityIn.field_70759_as);
                float f2 = f1 - f;
                if (shouldSit && entityIn.func_184187_bx() instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entityIn.func_184187_bx();
                    f = MathHelper.func_219805_h((float)event.getPartialRenderTick(), (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
                    f2 = f1 - f;
                    float f3 = MathHelper.func_76142_g((float)f2);
                    if (f3 < -85.0f) {
                        f3 = -85.0f;
                    }
                    if (f3 >= 85.0f) {
                        f3 = 85.0f;
                    }
                    f = f1 - f3;
                    if (f3 * f3 > 2500.0f) {
                        f += f3 * 0.2f;
                    }
                    f2 = f1 - f;
                }
                float f6 = MathHelper.func_219799_g((float)event.getPartialRenderTick(), (float)entityIn.field_70127_C, (float)entityIn.field_70125_A);
                if (entityIn.func_213283_Z() == Pose.SLEEPING && (direction = entityIn.func_213376_dz()) != null) {
                    float f4 = entityIn.func_213307_e(Pose.STANDING) - 0.1f;
                    stack.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
                }
                float f7 = (float)entityIn.field_70173_aa + event.getPartialRenderTick();
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f));
                try {
                    preRenderCallback.invoke((Object)renderer, entityIn, stack, Float.valueOf(event.getPartialRenderTick()));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    new RuntimeException("Big Brain has failed to invoke preRenderCallback via reflection.");
                }
                stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
                double motionZ = Math.abs(entityIn.func_213322_ci().func_82616_c());
                stack.func_227861_a_(0.0, (double)-1.501f, (double)i * motionZ * 4.0 / (double)((IBucklerUser)entityIn).getBucklerUseTimer());
                float f8 = 0.0f;
                float f5 = 0.0f;
                if (!shouldSit && entityIn.func_70089_S()) {
                    f8 = MathHelper.func_219799_g((float)event.getPartialRenderTick(), (float)entityIn.field_184618_aE, (float)entityIn.field_70721_aZ);
                    f5 = entityIn.field_184619_aG - entityIn.field_70721_aZ * (1.0f - event.getPartialRenderTick());
                    if (entityIn.func_70631_g_()) {
                        f5 *= 3.0f;
                    }
                    if (f8 > 1.0f) {
                        f8 = 1.0f;
                    }
                }
                model.func_212843_a_((Entity)entityIn, f5, f8, event.getPartialRenderTick());
                model.func_225597_a_((Entity)entityIn, f5, f8, f7, f2, f6);
                Minecraft minecraft = Minecraft.func_71410_x();
                boolean flag = !entityIn.func_82150_aj();
                boolean flag1 = !flag && !entityIn.func_98034_c((PlayerEntity)minecraft.field_71439_g);
                boolean flag2 = minecraft.func_238206_b_((Entity)entityIn);
                RenderType rendertype = BigBrainClientEvents.getRenderType(entityIn, renderer, model, flag, flag1, flag2);
                if (rendertype != null) {
                    IVertexBuilder ivertexbuilder = event.getBuffers().getBuffer(rendertype);
                    int overlay = LivingRenderer.func_229117_c_((LivingEntity)entityIn, (float)0.0f);
                    model.func_225598_a_(stack, ivertexbuilder, event.getLight(), overlay, 1.0f, 1.0f, 1.0f, 0.3f / (float)i + 1.0f);
                }
                if (!entityIn.func_175149_v() && BigBrainConfig.RenderEntityLayersDuringAfterImage.booleanValue()) {
                    for (LayerRenderer layerrenderer : renderer.field_177097_h) {
                        layerrenderer.func_225628_a_(stack, event.getBuffers(), event.getLight(), (Entity)entityIn, f5, f8, event.getPartialRenderTick(), f7, f2, f6);
                    }
                }
                stack.func_227865_b_();
            }
        }
    }

    public static RenderType getRenderType(LivingEntity p_230496_1_, LivingRenderer<LivingEntity, ?> renderer, EntityModel<?> model, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = renderer.func_110775_a((Entity)p_230496_1_);
        if (p_230496_3_) {
            return RenderType.func_239268_f_((ResourceLocation)resourcelocation);
        }
        if (p_230496_2_) {
            return RenderType.func_228644_e_((ResourceLocation)resourcelocation);
        }
        return p_230496_4_ ? RenderType.func_228654_j_((ResourceLocation)resourcelocation) : null;
    }
}

