/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.BigBrainEnchantments;
import tallestegg.bigbrain.BigBrainSounds;
import tallestegg.bigbrain.capablities.LoafProvider;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.entity.IOneCriticalAfterCharge;
import tallestegg.bigbrain.entity.ai.goals.FindShelterGoal;
import tallestegg.bigbrain.entity.ai.goals.PressureEntityWithMultishotCrossbowGoal;
import tallestegg.bigbrain.entity.ai.goals.RunWhileChargingGoal;
import tallestegg.bigbrain.entity.ai.goals.StayInShelterGoal;
import tallestegg.bigbrain.entity.ai.goals.UseBucklerGoal;
import tallestegg.bigbrain.items.BucklerItem;

@Mod.EventBusSubscriber(modid="bigbrain")
public class BigBrainEvents {
    private static final Method setTargetPiglin = ObfuscationReflectionHelper.findMethod(PiglinTasks.class, (String)"func_234509_e_", (Class[])new Class[]{AbstractPiglinEntity.class, LivingEntity.class});

    @SubscribeEvent
    public static void onBreed(BabyEntitySpawnEvent event) {
        if (event.getParentA().func_200600_R() == EntityType.field_200784_X && event.getParentB().func_200600_R() == EntityType.field_200784_X) {
            PigEntity pig = (PigEntity)event.getParentA();
            for (int i = 0; i < BigBrainConfig.minPigBabiesBred + pig.field_70170_p.field_73012_v.nextInt(BigBrainConfig.maxPigBabiesBred + 1); ++i) {
                PigEntity baby = (PigEntity)EntityType.field_200784_X.func_200721_a(event.getChild().field_70170_p);
                baby.func_82149_j((Entity)pig);
                baby.func_82227_f(true);
                pig.func_130014_f_().func_217376_c((Entity)baby);
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof IBucklerUser && ((IBucklerUser)event.getEntity()).isBucklerDashing()) {
            event.getEntity().func_213293_j(event.getEntity().func_213322_ci().func_82615_a(), 0.0, event.getEntity().func_213322_ci().func_82616_c());
        }
    }

    @SubscribeEvent
    public static void modifiyVisibility(LivingEvent.LivingVisibilityEvent event) {
        if (event.getEntity() instanceof LivingEntity && event.getLookingEntity() instanceof LivingEntity && ((LivingEntity)event.getLookingEntity()).func_70644_a(Effects.field_76440_q)) {
            event.modifyVisibility(BigBrainConfig.mobBlindnessVision.doubleValue());
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent.Throwable event) {
        Entity entity;
        if (event.getThrowable() instanceof SnowballEntity && BigBrainConfig.snowGolemSlow.booleanValue() && event.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && (entity = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a()) instanceof LivingEntity && event.getThrowable().func_234616_v_() instanceof SnowGolemEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 3));
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof IBucklerUser) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            int turningLevel = BigBrainEnchantments.getBucklerEnchantsOnHands((Enchantment)BigBrainEnchantments.TURNING.get(), entity);
            if (!((IBucklerUser)entity).isBucklerDashing()) {
                ((IBucklerUser)entity).setBucklerUseTimer(((IBucklerUser)entity).getBucklerUseTimer() + 1);
                int configValue = turningLevel == 0 ? BigBrainConfig.BucklerRunTime : BigBrainConfig.BucklerTurningRunTime;
                if (((IBucklerUser)entity).getBucklerUseTimer() > configValue) {
                    ((IBucklerUser)entity).setBucklerUseTimer(configValue);
                }
                ((IBucklerUser)entity).setCooldown(((IBucklerUser)entity).getCooldown() + 1);
                if (((IBucklerUser)entity).getCooldown() > BigBrainConfig.BucklerCooldown) {
                    ((IBucklerUser)entity).setCooldown(BigBrainConfig.BucklerCooldown);
                }
            }
            if (((IBucklerUser)entity).isBucklerDashing()) {
                BucklerItem.moveFowards(entity);
                ((IBucklerUser)entity).setBucklerUseTimer(((IBucklerUser)entity).getBucklerUseTimer() - 1);
                ((IBucklerUser)entity).setCooldown(((IBucklerUser)entity).getCooldown() - 1);
                BigBrainEvents.spawnRunningEffectsWhileCharging(entity);
                if (turningLevel == 0) {
                    BigBrainEvents.shieldBash(entity);
                }
                if (((IBucklerUser)entity).getBucklerUseTimer() <= 0) {
                    Hand hand = entity.func_184614_ca().func_77973_b() instanceof BucklerItem ? Hand.MAIN_HAND : Hand.OFF_HAND;
                    ItemStack stack = entity.func_184586_b(hand);
                    ((IBucklerUser)entity).setBucklerDashing(false);
                    ((IBucklerUser)entity).setBucklerUseTimer(0);
                    ((IBucklerUser)entity).setCooldown(0);
                    BucklerItem.setReady(stack, false);
                    entity.func_184602_cy();
                }
                if (((IBucklerUser)entity).getCooldown() <= 0) {
                    ((IBucklerUser)entity).setCooldown(0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().toString().contains("minecraft:chests/bastion")) {
            ResourceLocation bucklerBastionLoot = new ResourceLocation("bigbrain", "chests/buckler_loot_table");
            event.getTable().addPool(LootPool.func_216096_a().name("buckler_bastion_chests").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)bucklerBastionLoot)).func_216044_b());
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(CriticalHitEvent event) {
        if (((IOneCriticalAfterCharge)event.getPlayer()).isCritical()) {
            event.setResult(Event.Result.ALLOW);
            event.setDamageModifier(1.5f);
            event.getPlayer().field_70170_p.func_184148_a((PlayerEntity)null, event.getPlayer().func_226277_ct_(), event.getPlayer().func_226278_cu_(), event.getPlayer().func_226281_cx_(), SoundEvents.field_187718_dS, event.getPlayer().func_184176_by(), 1.0f, 1.0f);
            ((IOneCriticalAfterCharge)event.getPlayer()).setCritical(false);
        }
    }

    @SubscribeEvent
    public static void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntity() instanceof AbstractPiglinEntity) {
            try {
                setTargetPiglin.invoke(PiglinTasks.class, event.getEntity(), event.getTarget());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                new RuntimeException("Big Brain has failed to invoke func_234509_e_");
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PillagerEntity) {
            PillagerEntity pillager = (PillagerEntity)entity;
            if (BigBrainConfig.PillagerMultishot.booleanValue()) {
                pillager.field_70714_bg.func_75776_a(2, new PressureEntityWithMultishotCrossbowGoal<PillagerEntity>(pillager, 1.0, 3.0f));
            }
            if (BigBrainConfig.PillagerCover.booleanValue()) {
                pillager.field_70714_bg.func_75776_a(1, (Goal)new RunWhileChargingGoal((CreatureEntity)pillager, 0.9));
            }
        }
        if (entity instanceof IMob && BigBrainConfig.MobsAttackAllVillagers.booleanValue() && !BigBrainConfig.MobBlackList.contains(entity.func_70022_Q())) {
            MobEntity mob = (MobEntity)entity;
            mob.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal(mob, AbstractVillagerEntity.class, true));
        }
        if (entity instanceof AbstractVillagerEntity && BigBrainConfig.MobsAttackAllVillagers.booleanValue()) {
            AbstractVillagerEntity villager = (AbstractVillagerEntity)entity;
            villager.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)villager, MobEntity.class, 8.0f, 1.0, 0.5, p_213469_1_ -> !BigBrainConfig.MobBlackList.contains(p_213469_1_.func_70022_Q())));
        }
        if (entity.func_200600_R().equals(ForgeRegistries.ENTITIES.getValue(new ResourceLocation("guardvillagers:guard")))) {
            CreatureEntity creature = (CreatureEntity)entity;
            creature.field_70714_bg.func_75776_a(0, new UseBucklerGoal<CreatureEntity>(creature));
        }
        if (entity instanceof PolarBearEntity) {
            PolarBearEntity polar = (PolarBearEntity)entity;
            if (BigBrainConfig.PolarBearFish.booleanValue()) {
                polar.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)polar, AbstractFishEntity.class, 10, true, true, (Predicate)null));
            }
        }
        if (BigBrainConfig.animalShelter.booleanValue() && entity instanceof AnimalEntity && !BigBrainConfig.AnimalBlackList.contains(entity.func_70022_Q()) && !(entity instanceof IFlyingAnimal)) {
            AnimalEntity animal = (AnimalEntity)entity;
            animal.field_70714_bg.func_75776_a(1, (Goal)new StayInShelterGoal((CreatureEntity)animal, 0.8));
            animal.field_70714_bg.func_75776_a(2, (Goal)new FindShelterGoal((CreatureEntity)animal));
        }
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof CatEntity) {
            event.addCapability(new ResourceLocation("bigbrain", "loaf"), (ICapabilityProvider)new LoafProvider());
        }
    }

    public static void spawnRunningEffectsWhileCharging(LivingEntity entity) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)entity.func_226277_ct_());
        BlockPos blockpos = new BlockPos(x, y = MathHelper.func_76128_c((double)(entity.func_226278_cu_() - (double)0.2f)), z = MathHelper.func_76128_c((double)entity.func_226281_cx_()));
        BlockState blockstate = entity.field_70170_p.func_180495_p(blockpos);
        if (!blockstate.addRunningEffects(entity.field_70170_p, blockpos, (Entity)entity) && blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d vector3d = entity.func_213322_ci();
            entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(blockpos), entity.func_226277_ct_() + (entity.func_70681_au().nextDouble() - 1.0) * (double)entity.func_213305_a((Pose)entity.func_213283_Z()).field_220315_a, entity.func_226278_cu_() + 0.1, entity.func_226281_cx_() + (entity.func_70681_au().nextDouble() - 1.0) * (double)entity.func_213305_a((Pose)entity.func_213283_Z()).field_220315_a, vector3d.field_72450_a * -4.0, 1.5, vector3d.field_72449_c * -4.0);
        }
    }

    public static void shieldBash(LivingEntity entity) {
        List list = entity.field_70170_p.func_175674_a((Entity)entity, entity.func_174813_aQ().func_216361_a(entity.func_213322_ci()), EntityPredicates.func_200823_a((Entity)entity));
        if (!list.isEmpty() && entity.func_70613_aW()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entityHit = (Entity)list.get(l);
                if (!(entityHit.func_70032_d((Entity)entity) <= entity.func_70032_d(entityHit))) continue;
                entityHit.func_70108_f((Entity)entity);
                int bangLevel = BigBrainEnchantments.getBucklerEnchantsOnHands((Enchantment)BigBrainEnchantments.BANG.get(), entity);
                float f = 6.0f + (float)entity.func_70681_au().nextInt(3);
                float f1 = 3.0f;
                if (!(f1 > 0.0f) || !(entity instanceof LivingEntity)) continue;
                for (int duration = 0; duration < 10; ++duration) {
                    double d0 = entity.func_70681_au().nextGaussian() * 0.02;
                    double d1 = entity.func_70681_au().nextGaussian() * 0.02;
                    double d2 = entity.func_70681_au().nextGaussian() * 0.02;
                    BasicParticleType type = entityHit instanceof WitherEntity || entityHit instanceof WitherSkeletonEntity ? ParticleTypes.field_197601_L : ParticleTypes.field_197613_f;
                    ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)type, entity.func_226282_d_(1.0), entity.func_226279_cv_() + 1.0, entity.func_226287_g_(1.0), 1, d0, d1, d2, 1.0);
                }
                if (bangLevel == 0) {
                    if (entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)entity), f)) {
                        if (entityHit instanceof LivingEntity) {
                            ((LivingEntity)entityHit).func_233627_a_(f1, (double)MathHelper.func_76126_a((float)(entity.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180)))));
                            entity.func_213317_d(entity.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        }
                        if (!entity.func_174814_R()) {
                            ((ServerWorld)entity.field_70170_p).func_184148_a((PlayerEntity)null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (SoundEvent)BigBrainSounds.SHIELD_BASH.get(), entity.func_184176_by(), 0.5f, 0.8f + entity.func_70681_au().nextFloat() * 0.4f);
                        }
                        if (entityHit instanceof PlayerEntity && ((PlayerEntity)entityHit).func_184607_cu().isShield((LivingEntity)((PlayerEntity)entityHit))) {
                            ((PlayerEntity)entityHit).func_190777_m(true);
                        }
                    }
                } else {
                    if (!entity.func_174814_R()) {
                        ((ServerWorld)entity.field_70170_p).func_184148_a((PlayerEntity)null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (SoundEvent)BigBrainSounds.SHIELD_BASH.get(), entity.func_184176_by(), 0.5f, 0.8f + entity.func_70681_au().nextFloat() * 0.4f);
                    }
                    Hand hand = entity.func_184614_ca().func_77973_b() instanceof BucklerItem ? Hand.MAIN_HAND : Hand.OFF_HAND;
                    ItemStack stack = entity.func_184586_b(hand);
                    stack.func_222118_a(5 * bangLevel, entity, player1 -> {
                        player1.func_213334_d(hand);
                        if (entity instanceof PlayerEntity) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)entity), (ItemStack)entity.func_184607_cu(), (Hand)hand);
                        }
                    });
                    Explosion.Mode mode = BigBrainConfig.BangBlockDestruction != false ? Explosion.Mode.BREAK : Explosion.Mode.NONE;
                    entity.field_70170_p.func_230546_a_((Entity)null, DamageSource.func_188405_b((LivingEntity)entity), (ExplosionContext)null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (float)bangLevel * 1.0f, false, mode);
                    ((IBucklerUser)entity).setBucklerDashing(false);
                }
                entity.func_130011_c(entityHit);
                if (!(entity instanceof IOneCriticalAfterCharge)) continue;
                ((IOneCriticalAfterCharge)entity).setCritical(BigBrainEnchantments.getBucklerEnchantsOnHands((Enchantment)BigBrainEnchantments.BANG.get(), entity) == 0);
            }
        }
    }
}

