/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.entity.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.BigBrainEnchantments;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

public class ChargeTask<T extends PiglinBruteEntity>
extends Task<T> {
    private ChargePhases chargePhase = ChargePhases.NONE;
    private int strafeTicks;

    public ChargeTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_234104_p_, (Object)MemoryModuleStatus.VALUE_ABSENT));
    }

    protected boolean shouldExecute(ServerWorld worldIn, T owner) {
        LivingEntity livingentity = this.getAttackTarget(owner);
        return livingentity != null && (double)livingentity.func_70032_d(owner) >= 4.0 && BrainUtil.func_233876_c_(owner, (LivingEntity)livingentity) && ((IBucklerUser)owner).getCooldown() == BigBrainConfig.BucklerCooldown.intValue() && owner.func_184592_cb().func_77973_b() instanceof BucklerItem && !owner.func_203008_ap();
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, T entityIn, long gameTimeIn) {
        LivingEntity livingentity = this.getAttackTarget(entityIn);
        return livingentity != null && entityIn.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_) && ((IBucklerUser)entityIn).getCooldown() == BigBrainConfig.BucklerCooldown.intValue() && entityIn.func_184592_cb().func_77973_b() instanceof BucklerItem && !entityIn.func_203008_ap() && this.chargePhase != ChargePhases.FINISH;
    }

    private LivingEntity getAttackTarget(T mob) {
        return mob.func_70638_az();
    }

    protected void updateTask(ServerWorld worldIn, T entityIn, long gameTime) {
        LivingEntity livingEntity = this.getAttackTarget(entityIn);
        if (((IBucklerUser)entityIn).isBucklerDashing() && EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)BigBrainEnchantments.TURNING.get()), (ItemStack)entityIn.func_184592_cb()) > 0 || !((IBucklerUser)entityIn).isBucklerDashing()) {
            entityIn.func_70625_a((Entity)livingEntity, 30.0f, 30.0f);
        }
        if (this.chargePhase == ChargePhases.STRAFE && this.strafeTicks > 0 && (double)entityIn.func_70032_d((Entity)livingEntity) >= 4.0 && (double)entityIn.func_70032_d((Entity)livingEntity) <= 10.0) {
            entityIn.func_70605_aq().func_188488_a(-2.0f, 0.0f);
            --this.strafeTicks;
            if (this.strafeTicks == 0) {
                this.chargePhase = ChargePhases.CHARGE;
            }
        } else if (this.chargePhase == ChargePhases.CHARGE) {
            if (!entityIn.func_184587_cr()) {
                entityIn.func_184598_c(Hand.OFF_HAND);
            }
            if (entityIn.func_184612_cw() >= entityIn.func_184607_cu().func_77988_m()) {
                this.chargePhase = ChargePhases.FINISH;
            }
        }
    }

    protected void startExecuting(ServerWorld worldIn, T entityIn, long gameTimeIn) {
        this.chargePhase = ChargePhases.STRAFE;
        this.strafeTicks = 20;
    }

    protected void resetTask(ServerWorld worldIn, T entityIn, long gameTimeIn) {
        if (entityIn.func_184587_cr()) {
            entityIn.func_184602_cy();
        }
    }

    public static enum ChargePhases {
        NONE,
        STRAFE,
        CHARGE,
        FINISH;

    }
}

