/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.mixins;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IBucklerUser {
    private static final UUID CHARGE_SPEED_UUID = UUID.fromString("A2F995E8-B25A-4883-B9D0-93A676DC4045");
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("93E74BB2-05A5-4AC0-8DF5-A55768208A95");
    private static final AttributeModifier CHARGE_SPEED_BOOST = new AttributeModifier(CHARGE_SPEED_UUID, "Charge speed boost", 9.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier KNOCKBACK_RESISTANCE = new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback reduction", 1.0, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Boolean> DASHING = EntityDataManager.func_187226_a(LivingEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    @Unique
    private int cooldown;
    @Unique
    private int bucklerUseTimer;
    @Shadow
    protected ItemStack field_184627_bm;

    public LivingEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"canBlockDamageSource"})
    public void canBlockDamageSource(DamageSource damageSourceIn, CallbackInfoReturnable<Boolean> info) {
        boolean flag = false;
        if (!damageSourceIn.func_76363_c() && this.func_184585_cz() && !flag && this.field_184627_bm.func_77973_b() instanceof BucklerItem) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"writeAdditional"})
    public void writeAdditional(CompoundNBT compound, CallbackInfo info) {
        compound.func_74757_a("BucklerDashing", this.isBucklerDashing());
        compound.func_74768_a("ChargeCooldown", this.getCooldown());
        compound.func_74768_a("BucklerUseTimer", this.getBucklerUseTimer());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditional"})
    public void readAdditional(CompoundNBT compound, CallbackInfo info) {
        this.setBucklerDashing(compound.func_74767_n("BucklerDashing"));
        this.setCooldown(compound.func_74762_e("ChargeCooldown"));
        this.setBucklerUseTimer(compound.func_74762_e("BucklerUseTimer"));
    }

    @Inject(at={@At(value="TAIL")}, method={"registerData"})
    protected void registerData(CallbackInfo info) {
        this.field_70180_af.func_187214_a(DASHING, (Object)false);
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public void setBucklerDashing(boolean dashing) {
        ModifiableAttributeInstance knockback;
        ModifiableAttributeInstance speed;
        if (!dashing) {
            speed = this.func_110148_a(Attributes.field_233821_d_);
            knockback = this.func_110148_a(Attributes.field_233820_c_);
            if (speed == null || knockback == null) {
                return;
            }
            knockback.func_111124_b(KNOCKBACK_RESISTANCE);
            if ((LivingEntity)this instanceof PlayerEntity) {
                speed.func_111124_b(CHARGE_SPEED_BOOST);
            }
            this.setBucklerUseTimer(0);
        }
        if (dashing) {
            speed = this.func_110148_a(Attributes.field_233821_d_);
            knockback = this.func_110148_a(Attributes.field_233820_c_);
            if (speed == null || knockback == null) {
                return;
            }
            knockback.func_111124_b(KNOCKBACK_RESISTANCE);
            knockback.func_233767_b_(KNOCKBACK_RESISTANCE);
            if ((LivingEntity)this instanceof PlayerEntity) {
                speed.func_111124_b(CHARGE_SPEED_BOOST);
                speed.func_233767_b_(CHARGE_SPEED_BOOST);
            }
        }
        this.field_70180_af.func_187227_b(DASHING, (Object)dashing);
    }

    @Override
    public boolean isBucklerDashing() {
        return (Boolean)this.field_70180_af.func_187225_a(DASHING);
    }

    @Override
    public int getBucklerUseTimer() {
        return this.bucklerUseTimer;
    }

    @Override
    public void setBucklerUseTimer(int bucklerUseTimer) {
        this.bucklerUseTimer = bucklerUseTimer;
    }

    @Shadow
    protected abstract ModifiableAttributeInstance func_110148_a(Attribute var1);

    @Shadow
    protected abstract boolean func_184585_cz();
}

