/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.mixins;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.BigBrainEnchantments;
import tallestegg.bigbrain.BigBrainItems;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

@Mixin(value={PiglinBruteEntity.class})
public abstract class PiglinBruteMixin
extends AbstractPiglinEntity
implements IBucklerUser {
    protected PiglinBruteMixin(EntityType<? extends AbstractPiglinEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(at={@At(value="TAIL")}, method={"onInitialSpawn(Lnet/minecraft/world/IServerWorld;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/entity/SpawnReason;Lnet/minecraft/entity/ILivingEntityData;Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/entity/ILivingEntityData;"})
    public ILivingEntityData onInitialSpawn(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag, CallbackInfoReturnable<ILivingEntityData> info) {
        this.func_180483_b(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Inject(at={@At(value="TAIL")}, method={"setEquipmentBasedOnDifficulty"})
    protected void setEquipmentBasedOnDifficulty(DifficultyInstance difficulty, CallbackInfo info) {
        if (!BigBrainConfig.BruteSpawningWithBuckler.booleanValue()) {
            return;
        }
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)BigBrainItems.BUCKLER.get()));
        this.setCooldown(240);
    }

    protected void func_241844_w(float p_241844_1_) {
        Map map;
        ItemStack itemstack;
        if (this.field_70146_Z.nextInt(300) == 0 && (itemstack = this.func_184592_cb()).func_77973_b() instanceof BucklerItem) {
            map = EnchantmentHelper.func_82781_a((ItemStack)itemstack);
            map.putIfAbsent(BigBrainEnchantments.TURNING.get(), 1);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemstack);
            this.func_184201_a(EquipmentSlotType.OFFHAND, itemstack);
        }
        if (this.field_70146_Z.nextInt(500) == 0 && (itemstack = this.func_184592_cb()).func_77973_b() instanceof BucklerItem) {
            map = EnchantmentHelper.func_82781_a((ItemStack)itemstack);
            map.putIfAbsent(BigBrainEnchantments.BANG.get(), 1);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemstack);
            this.func_184201_a(EquipmentSlotType.OFFHAND, itemstack);
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        ItemStack itemstack = this.func_184592_cb();
        if (itemstack.func_77973_b() instanceof BucklerItem) {
            boolean flag;
            float f = 0.1f;
            boolean bl = flag = f > 1.0f;
            if (!itemstack.func_190926_b() && !EnchantmentHelper.func_190939_c((ItemStack)itemstack) && (recentlyHitIn || flag) && Math.max(this.field_70146_Z.nextFloat() - (float)looting * 0.01f, 0.0f) < f) {
                if (!flag && itemstack.func_77984_f()) {
                    itemstack.func_196085_b(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(itemstack.func_77958_k() / 2)));
                }
                this.func_199701_a_(itemstack);
                this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
            }
        }
    }
}

