/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.mixins;

import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

@Mixin(value={BipedModel.class})
public abstract class PlayerModelMixin<T extends LivingEntity>
extends AgeableModel<T> {
    @Shadow
    @Final
    public ModelRenderer field_178724_i;
    @Shadow
    @Final
    public ModelRenderer field_178723_h;

    @Inject(at={@At(value="TAIL")}, method={"setRotationAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V"})
    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (entityIn.func_184591_cq() == HandSide.RIGHT) {
            this.bucklerAnimationsRightArm(Hand.MAIN_HAND, entityIn);
            this.bucklerAnimationsLeftArm(Hand.OFF_HAND, entityIn);
        } else {
            this.bucklerAnimationsLeftArm(Hand.MAIN_HAND, entityIn);
            this.bucklerAnimationsRightArm(Hand.OFF_HAND, entityIn);
        }
    }

    public void bucklerAnimationsLeftArm(Hand hand, T entityIn) {
        if (entityIn.func_184600_cs() == hand && entityIn.func_184586_b(entityIn.func_184600_cs()).func_77973_b() instanceof BucklerItem) {
            float useDuration = entityIn.func_184586_b(entityIn.func_184600_cs()).func_77988_m();
            float useDurationClamped = MathHelper.func_76131_a((float)entityIn.func_184612_cw(), (float)0.0f, (float)useDuration);
            float result = useDurationClamped / useDuration;
            this.field_178724_i.field_78796_g = MathHelper.func_219799_g((float)result, (float)this.field_178724_i.field_78796_g, (float)1.1466813f);
            this.field_178724_i.field_78795_f = MathHelper.func_219799_g((float)result, (float)this.field_178724_i.field_78795_f, (float)(this.field_178724_i.field_78795_f * 0.1f - 1.5f));
        }
        if (entityIn instanceof IBucklerUser && ((IBucklerUser)entityIn).isBucklerDashing() && BucklerItem.isReady(entityIn.func_184586_b(hand))) {
            ItemStack handItems;
            ItemStack itemStack = handItems = hand == Hand.MAIN_HAND ? entityIn.func_184592_cb() : entityIn.func_184614_ca();
            if (!handItems.func_190926_b()) {
                this.field_178723_h.field_78795_f = -2.0132742f;
                this.field_178723_h.field_78796_g = 0.5235988f;
            }
            this.field_178724_i.field_78795_f = this.field_178724_i.field_78795_f * 0.1f - 1.5f;
            this.field_178724_i.field_78796_g = 1.1466813f;
        }
    }

    public void bucklerAnimationsRightArm(Hand hand, T entityIn) {
        if (entityIn.func_184600_cs() == hand && entityIn.func_184586_b(entityIn.func_184600_cs()).func_77973_b() instanceof BucklerItem) {
            float useDuration = entityIn.func_184586_b(entityIn.func_184600_cs()).func_77988_m();
            float useDurationClamped = MathHelper.func_76131_a((float)entityIn.func_184612_cw(), (float)0.0f, (float)useDuration);
            float result = useDurationClamped / useDuration;
            this.field_178723_h.field_78796_g = MathHelper.func_219799_g((float)result, (float)this.field_178723_h.field_78796_g, (float)-1.1466813f);
            this.field_178723_h.field_78795_f = MathHelper.func_219799_g((float)result, (float)this.field_178723_h.field_78795_f, (float)(this.field_178723_h.field_78795_f * 0.1f - 1.5f));
        }
        if (entityIn instanceof IBucklerUser && ((IBucklerUser)entityIn).isBucklerDashing() && BucklerItem.isReady(entityIn.func_184586_b(hand))) {
            ItemStack handItems;
            ItemStack itemStack = handItems = hand == Hand.MAIN_HAND ? entityIn.func_184592_cb() : entityIn.func_184614_ca();
            if (!handItems.func_190926_b()) {
                this.field_178724_i.field_78795_f = -2.0132742f;
                this.field_178724_i.field_78796_g = -0.5235988f;
            }
            this.field_178723_h.field_78795_f = -1.5f;
            this.field_178723_h.field_78796_g = -1.1466813f;
        }
    }
}

