/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.entity.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import tallestegg.bigbrain.BigBrainConfig;
import tallestegg.bigbrain.BigBrainEnchantments;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

public class ChargeTask<T extends PiglinBrute>
extends Behavior<T> {
    private ChargePhases chargePhase = ChargePhases.NONE;
    private int strafeTicks;

    public ChargeTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, T owner) {
        LivingEntity livingentity = this.getAttackTarget(owner);
        return livingentity != null && (double)livingentity.m_20270_(owner) >= 4.0 && BehaviorUtils.m_22667_(owner, (LivingEntity)livingentity) && ((IBucklerUser)owner).getCooldown() == BigBrainConfig.BucklerCooldown.intValue() && owner.m_21206_().m_41720_() instanceof BucklerItem && !owner.m_20071_();
    }

    protected boolean canStillUse(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        LivingEntity livingentity = this.getAttackTarget(entityIn);
        return livingentity != null && entityIn.m_6274_().m_21874_(MemoryModuleType.f_26372_) && ((IBucklerUser)entityIn).getCooldown() == BigBrainConfig.BucklerCooldown.intValue() && entityIn.m_21206_().m_41720_() instanceof BucklerItem && !entityIn.m_20071_() && this.chargePhase != ChargePhases.FINISH;
    }

    private LivingEntity getAttackTarget(T mob) {
        return mob.m_5448_();
    }

    protected void tick(ServerLevel worldIn, T entityIn, long gameTime) {
        LivingEntity livingEntity = this.getAttackTarget(entityIn);
        if (((IBucklerUser)entityIn).isBucklerDashing() && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BigBrainEnchantments.TURNING.get()), (ItemStack)entityIn.m_21206_()) > 0 || !((IBucklerUser)entityIn).isBucklerDashing()) {
            entityIn.m_21391_((Entity)livingEntity, 30.0f, 30.0f);
        }
        if (this.chargePhase == ChargePhases.STRAFE && this.strafeTicks > 0 && (double)entityIn.m_20270_((Entity)livingEntity) >= 4.0 && (double)entityIn.m_20270_((Entity)livingEntity) <= 10.0) {
            entityIn.m_21566_().m_24988_(-2.0f, 0.0f);
            --this.strafeTicks;
            if (this.strafeTicks == 0) {
                this.chargePhase = ChargePhases.CHARGE;
            }
        } else if (this.chargePhase == ChargePhases.CHARGE) {
            if (!entityIn.m_6117_()) {
                entityIn.m_6672_(InteractionHand.OFF_HAND);
            }
            if (entityIn.m_21252_() >= entityIn.m_21211_().m_41779_()) {
                this.chargePhase = ChargePhases.FINISH;
            }
        }
    }

    protected void start(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        this.chargePhase = ChargePhases.STRAFE;
        this.strafeTicks = 20;
    }

    protected void stop(ServerLevel worldIn, T entityIn, long gameTimeIn) {
        if (entityIn.m_6117_()) {
            entityIn.m_5810_();
        }
    }

    public static enum ChargePhases {
        NONE,
        STRAFE,
        CHARGE,
        FINISH;

    }
}

