/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.bigbrain.mixins;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tallestegg.bigbrain.entity.IBucklerUser;
import tallestegg.bigbrain.items.BucklerItem;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IBucklerUser {
    private static final UUID CHARGE_SPEED_UUID = UUID.fromString("A2F995E8-B25A-4883-B9D0-93A676DC4045");
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("93E74BB2-05A5-4AC0-8DF5-A55768208A95");
    private static final AttributeModifier CHARGE_SPEED_BOOST = new AttributeModifier(CHARGE_SPEED_UUID, "Charge speed boost", 9.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AttributeModifier KNOCKBACK_RESISTANCE = new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback reduction", 1.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> DASHING = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private int cooldown;
    @Unique
    private int bucklerUseTimer;
    @Shadow
    protected ItemStack f_20935_;

    public LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"isDamageSourceBlocked"})
    public void isDamageSourceBlocked(DamageSource damageSourceIn, CallbackInfoReturnable<Boolean> info) {
        boolean flag = false;
        if (!damageSourceIn.m_19376_() && this.m_21254_() && !flag && this.f_20935_.m_41720_() instanceof BucklerItem) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    public void writeAdditional(CompoundTag compound, CallbackInfo info) {
        compound.m_128379_("BucklerDashing", this.isBucklerDashing());
        compound.m_128405_("ChargeCooldown", this.getCooldown());
        compound.m_128405_("BucklerUseTimer", this.getBucklerUseTimer());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    public void readAdditional(CompoundTag compound, CallbackInfo info) {
        this.setBucklerDashing(compound.m_128471_("BucklerDashing"));
        this.setCooldown(compound.m_128451_("ChargeCooldown"));
        this.setBucklerUseTimer(compound.m_128451_("BucklerUseTimer"));
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    protected void defineSynchedData(CallbackInfo info) {
        this.f_19804_.m_135372_(DASHING, (Object)false);
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public void setBucklerDashing(boolean dashing) {
        AttributeInstance knockback;
        AttributeInstance speed;
        if (!dashing) {
            speed = this.m_21051_(Attributes.f_22279_);
            knockback = this.m_21051_(Attributes.f_22278_);
            if (speed == null || knockback == null) {
                return;
            }
            knockback.m_22130_(KNOCKBACK_RESISTANCE);
            if ((LivingEntity)this instanceof Player) {
                speed.m_22130_(CHARGE_SPEED_BOOST);
            }
            this.setBucklerUseTimer(0);
        }
        if (dashing) {
            speed = this.m_21051_(Attributes.f_22279_);
            knockback = this.m_21051_(Attributes.f_22278_);
            if (speed == null || knockback == null) {
                return;
            }
            knockback.m_22130_(KNOCKBACK_RESISTANCE);
            knockback.m_22118_(KNOCKBACK_RESISTANCE);
            if ((LivingEntity)this instanceof Player) {
                speed.m_22130_(CHARGE_SPEED_BOOST);
                speed.m_22118_(CHARGE_SPEED_BOOST);
            }
        }
        this.f_19804_.m_135381_(DASHING, (Object)dashing);
    }

    @Override
    public boolean isBucklerDashing() {
        return (Boolean)this.f_19804_.m_135370_(DASHING);
    }

    @Override
    public int getBucklerUseTimer() {
        return this.bucklerUseTimer;
    }

    @Override
    public void setBucklerUseTimer(int bucklerUseTimer) {
        this.bucklerUseTimer = bucklerUseTimer;
    }

    @Shadow
    public abstract AttributeInstance m_21051_(Attribute var1);

    @Shadow
    protected abstract boolean m_21254_();

    @Shadow
    public abstract boolean m_21093_(Predicate<Item> var1);
}

