/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.corelib.tag;

import de.maxhenkel.camera.corelib.tag.NamedTagWrapper;
import de.maxhenkel.camera.corelib.tag.SingleElementTag;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

public class TagUtils {
    public static Tag.Named<Block> AIR_BLOCK_TAG = new SingleElementTag<Block>(Blocks.f_50016_);
    public static Tag.Named<Item> AIR_ITEM_TAG = new SingleElementTag<Item>(Items.f_41852_);
    public static Tag.Named<Fluid> AIR_FLUID_TAG = new SingleElementTag<Fluid>(Fluids.f_76191_);

    @Nullable
    public static Tag.Named<Block> getBlock(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(name.substring(1));
            Tag tag = BlockTags.m_13115_().m_13404_(id);
            if (tag == null) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_BLOCK_TAG;
            }
            return new NamedTagWrapper<Block>(tag, id);
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.BLOCKS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (block == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        return new SingleElementTag<Block>(block);
    }

    public static Tag.Named<Block> getBlock(String name) {
        return TagUtils.getBlock(name, false);
    }

    @Nullable
    public static Tag.Named<Item> getItem(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(name.substring(1));
            Tag tag = ItemTags.m_13193_().m_13404_(id);
            if (tag == null) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_ITEM_TAG;
            }
            return new NamedTagWrapper<Item>(tag, id);
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        if (item == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        return new SingleElementTag<Item>(item);
    }

    public static Tag.Named<Item> getItem(String name) {
        return TagUtils.getItem(name, false);
    }

    @Nullable
    public static Tag.Named<Fluid> getFluid(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(name.substring(1));
            Tag tag = FluidTags.m_144299_().m_13404_(id);
            if (tag == null) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_FLUID_TAG;
            }
            return new NamedTagWrapper<Fluid>(tag, id);
        }
        ResourceLocation resourceLocation = new ResourceLocation(name);
        if (!ForgeRegistries.FLUIDS.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name));
        if (fluid == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        return new SingleElementTag<Fluid>(fluid);
    }

    public static Tag.Named<Fluid> getFluid(String name) {
        return TagUtils.getFluid(name, false);
    }
}

