/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.integration.jei;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.RecipeImageCloning;
import de.maxhenkel.camera.gui.AlbumScreen;
import de.maxhenkel.camera.gui.CameraScreen;
import de.maxhenkel.camera.gui.ImageScreen;
import de.maxhenkel.camera.gui.LecternAlbumScreen;
import de.maxhenkel.camera.gui.ResizeFrameScreen;
import de.maxhenkel.camera.integration.jei.ImageCopyExtension;
import de.maxhenkel.camera.integration.jei.NoJEIGuiProperties;
import de.maxhenkel.camera.integration.jei.TakeImageCategory;
import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation CATEGORY_TAKE_IMAGE = new ResourceLocation("camera", "take_image");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("camera", "camera");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Main.CAMERA), new ResourceLocation[]{CATEGORY_TAKE_IMAGE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new TakeImageCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiScreenHandler(ImageScreen.class, NoJEIGuiProperties::new);
        registration.addGuiScreenHandler(AlbumScreen.class, NoJEIGuiProperties::new);
        registration.addGuiScreenHandler(LecternAlbumScreen.class, NoJEIGuiProperties::new);
        registration.addGuiScreenHandler(ResizeFrameScreen.class, NoJEIGuiProperties::new);
        registration.addGuiScreenHandler(CameraScreen.class, NoJEIGuiProperties::new);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes((Collection)Main.SERVER_CONFIG.cameraConsumeItem.m_6497_().stream().map(item -> new ItemStack((ItemLike)item, ((Integer)Main.SERVER_CONFIG.cameraConsumeItemAmount.get()).intValue())).collect(Collectors.toList()), CATEGORY_TAKE_IMAGE);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory craftingCategory = registration.getCraftingCategory();
        craftingCategory.addCategoryExtension(RecipeImageCloning.class, ImageCopyExtension::new);
    }
}

