/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.items.ImageItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ImageData {
    private UUID id;
    private long time;
    private String owner;
    @Nullable
    private ResourceLocation biome;
    @Nullable
    private List<ResourceLocation> entities;

    private ImageData() {
    }

    public UUID getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public String getOwner() {
        return this.owner;
    }

    @Nullable
    public ResourceLocation getBiome() {
        return this.biome;
    }

    @Nullable
    public List<ResourceLocation> getEntities() {
        return this.entities;
    }

    @Nullable
    public static ImageData fromStack(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ImageItem)) {
            return null;
        }
        ImageData data = new ImageData();
        UUID id = ImageData.getImageID(stack);
        if (id == null) {
            return null;
        }
        data.id = id;
        data.time = ImageData.getTime(stack);
        data.owner = ImageData.getOwner(stack);
        if (((Boolean)Main.SERVER_CONFIG.advancedImageData.get()).booleanValue()) {
            data.biome = ImageData.getBiome(stack);
            data.entities = ImageData.getEntities(stack);
        }
        return data;
    }

    public static ImageData create(ServerPlayer player, UUID imageID) {
        ImageData data = new ImageData();
        data.id = imageID;
        data.time = System.currentTimeMillis();
        data.owner = player.m_7755_().m_6111_();
        if (((Boolean)Main.SERVER_CONFIG.advancedImageData.get()).booleanValue()) {
            data.biome = player.f_19853_.m_46857_(player.m_142538_()).getRegistryName();
            data.entities = player.f_19853_.m_6443_(LivingEntity.class, player.m_142469_().m_82400_(128.0), e -> ImageData.canEntityBeSeen(player, (Entity)e)).stream().sorted(Comparator.comparingDouble(arg_0 -> ((ServerPlayer)player).m_20270_(arg_0))).map(livingEntity -> livingEntity.m_6095_().getRegistryName()).distinct().limit(((Integer)Main.SERVER_CONFIG.advancedDataMaxEntities.get()).intValue()).collect(Collectors.toList());
        }
        return data;
    }

    private static boolean canEntityBeSeen(ServerPlayer player, Entity entity) {
        Vec3 lookVec;
        if (player == entity) {
            return false;
        }
        Vec3 playerVec = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        Vec3 entityVec = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        Vec3 lookVecToEntity = entityVec.m_82546_(playerVec).m_82541_();
        if (ImageData.angle(lookVecToEntity, lookVec = player.m_20154_().m_82541_()) > 90.0) {
            return false;
        }
        return player.f_19853_.m_45547_(new ClipContext(playerVec, entityVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_6662_() == HitResult.Type.MISS;
    }

    private static double angle(Vec3 vec1, Vec3 vec2) {
        return Math.toDegrees(Math.acos(vec1.m_82526_(vec2) / (vec1.m_82553_() * vec2.m_82553_())));
    }

    public static ImageData dummy() {
        ImageData data = new ImageData();
        data.id = new UUID(0L, 0L);
        data.time = System.currentTimeMillis();
        data.owner = "Steve";
        return data;
    }

    public void addToImage(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ImageItem)) {
            return;
        }
        ImageData.setImageID(stack, this.id);
        ImageData.setTime(stack, this.time);
        ImageData.setOwner(stack, this.owner);
        if (this.biome != null) {
            ImageData.setBiome(stack, this.biome);
        }
        if (this.entities != null) {
            ImageData.setEntities(stack, this.entities);
        }
    }

    private static CompoundTag getImageTag(ItemStack stack) {
        assert (stack.m_41720_() instanceof ImageItem);
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128425_("image", 10)) {
            compound.m_128365_("image", (Tag)new CompoundTag());
        }
        return compound.m_128469_("image");
    }

    private static void setImageID(ItemStack stack, UUID uuid) {
        CompoundTag compound = ImageData.getImageTag(stack);
        compound.m_128356_("image_id_most", uuid.getMostSignificantBits());
        compound.m_128356_("image_id_least", uuid.getLeastSignificantBits());
    }

    @Nullable
    public static UUID getImageID(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.m_128425_("image_id_most", 4) || !compound.m_128425_("image_id_least", 4)) {
            return null;
        }
        long most = compound.m_128454_("image_id_most");
        long least = compound.m_128454_("image_id_least");
        return new UUID(most, least);
    }

    private static void setTime(ItemStack stack, long time) {
        CompoundTag compound = ImageData.getImageTag(stack);
        compound.m_128356_("image_time", time);
    }

    private static long getTime(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.m_128425_("image_time", 4)) {
            return 0L;
        }
        return compound.m_128454_("image_time");
    }

    private static void setOwner(ItemStack stack, String name) {
        CompoundTag compound = ImageData.getImageTag(stack);
        compound.m_128359_("owner", name);
    }

    private static String getOwner(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.m_128425_("owner", 8)) {
            return "";
        }
        return compound.m_128461_("owner");
    }

    private static void setBiome(ItemStack stack, ResourceLocation biome) {
        CompoundTag compound = ImageData.getImageTag(stack);
        compound.m_128359_("biome", biome.toString());
    }

    @Nullable
    private static ResourceLocation getBiome(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.m_128425_("biome", 8)) {
            return null;
        }
        return new ResourceLocation(compound.m_128461_("biome"));
    }

    private static void setEntities(ItemStack stack, List<ResourceLocation> entities) {
        CompoundTag compound = ImageData.getImageTag(stack);
        ListTag list = new ListTag();
        for (ResourceLocation entity : entities) {
            list.add((Object)StringTag.m_129297_((String)entity.toString()));
        }
        compound.m_128365_("entities", (Tag)list);
    }

    @Nullable
    private static List<ResourceLocation> getEntities(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.m_128425_("entities", 9)) {
            return null;
        }
        ListTag entities = compound.m_128437_("entities", 8);
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Tag e : entities) {
            list.add(new ResourceLocation(e.m_7916_()));
        }
        return list;
    }
}

