/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.gui.DummyContainer;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ImageScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    public static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    @Nullable
    private UUID imageID;

    public ImageScreen(ItemStack image) {
        super((AbstractContainerMenu)new DummyContainer(), Minecraft.m_91087_().f_91074_.m_150109_(), (Component)new TranslatableComponent("gui.image.title"));
        this.imageID = ImageData.getImageID(image);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.imageID == null) {
            return;
        }
        ImageScreen.drawImage(matrixStack, this.f_96541_, this.f_96543_, this.f_96544_, 100.0f, this.imageID);
    }

    public static void drawImage(PoseStack matrixStack, Minecraft minecraft, int width, int height, float zLevel, UUID uuid) {
        float hnew;
        float wnew;
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation location = TextureCache.instance().getImage(uuid);
        float imageWidth = 12.0f;
        float imageHeight = 8.0f;
        if (location == null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)DEFAULT_IMAGE);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)location);
            NativeImage image = TextureCache.instance().getNativeImage(uuid);
            imageWidth = image.m_84982_();
            imageHeight = image.m_85084_();
        }
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float scale = 0.8f;
        float ws = (float)width * scale;
        float hs = (float)height * scale;
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, left += (1.0f - scale) * ws / 2.0f, top += (1.0f - scale) * hs / 2.0f, zLevel).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix, left, top + hnew, zLevel).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix, left + wnew, top + hnew, zLevel).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix, left + wnew, top, zLevel).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
        matrixStack.m_85849_();
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }
}

