/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.blaze3d.platform.NativeImage;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.CommonUtils;
import de.maxhenkel.camera.corelib.client.RenderUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ImageTools {
    public static LevelResource CAMERA_IMAGES = new LevelResource("camera_images");
    private static final int MAX_IMAGE_SIZE = 1920;
    private static boolean chooserOpen;

    public static BufferedImage fromNativeImage(NativeImage nativeImage) {
        BufferedImage bufferedImage = new BufferedImage(nativeImage.m_84982_(), nativeImage.m_85084_(), 1);
        for (int x = 0; x < nativeImage.m_84982_(); ++x) {
            for (int y = 0; y < nativeImage.m_85084_(); ++y) {
                int rgba = nativeImage.m_84985_(x, y);
                int alpha = RenderUtils.getAlpha(rgba);
                int red = RenderUtils.getRed(rgba);
                int green = RenderUtils.getGreen(rgba);
                int blue = RenderUtils.getBlue(rgba);
                bufferedImage.setRGB(x, y, RenderUtils.getArgb(alpha, blue, green, red));
            }
        }
        return bufferedImage;
    }

    public static NativeImage toNativeImage(BufferedImage bufferedImage) {
        NativeImage nativeImage = new NativeImage(bufferedImage.getWidth(), bufferedImage.getHeight(), false);
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                int rgba = bufferedImage.getRGB(x, y);
                int alpha = RenderUtils.getAlpha(rgba);
                int red = RenderUtils.getRed(rgba);
                int green = RenderUtils.getGreen(rgba);
                int blue = RenderUtils.getBlue(rgba);
                nativeImage.m_84988_(x, y, RenderUtils.getArgb(alpha, blue, green, red));
            }
        }
        return nativeImage;
    }

    public static byte[] toBytes(BufferedImage image) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", baos);
        baos.flush();
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    public static BufferedImage fromBytes(byte[] data) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(bais);
        bais.close();
        return image;
    }

    public static byte[] optimizeImage(BufferedImage image) throws IOException {
        byte[] data;
        float ratio = (float)image.getHeight() / (float)image.getWidth();
        int newWidth = image.getWidth();
        int newHeight = image.getHeight();
        if (image.getHeight() > 1920 || image.getWidth() > 1920) {
            if (ratio < 1.0f) {
                newHeight = (int)(1920.0f * ratio);
                newWidth = 1920;
            } else {
                newWidth = (int)(1920.0f / ratio);
                newHeight = 1920;
            }
        }
        image = ImageTools.resize(image, newWidth, newHeight);
        float factor = ((Double)Main.SERVER_CONFIG.imageCompression.get()).floatValue();
        while ((data = ImageTools.compressToBytes(image, factor)).length > (Integer)Main.SERVER_CONFIG.maxImageSize.get()) {
            Main.LOGGER.debug("Trying to compress image: {}% {} bytes (max {})", (Object)Math.round(factor * 100.0f), (Object)data.length, Main.SERVER_CONFIG.maxImageSize.get());
            if (!((factor -= 0.025f) <= 0.0f)) continue;
            throw new IOException("Image could not be compressed (too large)");
        }
        Main.LOGGER.debug("Image compressed to {}% ({} bytes)", (Object)Math.round(factor * 100.0f), (Object)data.length);
        return data;
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage bufferedImage = new BufferedImage(newW, newH, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static BufferedImage compress(BufferedImage img, float factor) throws IOException {
        return ImageTools.fromBytes(ImageTools.compressToBytes(img, factor));
    }

    public static byte[] compressToBytes(BufferedImage img, float factor) throws IOException {
        ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
        jpgWriteParam.setCompressionMode(2);
        jpgWriteParam.setCompressionQuality(factor);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(baos);
        jpgWriter.setOutput(stream);
        IIOImage outputImage = new IIOImage(img, null, null);
        jpgWriter.write(null, outputImage, jpgWriteParam);
        jpgWriter.dispose();
        baos.flush();
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    @Deprecated
    public static File getImageFileLegacy(ServerPlayer playerMP, UUID uuid) {
        File imageFolder = CommonUtils.getWorldFolder(playerMP.m_284548_(), CAMERA_IMAGES);
        File image = new File(imageFolder, uuid.toString() + ".jpg");
        if (!image.exists()) {
            image = new File(imageFolder, uuid.toString() + ".png");
        }
        return image;
    }

    public static File getImageFile(ServerPlayer playerMP, UUID uuid) {
        File imageFolder = CommonUtils.getWorldFolder(playerMP.m_284548_(), CAMERA_IMAGES);
        return new File(imageFolder, uuid.toString() + ".jpg");
    }

    public static void saveImage(ServerPlayer playerMP, UUID uuid, BufferedImage bufferedImage) throws IOException {
        File image = ImageTools.getImageFile(playerMP, uuid);
        image.mkdirs();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", image);
    }

    public static BufferedImage loadImage(ServerPlayer playerMP, UUID uuid) throws IOException {
        return ImageTools.loadImage(ImageTools.getImageFileLegacy(playerMP, uuid));
    }

    public static BufferedImage loadImage(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedImage bufferedImage = ImageIO.read(fis);
        if (bufferedImage == null) {
            throw new IOException("Failed to read image");
        }
        return bufferedImage;
    }

    public static void chooseImage(Consumer<File> onResult) {
        if (chooserOpen) {
            return;
        }
        new Thread(() -> {
            File last;
            chooserOpen = true;
            File dir = new File(System.getProperty("user.home"));
            String lastPath = (String)Main.CLIENT_CONFIG.lastImagePath.get();
            if (!lastPath.isEmpty() && (last = new File(lastPath)).exists()) {
                dir = last;
            }
            MemoryStack stack = MemoryStack.stackPush();
            PointerBuffer filters = stack.mallocPointer(6);
            filters.put(stack.UTF8((CharSequence)"*.png"));
            filters.put(stack.UTF8((CharSequence)"*.jpg"));
            filters.put(stack.UTF8((CharSequence)"*.jpeg"));
            filters.flip();
            String path = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)Component.m_237115_((String)"title.choose_image").getString(), (CharSequence)(dir.getAbsolutePath() + File.separator), (PointerBuffer)filters, (CharSequence)Component.m_237115_((String)"filetype.images").getString(), (boolean)false);
            if (path == null) {
                chooserOpen = false;
                return;
            }
            File image = new File(path);
            if (image.exists() && !image.isDirectory()) {
                Main.CLIENT_CONFIG.lastImagePath.set((Object)image.getParent());
                Main.CLIENT_CONFIG.lastImagePath.save();
                onResult.accept(image);
            }
            chooserOpen = false;
        }).start();
    }

    public static boolean isFileChooserOpen() {
        return chooserOpen;
    }
}

