/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.corelib.inventory.ScreenBase;
import de.maxhenkel.camera.corelib.net.NetUtils;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageSetShader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CameraScreen
extends ScreenBase<AbstractContainerMenu> {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/camera.png");
    private static final int FONT_COLOR = 0x404040;
    private static final int PADDING = 10;
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 20;
    private int index = 0;
    @Nullable
    private Button upload;

    public CameraScreen(String currentShader) {
        super(CAMERA_TEXTURE, new DummyContainer(), Minecraft.m_91087_().f_91074_.m_150109_(), (Component)Component.m_237115_((String)"gui.camera.title"));
        this.f_97726_ = 248;
        this.f_97727_ = 109;
        for (int i = 0; i < Shaders.SHADER_LIST.size(); ++i) {
            String s = Shaders.SHADER_LIST.get(i);
            if (currentShader == null) {
                if (!s.equals("none")) continue;
                this.index = i;
                break;
            }
            if (!s.equals(currentShader)) continue;
            this.index = i;
            break;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        Button.Builder builder = Button.m_253074_((Component)Component.m_237115_((String)"button.camera.prev"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = Shaders.SHADER_LIST.size() - 1;
            }
            this.sendShader();
        });
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)builder.m_252987_(this.f_97735_ + 10, this.f_97736_ + 10 + 9 + 10, 70, 20).m_253136_());
        Button.Builder builder2 = Button.m_253074_((Component)Component.m_237115_((String)"button.camera.next"), button -> {
            ++this.index;
            if (this.index >= Shaders.SHADER_LIST.size()) {
                this.index = 0;
            }
            this.sendShader();
        });
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)builder2.m_252987_(this.f_97735_ + this.f_97726_ - 70 - 10, this.f_97736_ + 10 + 9 + 10, 70, 20).m_253136_());
        if (((Boolean)Main.SERVER_CONFIG.allowImageUpload.get()).booleanValue()) {
            this.upload = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.camera.upload"), button -> ImageTools.chooseImage(file -> {
                try {
                    UUID uuid = UUID.randomUUID();
                    BufferedImage image = ImageTools.loadImage(file);
                    ClientImageUploadManager.addImage(uuid, image);
                    NetUtils.sendToServer(Main.SIMPLE_CHANNEL, new MessageRequestUploadCustomImage(uuid));
                }
                catch (IOException e) {
                    this.f_96541_.f_91074_.m_5661_((Component)Component.m_237110_((String)"message.upload_error", (Object[])new Object[]{e.getMessage()}), true);
                    e.printStackTrace();
                }
                this.f_96541_.f_91080_ = null;
            })).m_252987_(this.f_97735_ + this.f_97726_ / 2 - 35, this.f_97736_ + this.f_97727_ - 20 - 10, 70, 20).m_253136_());
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.upload != null) {
            this.upload.f_93623_ = !ImageTools.isFileChooserOpen();
        }
    }

    private void sendShader() {
        NetUtils.sendToServer(Main.SIMPLE_CHANNEL, new MessageSetShader(Shaders.SHADER_LIST.get(this.index)));
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        MutableComponent chooseFilter = Component.m_237115_((String)"gui.camera.choose_filter");
        int chooseFilterWidth = this.f_96547_.m_92852_((FormattedText)chooseFilter);
        guiGraphics.m_280649_(this.f_96547_, chooseFilter.m_7532_(), this.f_97726_ / 2 - chooseFilterWidth / 2, 10, 0x404040, false);
        MutableComponent shaderName = Component.m_237115_((String)("shader." + Shaders.SHADER_LIST.get(this.index)));
        int shaderWidth = this.f_96547_.m_92852_((FormattedText)shaderName);
        FormattedCharSequence formattedCharSequence = shaderName.m_7532_();
        int n = this.f_97726_ / 2 - shaderWidth / 2;
        Objects.requireNonNull(this.f_96547_);
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, n, 10 + 9 + 10 + 10 - 9 / 2, ChatFormatting.WHITE.m_126665_().intValue(), false);
        MutableComponent uploadImage = Component.m_237115_((String)"gui.camera.upload_image");
        int uploadImageWidth = this.f_96547_.m_92852_((FormattedText)uploadImage);
        FormattedCharSequence formattedCharSequence2 = uploadImage.m_7532_();
        int n2 = this.f_97726_ / 2 - uploadImageWidth / 2;
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280649_(this.f_96547_, formattedCharSequence2, n2, this.f_97727_ - 10 - 20 - 10 - 9, 0x404040, false);
    }
}

