/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.AlbumInventoryContainer;
import de.maxhenkel.camera.gui.AlbumScreen;
import de.maxhenkel.camera.inventory.AlbumInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlbumItem
extends Item {
    public AlbumItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        final ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            if (!playerIn.m_9236_().f_46443_ && playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                serverPlayer.m_5893_(new MenuProvider(){

                    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                        return new AlbumInventoryContainer(id, (Container)playerInventory, new AlbumInventory(stack));
                    }

                    public Component m_5446_() {
                        return Component.m_237115_((String)AlbumItem.this.m_5524_());
                    }
                });
            }
        } else {
            AlbumItem.openAlbum(playerIn, stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static void openAlbum(Player player, ItemStack album) {
        List<UUID> images;
        if (player.m_9236_().f_46443_ && !(images = ((AlbumItem)((Object)Main.ALBUM.get())).getImages(album)).isEmpty()) {
            AlbumItem.openClientGui(images);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openClientGui(List<UUID> images) {
        Minecraft.m_91087_().m_91152_((Screen)new AlbumScreen(images));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        BlockState blockstate = world.m_8055_(blockpos = context.m_8083_());
        if (blockstate.m_60713_(Blocks.f_50624_)) {
            return LecternBlock.m_269125_((Entity)context.m_43723_(), (Level)world, (BlockPos)blockpos, (BlockState)blockstate, (ItemStack)context.m_43722_()) ? InteractionResult.m_19078_((boolean)world.f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public List<UUID> getImages(ItemStack stack) {
        if (stack.m_41619_()) {
            return Collections.emptyList();
        }
        ArrayList<UUID> images = new ArrayList<UUID>();
        AlbumInventory inventory = new AlbumInventory(stack);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack s = inventory.m_8020_(i);
            UUID uuid = ImageData.getImageID(s);
            if (uuid == null) continue;
            images.add(uuid);
        }
        return images;
    }
}

