/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.items.ImageItem;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ImageCloningRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    private final ResourceLocation id;
    private final ItemStack image;
    private final Ingredient paper;

    public ImageCloningRecipe(ResourceLocation id, ItemStack image, Ingredient paper) {
        this.id = id;
        this.image = image;
        this.paper = paper;
    }

    public int getRecipeWidth() {
        return 2;
    }

    public int getRecipeHeight() {
        return 2;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.image}), this.paper});
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.craft(inv) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        CraftingResult craft = this.craft(inv);
        if (craft == null) {
            return null;
        }
        return craft.remaining;
    }

    public ItemStack assemble(CraftingContainer inv) {
        CraftingResult craft = this.craft(inv);
        if (craft == null) {
            return null;
        }
        return craft.result;
    }

    public boolean m_8004_(int width, int height) {
        return width > 1 && height > 1;
    }

    public ItemStack m_8043_() {
        return this.image;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStack getImage() {
        return this.image;
    }

    public Ingredient getPaper() {
        return this.paper;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Main.IMAGE_CLONING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    protected CraftingResult craft(CraftingContainer inv) {
        ItemStack image = null;
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        int paperSlotIndex = -1;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ImageItem) {
                if (image != null) {
                    return null;
                }
                image = stack;
                remaining.set(i, (Object)image.m_41777_());
                continue;
            }
            if (!stack.m_204117_(Main.IMAGE_PAPER)) continue;
            if (paperSlotIndex >= 0) {
                return null;
            }
            paperSlotIndex = i;
        }
        if (image == null) {
            return null;
        }
        if (paperSlotIndex < 0) {
            return null;
        }
        ItemStack imageOut = image.m_41777_();
        imageOut.m_41764_(1);
        return new CraftingResult(imageOut, (NonNullList<ItemStack>)remaining);
    }

    private static class CraftingResult {
        public final ItemStack result;
        public final NonNullList<ItemStack> remaining;

        public CraftingResult(ItemStack result, NonNullList<ItemStack> remaining) {
            this.result = result;
            this.remaining = remaining;
        }
    }

    public static class ImageCloningSerializer
    implements RecipeSerializer<ImageCloningRecipe> {
        public ImageCloningRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return new ImageCloningRecipe(resourceLocation, ShapedRecipe.m_151274_((JsonObject)jsonObject.getAsJsonObject("image")), Ingredient.m_43917_((JsonElement)jsonObject.getAsJsonObject("paper")));
        }

        public ImageCloningRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf packetBuffer) {
            return new ImageCloningRecipe(packetBuffer.m_130281_(), packetBuffer.m_130267_(), Ingredient.m_43940_((FriendlyByteBuf)packetBuffer));
        }

        public void toNetwork(FriendlyByteBuf packetBuffer, ImageCloningRecipe recipe) {
            packetBuffer.m_130085_(recipe.m_6423_());
            packetBuffer.m_130055_(recipe.image);
            recipe.paper.m_43923_(packetBuffer);
        }
    }
}

