/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.ResizeFrameScreen;
import de.maxhenkel.camera.items.ImageItem;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ImageEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> ID = SynchedEntityData.m_135353_(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Direction> FACING = SynchedEntityData.m_135353_(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Integer> WIDTH = SynchedEntityData.m_135353_(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HEIGHT = SynchedEntityData.m_135353_(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final AABB NULL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double THICKNESS = 0.0625;
    private static final int MAX_WIDTH = 8;
    private static final int MAX_HEIGHT = 8;

    public ImageEntity(EntityType type, Level world) {
        super(type, world);
        this.m_20011_(NULL_AABB);
    }

    public ImageEntity(Level world) {
        this((EntityType)Main.IMAGE_ENTITY_TYPE.get(), world);
    }

    public ImageEntity(Level world, double x, double y, double z) {
        this((EntityType)Main.IMAGE_ENTITY_TYPE.get(), world);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public void m_8119_() {
        this.updateBoundingBox();
        super.m_8119_();
        this.checkValid();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_() && this.canModify(player)) {
            if (this.f_19853_.f_46443_) {
                this.openClientGui();
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (this.hasImage()) {
            if (heldItem.m_41619_()) {
                ItemStack containedItem = this.removeImage();
                player.m_21008_(hand, containedItem);
                this.playRemoveSound();
            } else {
                ItemStack image = this.removeImage();
                this.playRemoveSound();
                if (!player.m_36356_(image)) {
                    this.dropItem(image);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!(heldItem.m_41720_() instanceof ImageItem)) {
            return InteractionResult.PASS;
        }
        UUID imageID = ImageData.getImageID(heldItem);
        if (imageID == null) {
            return InteractionResult.PASS;
        }
        ItemStack frameStack = heldItem.m_41620_(1);
        this.setItem(frameStack);
        this.setImageUUID(imageID);
        this.playAddSound();
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public boolean canModify(Player player) {
        if (!player.m_150110_().f_35938_) {
            return false;
        }
        if (!((Boolean)Main.SERVER_CONFIG.frameOnlyOwnerModify.get()).booleanValue()) {
            return true;
        }
        if (player.m_7500_() && player.m_20310_(1)) {
            return true;
        }
        if (!this.getOwner().isPresent()) {
            return true;
        }
        return this.getOwner().get().equals(player.m_20148_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui() {
        Minecraft.m_91087_().m_91152_((Screen)new ResizeFrameScreen(this.m_20148_()));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_19853_.f_46443_) {
            return true;
        }
        if (!(source.m_7640_() instanceof Player)) {
            return false;
        }
        if (!this.canModify((Player)source.m_7640_())) {
            return false;
        }
        if (this.hasImage()) {
            ItemStack image = this.removeImage();
            if (!this.f_19853_.f_46443_) {
                this.playRemoveSound();
                this.dropItem(image);
            }
            return true;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.removeFrame(source.m_7639_());
        return true;
    }

    public boolean isValid() {
        return this.f_19853_.m_45756_((Entity)this, this.m_20191_()) && this.f_19853_.m_6443_(ImageEntity.class, this.m_20191_().m_82310_(this.getFacing().m_122429_() == 0 ? 0.125 : 0.0, this.getFacing().m_122430_() == 0 ? 0.125 : 0.0, this.getFacing().m_122431_() == 0 ? 0.125 : 0.0), image -> image != this).isEmpty();
    }

    public void checkValid() {
        if (!this.isValid()) {
            this.removeFrame();
        }
    }

    public void onBroken(Entity entity) {
        if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        this.dropItem(new ItemStack((ItemLike)Main.FRAME_ITEM.get()));
        if (this.hasImage()) {
            this.dropItem(this.removeImage());
        }
    }

    public void resize(MessageResizeFrame.Direction direction, boolean larger) {
        int amount = larger ? 1 : -1;
        switch (direction) {
            case UP: {
                this.setFrameHeight(this.getFrameHeight() + amount);
                break;
            }
            case DOWN: {
                if (!this.setFrameHeight(this.getFrameHeight() + amount)) break;
                this.setImagePosition(this.m_20183_().m_5484_(Direction.DOWN, amount));
                break;
            }
            case RIGHT: {
                this.setFrameWidth(this.getFrameWidth() + amount);
                break;
            }
            case LEFT: {
                if (!this.setFrameWidth(this.getFrameWidth() + amount)) break;
                this.setImagePosition(this.m_20183_().m_5484_(this.getResizeOffset(), amount));
            }
        }
    }

    private Direction getResizeOffset() {
        switch (this.getFacing()) {
            default: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.NORTH;
            }
            case NORTH: {
                return Direction.EAST;
            }
            case SOUTH: 
        }
        return Direction.WEST;
    }

    public ItemStack getPickedResult(HitResult target) {
        if (this.hasImage()) {
            return this.getItem().m_41777_();
        }
        return new ItemStack((ItemLike)Main.FRAME_ITEM.get());
    }

    private void updateBoundingBox() {
        Direction facing = this.getFacing();
        if (facing.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_((float)facing.m_122416_() * 90.0f);
        } else {
            this.m_146926_(-90.0f * (float)facing.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_20011_(this.m_142242_());
    }

    protected AABB m_142242_() {
        return this.calculateBoundingBox(this.m_20183_(), this.getFacing(), this.getFrameWidth(), this.getFrameHeight());
    }

    private AABB calculateBoundingBox(BlockPos pos, Direction facing, double width, double height) {
        switch (facing) {
            default: {
                return new AABB((double)pos.m_123341_() + 1.0, (double)pos.m_123342_(), (double)pos.m_123343_() + 1.0 - 0.0625, (double)pos.m_123341_() - width + 1.0, (double)pos.m_123342_() + height, (double)pos.m_123343_() + 1.0);
            }
            case SOUTH: {
                return new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_() + width, (double)pos.m_123342_() + height, (double)pos.m_123343_() + 0.0625);
            }
            case WEST: {
                return new AABB((double)pos.m_123341_() + 1.0 - 0.0625, (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + height, (double)pos.m_123343_() + width);
            }
            case EAST: 
        }
        return new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_() + 1.0, (double)pos.m_123341_() + 0.0625, (double)pos.m_123342_() + height, (double)pos.m_123343_() - width + 1.0);
    }

    public BlockPos getCenterPosition() {
        Vec3 center = this.m_20191_().m_82399_();
        return new BlockPos.MutableBlockPos(center.f_82479_, center.f_82480_, center.f_82481_);
    }

    @Nullable
    public ItemEntity dropItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        BlockPos center = this.getCenterPosition();
        ItemEntity entityitem = new ItemEntity(this.f_19853_, (double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5, stack);
        entityitem.m_32060_();
        this.f_19853_.m_7967_((Entity)entityitem);
        return entityitem;
    }

    public void removeFrame(Entity source) {
        if (!this.m_213877_() && !this.f_19853_.f_46443_) {
            this.onBroken(source);
            this.m_6074_();
        }
    }

    public void removeFrame() {
        this.removeFrame(null);
    }

    protected boolean m_6093_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        return this.m_20191_();
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void playPlaceSound() {
        this.f_19853_.m_5594_(null, this.getCenterPosition(), SoundEvents.f_12176_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void playAddSound() {
        this.f_19853_.m_5594_(null, this.getCenterPosition(), SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void playRemoveSound() {
        this.f_19853_.m_5594_(null, this.getCenterPosition(), SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.f_19804_.m_135370_(OWNER);
    }

    public void setOwner(UUID owner) {
        this.f_19804_.m_135381_(OWNER, Optional.ofNullable(owner));
    }

    public Optional<UUID> getImageUUID() {
        return (Optional)this.f_19804_.m_135370_(ID);
    }

    public void setImageUUID(UUID uuid) {
        this.f_19804_.m_135381_(ID, Optional.ofNullable(uuid));
    }

    public int getFrameWidth() {
        return (Integer)this.f_19804_.m_135370_(WIDTH);
    }

    public int getFrameHeight() {
        return (Integer)this.f_19804_.m_135370_(HEIGHT);
    }

    public boolean setFrameWidth(int width) {
        if (width <= 0) {
            width = 1;
        } else if (width > 8) {
            width = 8;
        }
        int oldWidth = this.getFrameWidth();
        this.f_19804_.m_135381_(WIDTH, (Object)width);
        return oldWidth != width;
    }

    public boolean setFrameHeight(int height) {
        if (height <= 0) {
            height = 1;
        } else if (height > 8) {
            height = 8;
        }
        int oldHeight = this.getFrameHeight();
        this.f_19804_.m_135381_(HEIGHT, (Object)height);
        return oldHeight != height;
    }

    public ItemStack getItem() {
        return (ItemStack)this.f_19804_.m_135370_(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.f_19804_.m_135381_(ITEM, (Object)stack);
    }

    public void setImagePosition(BlockPos position) {
        this.m_7678_((double)position.m_123341_() + 0.5, position.m_123342_(), (double)position.m_123343_() + 0.5, this.m_146908_(), this.m_146909_());
        this.updateBoundingBox();
    }

    public void setFacing(Direction facing) {
        this.f_19804_.m_135381_(FACING, (Object)facing);
        this.updateBoundingBox();
    }

    public Direction getFacing() {
        return (Direction)this.f_19804_.m_135370_(FACING);
    }

    private boolean hasImage() {
        return !this.getItem().m_41619_();
    }

    private ItemStack removeImage() {
        ItemStack item = this.getItem();
        this.setItem(ItemStack.f_41583_);
        this.setImageUUID(null);
        return item;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID, Optional.empty());
        this.f_19804_.m_135372_(FACING, (Object)Direction.NORTH);
        this.f_19804_.m_135372_(WIDTH, (Object)1);
        this.f_19804_.m_135372_(HEIGHT, (Object)1);
        this.f_19804_.m_135372_(ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(OWNER, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        if (this.getImageUUID().isPresent()) {
            compound.m_128362_("image_id", this.getImageUUID().get());
        }
        if (this.getOwner().isPresent()) {
            compound.m_128362_("owner", this.getOwner().get());
        }
        compound.m_128405_("facing", this.getFacing().m_122411_());
        compound.m_128405_("width", this.getFrameWidth());
        compound.m_128405_("height", this.getFrameHeight());
        compound.m_128365_("item", (Tag)this.getItem().m_41739_(new CompoundTag()));
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("image_id")) {
            this.setImageUUID(compound.m_128342_("image_id"));
        }
        if (compound.m_128441_("owner")) {
            this.setOwner(compound.m_128342_("owner"));
        }
        this.setFacing(Direction.m_122376_((int)compound.m_128451_("facing")));
        this.setFrameWidth(compound.m_128451_("width"));
        this.setFrameHeight(compound.m_128451_("height"));
        this.setItem(ItemStack.m_41712_((CompoundTag)compound.m_128469_("item")));
        this.updateBoundingBox();
    }
}

