/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.items.ImageItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ImageData {
    private UUID id;
    private long time;
    private String owner;
    @Nullable
    private ResourceLocation biome;
    @Nullable
    private List<ResourceLocation> entities;

    private ImageData() {
    }

    public UUID getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public String getOwner() {
        return this.owner;
    }

    @Nullable
    public ResourceLocation getBiome() {
        return this.biome;
    }

    @Nullable
    public List<ResourceLocation> getEntities() {
        return this.entities;
    }

    @Nullable
    public static ImageData fromStack(ItemStack stack) {
        if (!(stack.getItem() instanceof ImageItem)) {
            return null;
        }
        ImageData data = new ImageData();
        UUID id = ImageData.getImageID(stack);
        if (id == null) {
            return null;
        }
        data.id = id;
        data.time = ImageData.getTime(stack);
        data.owner = ImageData.getOwner(stack);
        if (((Boolean)Main.SERVER_CONFIG.advancedImageData.get()).booleanValue()) {
            data.biome = ImageData.getBiome(stack);
            data.entities = ImageData.getEntities(stack);
        }
        return data;
    }

    public static ImageData create(ServerPlayer player, UUID imageID) {
        ImageData data = new ImageData();
        data.id = imageID;
        data.time = System.currentTimeMillis();
        data.owner = player.getName().getString();
        if (((Boolean)Main.SERVER_CONFIG.advancedImageData.get()).booleanValue()) {
            Biome biome = (Biome)player.level().getBiome(player.blockPosition()).value();
            data.biome = player.getServer().registryAccess().registry(Registries.BIOME).map(biomes -> biomes.getKey((Object)biome)).orElse(null);
            data.entities = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(128.0), e -> ImageData.canEntityBeSeen(player, (Entity)e)).stream().sorted(Comparator.comparingDouble(arg_0 -> ((ServerPlayer)player).distanceTo(arg_0))).map(ImageData::getEntityID).distinct().limit(((Integer)Main.SERVER_CONFIG.advancedDataMaxEntities.get()).intValue()).collect(Collectors.toList());
        }
        return data;
    }

    private static ResourceLocation getEntityID(Entity entity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
    }

    private static boolean canEntityBeSeen(ServerPlayer player, Entity entity) {
        Vec3 lookVec;
        if (player == entity) {
            return false;
        }
        Vec3 playerVec = new Vec3(player.getX(), player.getEyeY(), player.getZ());
        Vec3 entityVec = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        Vec3 lookVecToEntity = entityVec.subtract(playerVec).normalize();
        if (ImageData.angle(lookVecToEntity, lookVec = player.getLookAngle().normalize()) > 90.0) {
            return false;
        }
        return player.level().clip(new ClipContext(playerVec, entityVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).getType() == HitResult.Type.MISS;
    }

    private static double angle(Vec3 vec1, Vec3 vec2) {
        return Math.toDegrees(Math.acos(vec1.dot(vec2) / (vec1.length() * vec2.length())));
    }

    public static ImageData dummy() {
        ImageData data = new ImageData();
        data.id = new UUID(0L, 0L);
        data.time = System.currentTimeMillis();
        data.owner = "Steve";
        return data;
    }

    public void addToImage(ItemStack stack) {
        if (!(stack.getItem() instanceof ImageItem)) {
            return;
        }
        ImageData.setImageID(stack, this.id);
        ImageData.setTime(stack, this.time);
        ImageData.setOwner(stack, this.owner);
        if (this.biome != null) {
            ImageData.setBiome(stack, this.biome);
        }
        if (this.entities != null) {
            ImageData.setEntities(stack, this.entities);
        }
    }

    private static CompoundTag getImageTag(ItemStack stack) {
        assert (stack.getItem() instanceof ImageItem);
        CompoundTag compound = stack.getOrCreateTag();
        if (!compound.contains("image", 10)) {
            compound.put("image", (Tag)new CompoundTag());
        }
        return compound.getCompound("image");
    }

    private static void setImageID(ItemStack stack, UUID uuid) {
        CompoundTag compound = ImageData.getImageTag(stack);
        compound.putLong("image_id_most", uuid.getMostSignificantBits());
        compound.putLong("image_id_least", uuid.getLeastSignificantBits());
    }

    @Nullable
    public static UUID getImageID(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.contains("image_id_most", 4) || !compound.contains("image_id_least", 4)) {
            return null;
        }
        long most = compound.getLong("image_id_most");
        long least = compound.getLong("image_id_least");
        return new UUID(most, least);
    }

    private static void setTime(ItemStack stack, long time) {
        CompoundTag compound = ImageData.getImageTag(stack);
        compound.putLong("image_time", time);
    }

    private static long getTime(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.contains("image_time", 4)) {
            return 0L;
        }
        return compound.getLong("image_time");
    }

    private static void setOwner(ItemStack stack, String name) {
        CompoundTag compound = ImageData.getImageTag(stack);
        compound.putString("owner", name);
    }

    private static String getOwner(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.contains("owner", 8)) {
            return "";
        }
        return compound.getString("owner");
    }

    private static void setBiome(ItemStack stack, ResourceLocation biome) {
        CompoundTag compound = ImageData.getImageTag(stack);
        compound.putString("biome", biome.toString());
    }

    @Nullable
    private static ResourceLocation getBiome(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.contains("biome", 8)) {
            return null;
        }
        return new ResourceLocation(compound.getString("biome"));
    }

    private static void setEntities(ItemStack stack, List<ResourceLocation> entities) {
        CompoundTag compound = ImageData.getImageTag(stack);
        ListTag list = new ListTag();
        for (ResourceLocation entity : entities) {
            list.add((Object)StringTag.valueOf((String)entity.toString()));
        }
        compound.put("entities", (Tag)list);
    }

    @Nullable
    private static List<ResourceLocation> getEntities(ItemStack stack) {
        CompoundTag compound = ImageData.getImageTag(stack);
        if (!compound.contains("entities", 9)) {
            return null;
        }
        ListTag entities = compound.getList("entities", 8);
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Tag e : entities) {
            list.add(new ResourceLocation(e.getAsString()));
        }
        return list;
    }
}

