/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import de.maxhenkel.camera.ImageProcessor;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="camera", value={Dist.CLIENT})
public class ImageTaker {
    private static boolean takeScreenshot;
    private static UUID uuid;
    private static boolean hide;

    public static void takeScreenshot(UUID id) {
        if (takeScreenshot && id.equals(uuid)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        hide = mc.options.hideGui;
        mc.options.hideGui = true;
        takeScreenshot = true;
        uuid = id;
        mc.setScreen(null);
    }

    @SubscribeEvent
    public static void onRenderTickEnd(TickEvent.RenderTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        if (!takeScreenshot) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        NativeImage image = Screenshot.takeScreenshot((RenderTarget)mc.getMainRenderTarget());
        mc.options.hideGui = hide;
        takeScreenshot = false;
        ImageProcessor.sendScreenshotThreaded(uuid, image);
    }
}

