/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ClientConfig;
import de.maxhenkel.camera.ClientEvents;
import de.maxhenkel.camera.CreativeTabEvents;
import de.maxhenkel.camera.ImageCloningRecipe;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.ServerConfig;
import de.maxhenkel.camera.corelib.ClientRegistry;
import de.maxhenkel.camera.corelib.CommonRegistry;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.entities.ImageRenderer;
import de.maxhenkel.camera.gui.AlbumContainer;
import de.maxhenkel.camera.gui.AlbumInventoryContainer;
import de.maxhenkel.camera.gui.AlbumInventoryScreen;
import de.maxhenkel.camera.gui.LecternAlbumScreen;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.items.ImageFrameItem;
import de.maxhenkel.camera.items.ImageItem;
import de.maxhenkel.camera.net.MessageAlbumPage;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import de.maxhenkel.camera.net.MessagePartialImage;
import de.maxhenkel.camera.net.MessageRequestImage;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageResizeFrame;
import de.maxhenkel.camera.net.MessageSetShader;
import de.maxhenkel.camera.net.MessageTakeBook;
import de.maxhenkel.camera.net.MessageTakeImage;
import de.maxhenkel.camera.net.MessageUploadCustomImage;
import de.maxhenkel.camera.net.PacketManager;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="camera")
public class Main {
    public static final String MODID = "camera";
    public static final Logger LOGGER = LogManager.getLogger((String)"camera");
    public static PacketManager PACKET_MANAGER;
    private static final DeferredRegister<Item> ITEM_REGISTER;
    public static final DeferredHolder<Item, ImageFrameItem> FRAME_ITEM;
    public static final DeferredHolder<Item, CameraItem> CAMERA;
    public static final DeferredHolder<Item, ImageItem> IMAGE;
    public static final DeferredHolder<Item, AlbumItem> ALBUM;
    private static final DeferredRegister<MenuType<?>> MENU_REGISTER;
    public static final DeferredHolder<MenuType<?>, MenuType<AlbumInventoryContainer>> ALBUM_INVENTORY_CONTAINER;
    public static final DeferredHolder<MenuType<?>, MenuType<AlbumContainer>> ALBUM_CONTAINER;
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER;
    public static final DeferredHolder<EntityType<?>, EntityType<ImageEntity>> IMAGE_ENTITY_TYPE;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_REGISTER;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ImageCloningRecipe>> IMAGE_CLONING_SERIALIZER;
    public static TagKey<Item> IMAGE_PAPER;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyMapping KEY_NEXT;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyMapping KEY_PREVIOUS;

    public Main(IEventBus eventBus) {
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::onRegisterPayloadHandler);
        eventBus.addListener(CreativeTabEvents::onCreativeModeTabBuildContents);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class, true);
        if (FMLEnvironment.dist.isClient()) {
            eventBus.addListener(this::clientSetup);
            eventBus.addListener(this::registerKeyBinds);
        }
        ITEM_REGISTER.register(eventBus);
        MENU_REGISTER.register(eventBus);
        ENTITY_REGISTER.register(eventBus);
        RECIPE_SERIALIZER_REGISTER.register(eventBus);
        ModSounds.SOUND_REGISTER.register(eventBus);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        PACKET_MANAGER = new PacketManager();
    }

    private static EntityType<ImageEntity> createImageEntityType() {
        return CommonRegistry.registerEntity(MODID, "image_frame", MobCategory.MISC, ImageEntity.class, builder -> builder.setTrackingRange(256).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).sized(1.0f, 1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new ClientEvents());
        ClientRegistry.registerScreen((MenuType)ALBUM_INVENTORY_CONTAINER.get(), AlbumInventoryScreen::new);
        ClientRegistry.registerScreen((MenuType)ALBUM_CONTAINER.get(), LecternAlbumScreen::new);
        EntityRenderers.register((EntityType)((EntityType)IMAGE_ENTITY_TYPE.get()), ImageRenderer::new);
    }

    public void onRegisterPayloadHandler(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(MODID).versioned("0");
        CommonRegistry.registerMessage(registrar, MessagePartialImage.class);
        CommonRegistry.registerMessage(registrar, MessageTakeImage.class);
        CommonRegistry.registerMessage(registrar, MessageRequestImage.class);
        CommonRegistry.registerMessage(registrar, MessageImage.class);
        CommonRegistry.registerMessage(registrar, MessageImageUnavailable.class);
        CommonRegistry.registerMessage(registrar, MessageSetShader.class);
        CommonRegistry.registerMessage(registrar, MessageDisableCameraMode.class);
        CommonRegistry.registerMessage(registrar, MessageResizeFrame.class);
        CommonRegistry.registerMessage(registrar, MessageRequestUploadCustomImage.class);
        CommonRegistry.registerMessage(registrar, MessageUploadCustomImage.class);
        CommonRegistry.registerMessage(registrar, MessageAlbumPage.class);
        CommonRegistry.registerMessage(registrar, MessageTakeBook.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerKeyBinds(RegisterKeyMappingsEvent event) {
        KEY_NEXT = new KeyMapping("key.next_image", 264, "key.categories.misc");
        KEY_PREVIOUS = new KeyMapping("key.previous_image", 265, "key.categories.misc");
        event.register(KEY_NEXT);
        event.register(KEY_PREVIOUS);
    }

    static {
        ITEM_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)MODID);
        FRAME_ITEM = ITEM_REGISTER.register("image_frame", ImageFrameItem::new);
        CAMERA = ITEM_REGISTER.register(MODID, CameraItem::new);
        IMAGE = ITEM_REGISTER.register("image", ImageItem::new);
        ALBUM = ITEM_REGISTER.register("album", AlbumItem::new);
        MENU_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)MODID);
        ALBUM_INVENTORY_CONTAINER = MENU_REGISTER.register("album_inventory", () -> IMenuTypeExtension.create((windowId, inv, data) -> new AlbumInventoryContainer(windowId, (Container)inv)));
        ALBUM_CONTAINER = MENU_REGISTER.register("album", () -> IMenuTypeExtension.create((windowId, inv, data) -> new AlbumContainer(windowId)));
        ENTITY_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)MODID);
        IMAGE_ENTITY_TYPE = ENTITY_REGISTER.register("image_frame", Main::createImageEntityType);
        RECIPE_SERIALIZER_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)MODID);
        IMAGE_CLONING_SERIALIZER = RECIPE_SERIALIZER_REGISTER.register("image_cloning", ImageCloningRecipe.ImageCloningSerializer::new);
        IMAGE_PAPER = ItemTags.create((ResourceLocation)new ResourceLocation(MODID, "image_paper"));
    }
}

