/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.AlbumContainer;
import de.maxhenkel.camera.gui.AlbumScreen;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.net.MessageAlbumPage;
import de.maxhenkel.camera.net.MessageTakeBook;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class LecternAlbumScreen
extends AlbumScreen {
    private final AlbumContainer albumContainer;
    private final ContainerListener listener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu containerToSend, int slotInd, ItemStack stack) {
            LecternAlbumScreen.this.updateContents();
        }

        public void dataChanged(AbstractContainerMenu containerIn, int varToUpdate, int newValue) {
            if (varToUpdate == 0) {
                LecternAlbumScreen.this.updatePage();
            }
        }
    };

    public LecternAlbumScreen(AlbumContainer albumContainer, Inventory inv, Component titleIn) {
        super(albumContainer, inv, titleIn);
        this.albumContainer = albumContainer;
    }

    public AlbumContainer getMenu() {
        return this.albumContainer;
    }

    protected void init() {
        super.init();
        this.albumContainer.addSlotListener(this.listener);
        if (this.minecraft.player.mayBuild()) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"lectern.take_book"), button -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageTakeBook()})).bounds(this.width / 2 - 50, this.height - 25, 100, 20).build());
        }
    }

    public void onClose() {
        super.onClose();
        this.albumContainer.removeSlotListener(this.listener);
    }

    @Override
    protected void next() {
        super.next();
        this.sendPageUpdate(this.index);
    }

    @Override
    protected void previous() {
        super.previous();
        this.sendPageUpdate(this.index);
    }

    private void sendPageUpdate(int page) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageAlbumPage(page)});
    }

    @Override
    protected void playPageTurnSound() {
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void updateContents() {
        this.images = ((AlbumItem)((Object)Main.ALBUM.get())).getImages(this.albumContainer.getAlbum());
    }

    private void updatePage() {
        this.setIndex(this.albumContainer.getPage());
    }
}

