/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;

public class ResizeFrameScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/resize_frame.png");
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 50;
    private UUID uuid;
    private float visibility;
    private Button visibilityButton;
    private long lastCheck;

    public ResizeFrameScreen(UUID uuid) {
        super((AbstractContainerMenu)new DummyContainer(), Minecraft.getInstance().player.getInventory(), (Component)Component.translatable((String)"gui.frame.resize"));
        this.uuid = uuid;
        this.visibility = ((Double)Main.CLIENT_CONFIG.resizeGuiOpacity.get()).floatValue();
        this.imageWidth = 248;
        this.imageHeight = 109;
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        int left = (this.width - this.imageWidth) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.sendMoveImage(MessageResizeFrame.Direction.LEFT)).bounds(left + 10, this.height / 2 - 10, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.sendMoveImage(MessageResizeFrame.Direction.RIGHT)).bounds(left + this.imageWidth - 50 - 10, this.height / 2 - 10, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.sendMoveImage(MessageResizeFrame.Direction.UP)).bounds(this.width / 2 - 25, this.topPos + 10, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> this.sendMoveImage(MessageResizeFrame.Direction.DOWN)).bounds(this.width / 2 - 25, this.topPos + this.imageHeight - 10 - 20, 50, 20).build());
        this.visibilityButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"tooltip.visibility_short"), button -> {
            this.visibility = (float)((double)this.visibility - 0.25);
            if (this.visibility < 0.0f) {
                this.visibility = 1.0f;
            }
            Main.CLIENT_CONFIG.resizeGuiOpacity.set((Object)this.visibility);
            Main.CLIENT_CONFIG.resizeGuiOpacity.save();
        }).bounds(left + this.imageWidth - 20 - 10, this.topPos + 10, 20, 20).build());
    }

    private void sendMoveImage(MessageResizeFrame.Direction direction) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageResizeFrame(this.uuid, direction, !Screen.hasShiftDown())});
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visibility >= 1.0f) {
            this.renderTransparentBackground(guiGraphics);
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.visibility);
        guiGraphics.blit(CAMERA_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        MutableComponent title = Component.translatable((String)"gui.frame.resize");
        int titleWidth = this.font.width((FormattedText)title);
        FormattedCharSequence formattedCharSequence = title.getVisualOrderText();
        int n = this.imageWidth / 2 - titleWidth / 2;
        int n2 = this.imageHeight / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, formattedCharSequence, n, n2 - 9 - 1, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
        MutableComponent description = Component.translatable((String)"gui.frame.resize_description");
        int descriptionWidth = this.font.width((FormattedText)description);
        guiGraphics.drawString(this.font, description.getVisualOrderText(), this.imageWidth / 2 - descriptionWidth / 2, this.imageHeight / 2 + 1, ChatFormatting.GRAY.getColor().intValue(), false);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.visibility);
        if (Screen.hasShiftDown()) {
            guiGraphics.blit(CAMERA_TEXTURE, this.imageWidth / 2 - 8, 12, 16, 109, 16, 16);
            guiGraphics.blit(CAMERA_TEXTURE, this.imageWidth / 2 - 8, this.imageHeight - 10 - 20 + 2, 0, 109, 16, 16);
            guiGraphics.blit(CAMERA_TEXTURE, 27, this.imageHeight / 2 - 10 + 3, 0, 125, 16, 16);
            guiGraphics.blit(CAMERA_TEXTURE, this.imageWidth - 10 - 25 - 8, this.imageHeight / 2 - 10 + 3, 16, 125, 16, 16);
        } else {
            guiGraphics.blit(CAMERA_TEXTURE, this.imageWidth / 2 - 8, 12, 0, 109, 16, 16);
            guiGraphics.blit(CAMERA_TEXTURE, this.imageWidth / 2 - 8, this.imageHeight - 10 - 20 + 2, 16, 109, 16, 16);
            guiGraphics.blit(CAMERA_TEXTURE, 27, this.imageHeight / 2 - 10 + 3, 16, 125, 16, 16);
            guiGraphics.blit(CAMERA_TEXTURE, this.imageWidth - 10 - 25 - 8, this.imageHeight / 2 - 10 + 3, 0, 125, 16, 16);
        }
        if (this.visibilityButton.isHovered()) {
            guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"tooltip.visibility").getVisualOrderText()), mouseX - this.leftPos, mouseY - this.topPos);
        }
        guiGraphics.pose().popPose();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }

    public void containerTick() {
        super.containerTick();
        if (System.currentTimeMillis() - this.lastCheck > 500L) {
            if (!this.isImagePresent()) {
                this.minecraft.player.closeContainer();
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public boolean isImagePresent() {
        AABB aabb = this.minecraft.player.getBoundingBox();
        aabb = aabb.inflate(32.0);
        return this.minecraft.level.getEntitiesOfClass(ImageEntity.class, aabb).stream().anyMatch(image -> image.getUUID().equals(this.uuid) && image.distanceTo((Entity)this.minecraft.player) <= 32.0f);
    }
}

