/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.inventory;

import de.maxhenkel.camera.items.ImageItem;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AlbumInventory
implements Container {
    private NonNullList<ItemStack> items;
    private ItemStack album;
    private int invSize;
    private CompoundTag inventoryTag;

    public AlbumInventory(ItemStack album) {
        assert (!album.isEmpty());
        this.album = album;
        this.invSize = 54;
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        CompoundTag c = album.getOrCreateTag();
        if (c.contains("Images")) {
            this.inventoryTag = c.getCompound("Images");
            ContainerHelper.loadAllItems((CompoundTag)this.inventoryTag, this.items);
        }
    }

    public int getContainerSize() {
        return this.invSize;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        this.setChanged();
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        if (this.inventoryTag == null) {
            CompoundTag tag = this.album.getOrCreateTag();
            this.inventoryTag = new CompoundTag();
            tag.put("Images", (Tag)this.inventoryTag);
        }
        ContainerHelper.saveAllItems((CompoundTag)this.inventoryTag, this.items, (boolean)true);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return !(stack.getItem() instanceof ImageItem);
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean stillValid(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!player.getItemInHand(hand).equals(this.album)) continue;
            return true;
        }
        return false;
    }
}

