/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.net.Message;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessagePartialImage
implements Message<MessagePartialImage> {
    public static ResourceLocation ID = new ResourceLocation("camera", "partial_image");
    private UUID imgUUID;
    private int offset;
    private int length;
    private byte[] bytes;

    public MessagePartialImage() {
    }

    public MessagePartialImage(UUID imgUUID, int offset, int length, byte[] bytes) {
        this.imgUUID = imgUUID;
        this.offset = offset;
        this.length = length;
        this.bytes = bytes;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(PlayPayloadContext context) {
        Object var3_2 = context.player().orElse(null);
        if (!(var3_2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = var3_2;
        Main.PACKET_MANAGER.addBytes(sender, this.imgUUID, this.offset, this.length, this.bytes);
    }

    @Override
    public MessagePartialImage fromBytes(FriendlyByteBuf buf) {
        this.imgUUID = buf.readUUID();
        this.offset = buf.readInt();
        this.length = buf.readInt();
        this.bytes = buf.readByteArray();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.imgUUID);
        buf.writeInt(this.offset);
        buf.writeInt(this.length);
        buf.writeByteArray(this.bytes);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

